/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.network;

import igentuman.mbtool.Mbtool;
import igentuman.mbtool.util.MultiblockStructure;
import igentuman.mbtool.util.MultiblocksProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class SyncStructuresPacket {
    private final List<StructureData> structures = new ArrayList<StructureData>();

    public SyncStructuresPacket(List<MultiblockStructure> structures) {
        for (MultiblockStructure structure : structures) {
            this.structures.add(new StructureData(structure.getId(), structure.getStructureNbt(), structure.getName()));
        }
    }

    private SyncStructuresPacket() {
    }

    public static void encode(SyncStructuresPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.structures.size());
        for (StructureData structure : packet.structures) {
            buffer.m_130085_(Objects.requireNonNullElseGet(structure.id, () -> Mbtool.rl("unknown")));
            buffer.m_130079_(Objects.requireNonNullElseGet(structure.nbt, CompoundTag::new));
            buffer.m_130070_(Objects.requireNonNullElseGet(structure.name, () -> ""));
        }
    }

    public static SyncStructuresPacket decode(FriendlyByteBuf buffer) {
        SyncStructuresPacket packet = new SyncStructuresPacket();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buffer.m_130281_();
            CompoundTag nbt = buffer.m_130260_();
            String name = buffer.m_130277_();
            packet.structures.add(new StructureData(id, nbt, name));
        }
        return packet;
    }

    public static void handle(SyncStructuresPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ArrayList<MultiblockStructure> clientStructures = new ArrayList<MultiblockStructure>();
            for (StructureData structureData : packet.structures) {
                MultiblockStructure structure = new MultiblockStructure(structureData.id, structureData.nbt, structureData.name);
                clientStructures.add(structure);
            }
            MultiblocksProvider.setStructures(clientStructures);
        });
        context.setPacketHandled(true);
    }

    private static class StructureData {
        final ResourceLocation id;
        final CompoundTag nbt;
        final String name;

        StructureData(ResourceLocation id, CompoundTag nbt, String name) {
            this.id = id;
            this.nbt = nbt;
            this.name = name;
        }
    }
}

