/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.util;

import igentuman.mbtool.config.MbtoolConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockEquivalencyManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<Block, Set<Block>> equivalencyMap = new HashMap<Block, Set<Block>>();
    private static boolean initialized = false;

    public static void initialize() {
        equivalencyMap.clear();
        List<? extends String> equivalencySets = MbtoolConfig.getBlockEquivalencySets();
        for (String string : equivalencySets) {
            if (string == null || string.trim().isEmpty()) continue;
            String[] blockIds = string.split(",");
            HashSet<Block> blockSet = new HashSet<Block>();
            for (String blockId : blockIds) {
                if ((blockId = blockId.trim()).isEmpty()) continue;
                try {
                    ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)blockId);
                    if (resourceLocation == null) {
                        LOGGER.warn("Invalid block ID format in equivalency set: {}", (Object)blockId);
                        continue;
                    }
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
                    if (block == null || block == Blocks.f_50016_) continue;
                    blockSet.add(block);
                }
                catch (Exception e) {
                    LOGGER.warn("Invalid block ID in equivalency set: {}", (Object)blockId);
                }
            }
            if (blockSet.size() <= 1) continue;
            for (Block block : blockSet) {
                equivalencyMap.computeIfAbsent(block, k -> new HashSet()).addAll(blockSet);
                equivalencyMap.get(block).remove(block);
            }
        }
        initialized = true;
        LOGGER.info("Loaded {} block equivalency sets with {} total block mappings", (Object)equivalencySets.size(), (Object)equivalencyMap.size());
    }

    public static Set<Block> getEquivalentBlocks(Block block) {
        if (!initialized) {
            BlockEquivalencyManager.initialize();
        }
        HashSet<Block> equivalents = new HashSet<Block>();
        equivalents.add(block);
        Set<Block> configuredEquivalents = equivalencyMap.get(block);
        if (configuredEquivalents != null) {
            equivalents.addAll(configuredEquivalents);
        }
        return equivalents;
    }

    public static boolean areBlocksEquivalent(Block block1, Block block2) {
        Set<Block> equivalents;
        if (block1 == block2) {
            return true;
        }
        if (!initialized) {
            BlockEquivalencyManager.initialize();
        }
        return (equivalents = equivalencyMap.get(block1)) != null && equivalents.contains(block2);
    }

    public static Block findReplacement(Block requiredBlock, Map<Block, Integer> availableBlocks) {
        if (!initialized) {
            BlockEquivalencyManager.initialize();
        }
        if (availableBlocks.getOrDefault(requiredBlock, 0) > 0) {
            return requiredBlock;
        }
        Set<Block> equivalents = BlockEquivalencyManager.getEquivalentBlocks(requiredBlock);
        for (Block equivalent : equivalents) {
            if (availableBlocks.getOrDefault(equivalent, 0) <= 0) continue;
            return equivalent;
        }
        return null;
    }

    public static void reinitialize() {
        initialized = false;
        BlockEquivalencyManager.initialize();
    }
}

