/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.util;

import com.gregtechceu.gtceu.api.capability.compat.FeCompat;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import igentuman.mbtool.util.MultiblockStructure;
import igentuman.mbtool.util.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class GTUtils {
    public static void loadGtStructures(List<MultiblockStructure> loadedStructures) {
        List<MultiblockMachineDefinition> GT_MACHINES = GTRegistries.MACHINES.values().stream().filter(MultiblockMachineDefinition.class::isInstance).map(MultiblockMachineDefinition.class::cast).filter(MultiblockMachineDefinition::isRenderXEIPreview).toList();
        for (MultiblockMachineDefinition definition : GT_MACHINES) {
            MultiblockShapeInfo info;
            CompoundTag structureNbt;
            List shapeInfos = definition.getMatchingShapes();
            if (shapeInfos.isEmpty() || (structureNbt = GTUtils.convertShapeInfoToNBT(info = (MultiblockShapeInfo)shapeInfos.get(0))) == null) continue;
            String machineName = definition.getId().m_135815_();
            MultiblockStructure structure = new MultiblockStructure(definition.getId(), structureNbt, "gt_" + machineName);
            loadedStructures.add(structure);
        }
    }

    public static CompoundTag convertShapeInfoToNBT(MultiblockShapeInfo shapeInfo) {
        try {
            CompoundTag nbt = new CompoundTag();
            ListTag blocksList = new ListTag();
            ListTag palette = new ListTag();
            HashMap<String, Integer> paletteMap = new HashMap<String, Integer>();
            AtomicInteger paletteIndex = new AtomicInteger(0);
            BlockInfo[][][] blocks = shapeInfo.getBlocks();
            int depth = blocks.length;
            int height = depth > 0 ? blocks[0].length : 0;
            int width = height > 0 ? blocks[0][0].length : 0;
            for (int z = 0; z < depth; ++z) {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        BlockState blockState;
                        BlockInfo blockInfo = blocks[z][y][x];
                        if (blockInfo == null || (blockState = blockInfo.getBlockState()).m_60795_()) continue;
                        Block block = blockState.m_60734_();
                        String blockName = ForgeRegistries.BLOCKS.getKey((Object)block).toString();
                        String blockStateString = GTUtils.getBlockStateString(blockState);
                        if (!paletteMap.containsKey(blockStateString)) {
                            CompoundTag paletteEntry = new CompoundTag();
                            paletteEntry.m_128359_("Name", blockName);
                            if (!blockState.m_61147_().isEmpty()) {
                                CompoundTag properties = new CompoundTag();
                                for (Property property : blockState.m_61147_()) {
                                    String propertyName = property.m_61708_();
                                    if (!propertyName.equals("facing")) continue;
                                    String propertyValue = GTUtils.getPropertyValueString(blockState, property);
                                    if (propertyName.equals("facing")) {
                                        propertyValue = GTUtils.invertFacingDirection(propertyValue);
                                    }
                                    properties.m_128359_(propertyName, propertyValue);
                                }
                                paletteEntry.m_128365_("Properties", (Tag)properties);
                            }
                            palette.add((Object)paletteEntry);
                            paletteMap.put(blockStateString, paletteIndex.getAndIncrement());
                        }
                        CompoundTag blockEntry = new CompoundTag();
                        ListTag pos = new ListTag();
                        pos.add((Object)IntTag.m_128679_((int)x));
                        pos.add((Object)IntTag.m_128679_((int)y));
                        pos.add((Object)IntTag.m_128679_((int)z));
                        blockEntry.m_128365_("pos", (Tag)pos);
                        blockEntry.m_128405_("state", ((Integer)paletteMap.get(blockStateString)).intValue());
                        blocksList.add((Object)blockEntry);
                    }
                }
            }
            nbt.m_128365_("blocks", (Tag)blocksList);
            nbt.m_128365_("palette", (Tag)palette);
            return nbt;
        }
        catch (Exception e) {
            System.err.println("Failed to convert MultiblockShapeInfo to NBT: " + e.getMessage());
            return null;
        }
    }

    private static String invertFacingDirection(String facing) {
        switch (facing.toLowerCase()) {
            case "north": {
                return "south";
            }
            case "south": {
                return "north";
            }
            case "east": {
                return "west";
            }
            case "west": {
                return "east";
            }
            case "up": {
                return "down";
            }
            case "down": {
                return "up";
            }
        }
        return facing;
    }

    private static String getBlockStateString(BlockState blockState) {
        StringBuilder sb = new StringBuilder();
        Block block = blockState.m_60734_();
        sb.append(ForgeRegistries.BLOCKS.getKey((Object)block).toString());
        if (!blockState.m_61147_().isEmpty()) {
            sb.append("[");
            boolean first = true;
            for (Property property : blockState.m_61147_()) {
                if (!property.m_61708_().equals("facing")) continue;
                if (!first) {
                    sb.append(",");
                }
                String propertyValue = GTUtils.getPropertyValueString(blockState, property);
                if (property.m_61708_().equals("facing")) {
                    propertyValue = GTUtils.invertFacingDirection(propertyValue);
                }
                sb.append(property.m_61708_()).append("=").append(propertyValue);
                first = false;
            }
            sb.append("]");
        }
        return sb.toString();
    }

    private static <T extends Comparable<T>> String getPropertyValueString(BlockState blockState, Property<T> property) {
        Comparable value = blockState.m_61143_(property);
        return property.m_6940_(value);
    }

    public static String formatEUEnergy(int energy) {
        if ((energy /= GTUtils.FE2EURatio()) >= 1000000) {
            return TextUtils.numberFormat((double)energy / 1000000.0) + " MEU";
        }
        if (energy >= 1000) {
            return TextUtils.numberFormat((double)energy / 1000.0) + " kEU";
        }
        return TextUtils.numberFormat(energy) + " EU";
    }

    public static int convert2FE(long eu) {
        long converted = eu * (long)GTUtils.FE2EURatio();
        if (converted > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (converted < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)converted;
    }

    public static int convert2EU(int fe) {
        return fe / GTUtils.FE2EURatio();
    }

    public static int FE2EURatio() {
        return FeCompat.ratio((boolean)true);
    }

    public static int EU2FERatio() {
        return FeCompat.ratio((boolean)false);
    }
}

