/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.util;

import igentuman.mbtool.Mbtool;
import igentuman.mbtool.util.MultiblockStructure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class MekanismStructureGenerator {
    public static MultiblockStructure generate(List<ItemStack> blocks, int height, int width, int length) {
        if (MekanismStructureGenerator.isSetForTurbine(blocks)) {
            return MekanismStructureGenerator.generateTurbine(blocks, height, width, length);
        }
        if (MekanismStructureGenerator.isSetForFissionReactor(blocks)) {
            return MekanismStructureGenerator.generateFissionReactor(blocks, height, width, length);
        }
        if (MekanismStructureGenerator.isSetForBoiler(blocks)) {
            return MekanismStructureGenerator.generateBoiler(blocks, height, width, length);
        }
        return null;
    }

    private static MultiblockStructure generateBoiler(List<ItemStack> blocks, int height, int width, int length) {
        MultiblockStructure structure = new MultiblockStructure(Mbtool.rl("runtime"), new CompoundTag(), "mekanism_boiler");
        return structure;
    }

    private static MultiblockStructure generateFissionReactor(List<ItemStack> blocks, int height, int width, int length) {
        if (!MekanismStructureGenerator.validateDimensions(height, width, length)) {
            return null;
        }
        Map<String, Integer> availableBlocks = MekanismStructureGenerator.createBlockAvailabilityMap(blocks);
        HashMap<String, Integer> usedBlocks = new HashMap<String, Integer>();
        CompoundTag nbt = new CompoundTag();
        ListTag blocksList = new ListTag();
        ListTag palette = new ListTag();
        HashMap<String, Integer> paletteMap = new HashMap<String, Integer>();
        AtomicInteger paletteIndex = new AtomicInteger(0);
        ArrayList<BlockPosition> wallPositions = new ArrayList<BlockPosition>();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    String blockType = MekanismStructureGenerator.determineBlockType(x, y, z, width, height, length, availableBlocks, usedBlocks);
                    if (blockType != null && MekanismStructureGenerator.canUseBlock(blockType, availableBlocks, usedBlocks)) {
                        MekanismStructureGenerator.addBlockToStructure(blocksList, palette, paletteMap, x, y, z, blockType, paletteIndex);
                        usedBlocks.put(blockType, usedBlocks.getOrDefault(blockType, 0) + 1);
                    }
                    if (!MekanismStructureGenerator.isWallPosition(x, y, z, width, height, length) || MekanismStructureGenerator.isCornerPosition(x, y, z, width, height, length) || MekanismStructureGenerator.isEdgePosition(x, y, z, width, height, length) || y <= 0 || y >= height - 1) continue;
                    wallPositions.add(new BlockPosition(x, y, z));
                }
            }
        }
        MekanismStructureGenerator.addRandomPorts(blocks, wallPositions, availableBlocks, usedBlocks, blocksList, palette, paletteMap, paletteIndex, width, height, length);
        nbt.m_128365_("blocks", (Tag)blocksList);
        nbt.m_128365_("palette", (Tag)palette);
        MultiblockStructure structure = new MultiblockStructure(Mbtool.rl("runtime"), nbt, "mekanism_fission_reactor");
        return structure;
    }

    private static MultiblockStructure generateTurbine(List<ItemStack> blocks, int height, int width, int length) {
        String blockType;
        int y;
        int z;
        int x;
        if (!MekanismStructureGenerator.validateTurbineDimensions(height, width, length)) {
            return null;
        }
        Map<String, Integer> availableBlocks = MekanismStructureGenerator.createBlockAvailabilityMap(blocks);
        HashMap<String, Integer> usedBlocks = new HashMap<String, Integer>();
        CompoundTag nbt = new CompoundTag();
        ListTag blocksList = new ListTag();
        ListTag palette = new ListTag();
        HashMap<String, Integer> paletteMap = new HashMap<String, Integer>();
        AtomicInteger paletteIndex = new AtomicInteger(0);
        ArrayList<BlockPosition> wallPositions = new ArrayList<BlockPosition>();
        for (x = 0; x < width; ++x) {
            for (z = 0; z < length; ++z) {
                y = 0;
                blockType = MekanismStructureGenerator.determineTurbineBlockType(x, y, z, width, height, length, availableBlocks, usedBlocks);
                if (blockType == null || !MekanismStructureGenerator.canUseBlock(blockType, availableBlocks, usedBlocks)) continue;
                MekanismStructureGenerator.addBlockToStructure(blocksList, palette, paletteMap, x, y, z, blockType, paletteIndex);
                usedBlocks.put(blockType, usedBlocks.getOrDefault(blockType, 0) + 1);
            }
        }
        for (x = 0; x < width; ++x) {
            for (z = 0; z < length; ++z) {
                y = height - 1;
                blockType = MekanismStructureGenerator.determineTurbineBlockType(x, y, z, width, height, length, availableBlocks, usedBlocks);
                if (blockType == null || !MekanismStructureGenerator.canUseBlock(blockType, availableBlocks, usedBlocks)) continue;
                MekanismStructureGenerator.addBlockToStructure(blocksList, palette, paletteMap, x, y, z, blockType, paletteIndex);
                usedBlocks.put(blockType, usedBlocks.getOrDefault(blockType, 0) + 1);
            }
        }
        for (x = 0; x < width; ++x) {
            for (int y2 = 1; y2 < height - 1; ++y2) {
                for (int z2 = 0; z2 < length; ++z2) {
                    blockType = MekanismStructureGenerator.determineTurbineBlockType(x, y2, z2, width, height, length, availableBlocks, usedBlocks);
                    if (blockType != null && MekanismStructureGenerator.canUseBlock(blockType, availableBlocks, usedBlocks)) {
                        MekanismStructureGenerator.addBlockToStructure(blocksList, palette, paletteMap, x, y2, z2, blockType, paletteIndex);
                        usedBlocks.put(blockType, usedBlocks.getOrDefault(blockType, 0) + 1);
                    }
                    if (!MekanismStructureGenerator.isWallPosition(x, y2, z2, width, height, length) || MekanismStructureGenerator.isCornerPosition(x, y2, z2, width, height, length) || MekanismStructureGenerator.isEdgePosition(x, y2, z2, width, height, length) || y2 <= 0 || y2 >= height - 1) continue;
                    wallPositions.add(new BlockPosition(x, y2, z2));
                }
            }
        }
        MekanismStructureGenerator.addTurbinePorts(wallPositions, availableBlocks, usedBlocks, blocksList, palette, paletteMap, paletteIndex, width, height, length);
        nbt.m_128365_("blocks", (Tag)blocksList);
        nbt.m_128365_("palette", (Tag)palette);
        MultiblockStructure structure = new MultiblockStructure(Mbtool.rl("runtime"), nbt, "mekanism_turbine");
        return structure;
    }

    private static boolean isSetForBoiler(List<ItemStack> blocks) {
        for (ItemStack block : blocks) {
            if (!block.m_41720_().toString().contains("boiler")) continue;
            return true;
        }
        return false;
    }

    private static boolean isSetForFissionReactor(List<ItemStack> blocks) {
        for (ItemStack block : blocks) {
            if (!block.m_41720_().toString().contains("fission_reactor")) continue;
            return true;
        }
        return false;
    }

    private static boolean isSetForTurbine(List<ItemStack> blocks) {
        for (ItemStack block : blocks) {
            if (!block.m_41720_().toString().contains("turbine")) continue;
            return true;
        }
        return false;
    }

    private static boolean validateDimensions(int height, int width, int length) {
        if (width < 3 || height < 4 || length < 3) {
            return false;
        }
        return width <= 18 && height <= 18 && length <= 18;
    }

    private static Map<String, Integer> createBlockAvailabilityMap(List<ItemStack> blocks) {
        HashMap<String, Integer> availableBlocks = new HashMap<String, Integer>();
        int ports = MekanismStructureGenerator.howManyPorts(blocks);
        int adapters = MekanismStructureGenerator.howManyAdapters(blocks);
        boolean hasGlass = MekanismStructureGenerator.hasGlass(blocks);
        for (ItemStack stack : blocks) {
            String blockName = MekanismStructureGenerator.getBlockName(stack);
            int count = stack.m_41613_();
            if (stack.m_41720_().toString().contains("glass")) {
                count += ports;
                count += adapters;
            }
            if (!hasGlass && stack.m_41720_().toString().contains("casing")) {
                count += ports;
                count += adapters;
            }
            availableBlocks.put(blockName, availableBlocks.getOrDefault(blockName, 0) + count);
        }
        return availableBlocks;
    }

    private static boolean hasGlass(List<ItemStack> blocks) {
        for (ItemStack stack : blocks) {
            if (!stack.m_41720_().toString().contains("glass")) continue;
            return true;
        }
        return false;
    }

    private static int howManyAdapters(List<ItemStack> blocks) {
        int count = 0;
        for (ItemStack stack : blocks) {
            if (!stack.m_41720_().toString().contains("logic_adapter")) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    private static int howManyPorts(List<ItemStack> blocks) {
        int count = 0;
        for (ItemStack stack : blocks) {
            if (!stack.m_41720_().toString().contains("port") && !stack.m_41720_().toString().contains("valve")) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    private static String getBlockName(ItemStack stack) {
        String registryName = stack.m_41720_().m_204114_().m_205785_().m_135782_().toString();
        if (registryName.endsWith("_item")) {
            registryName = registryName.substring(0, registryName.length() - 5);
        }
        return registryName;
    }

    private static boolean canUseBlock(String blockType, Map<String, Integer> availableBlocks, Map<String, Integer> usedBlocks) {
        int used;
        int available = availableBlocks.getOrDefault(blockType, 0);
        return available > (used = usedBlocks.getOrDefault(blockType, 0).intValue());
    }

    private static String determineBlockType(int x, int y, int z, int width, int height, int length, Map<String, Integer> availableBlocks, Map<String, Integer> usedBlocks) {
        boolean isCeiling;
        boolean isCorner = MekanismStructureGenerator.isCornerPosition(x, y, z, width, height, length);
        boolean isEdge = MekanismStructureGenerator.isEdgePosition(x, y, z, width, height, length);
        boolean isWall = MekanismStructureGenerator.isWallPosition(x, y, z, width, height, length);
        boolean isInterior = !isWall;
        boolean isFloor = y == 0;
        boolean bl = isCeiling = y == height - 1;
        if (isCorner || isEdge) {
            return "mekanismgenerators:fission_reactor_casing";
        }
        if (isWall || isCeiling || isFloor) {
            if (availableBlocks.containsKey("mekanismgenerators:reactor_glass") && MekanismStructureGenerator.canUseBlock("mekanismgenerators:reactor_glass", availableBlocks, usedBlocks)) {
                return "mekanismgenerators:reactor_glass";
            }
            return "mekanismgenerators:fission_reactor_casing";
        }
        if (isInterior) {
            return MekanismStructureGenerator.determineInteriorBlock(x, y, z, width, height, length, availableBlocks, usedBlocks);
        }
        return null;
    }

    private static String determineInteriorBlock(int x, int y, int z, int width, int height, int length, Map<String, Integer> availableBlocks, Map<String, Integer> usedBlocks) {
        boolean isFuelPosition;
        int interiorX = x - 1;
        int interiorZ = z - 1;
        boolean bl = isFuelPosition = (interiorX + interiorZ) % 2 == 0;
        if (!isFuelPosition) {
            return null;
        }
        if (y == 1 && availableBlocks.containsKey("mekanismgenerators:fission_fuel_assembly") && MekanismStructureGenerator.canUseBlock("mekanismgenerators:fission_fuel_assembly", availableBlocks, usedBlocks)) {
            return "mekanismgenerators:fission_fuel_assembly";
        }
        if (y > 1 && y < height - 2 && availableBlocks.containsKey("mekanismgenerators:fission_fuel_assembly") && MekanismStructureGenerator.canUseBlock("mekanismgenerators:fission_fuel_assembly", availableBlocks, usedBlocks)) {
            return "mekanismgenerators:fission_fuel_assembly";
        }
        if (y == height - 2) {
            if (availableBlocks.containsKey("mekanismgenerators:control_rod_assembly") && MekanismStructureGenerator.canUseBlock("mekanismgenerators:control_rod_assembly", availableBlocks, usedBlocks)) {
                return "mekanismgenerators:control_rod_assembly";
            }
            if (availableBlocks.containsKey("mekanismgenerators:fission_fuel_assembly") && MekanismStructureGenerator.canUseBlock("mekanismgenerators:fission_fuel_assembly", availableBlocks, usedBlocks)) {
                return "mekanismgenerators:fission_fuel_assembly";
            }
        }
        return null;
    }

    private static boolean isCornerPosition(int x, int y, int z, int width, int height, int length) {
        boolean isXEdge = x == 0 || x == width - 1;
        boolean isYEdge = y == 0 || y == height - 1;
        boolean isZEdge = z == 0 || z == length - 1;
        return isXEdge && isYEdge && isZEdge || isYEdge && isXEdge && isZEdge;
    }

    private static boolean isEdgePosition(int x, int y, int z, int width, int height, int length) {
        boolean isXEdge = x == 0 || x == width - 1;
        boolean isYEdge = y == 0 || y == height - 1;
        boolean isZEdge = z == 0 || z == length - 1;
        int edgeCount = (isXEdge ? 1 : 0) + (isYEdge ? 1 : 0) + (isZEdge ? 1 : 0);
        return edgeCount == 2 && !MekanismStructureGenerator.isCornerPosition(x, y, z, width, height, length);
    }

    private static boolean isWallPosition(int x, int y, int z, int width, int height, int length) {
        return x == 0 || x == width - 1 || y == 0 || y == height - 1 || z == 0 || z == length - 1;
    }

    private static void addBlockToStructure(ListTag blocksList, ListTag palette, Map<String, Integer> paletteMap, int x, int y, int z, String blockType, AtomicInteger paletteIndex) {
        if (!paletteMap.containsKey(blockType)) {
            CompoundTag paletteEntry = new CompoundTag();
            paletteEntry.m_128359_("Name", blockType);
            palette.add((Object)paletteEntry);
            paletteMap.put(blockType, paletteIndex.getAndIncrement());
        }
        CompoundTag blockEntry = new CompoundTag();
        ListTag pos = new ListTag();
        pos.add((Object)IntTag.m_128679_((int)x));
        pos.add((Object)IntTag.m_128679_((int)y));
        pos.add((Object)IntTag.m_128679_((int)z));
        blockEntry.m_128365_("pos", (Tag)pos);
        blockEntry.m_128405_("state", paletteMap.get(blockType).intValue());
        blocksList.add((Object)blockEntry);
    }

    private static void addRandomPorts(List<ItemStack> blocks, List<BlockPosition> wallPositions, Map<String, Integer> availableBlocks, Map<String, Integer> usedBlocks, ListTag blocksList, ListTag palette, Map<String, Integer> paletteMap, AtomicInteger paletteIndex, int width, int height, int length) {
        String adapterType;
        int ports = MekanismStructureGenerator.howManyPorts(blocks);
        int adapters = MekanismStructureGenerator.howManyAdapters(blocks);
        ArrayList<String> portsToPlace = new ArrayList<String>();
        String portType = "mekanismgenerators:fission_reactor_port";
        if (availableBlocks.containsKey(portType)) {
            int availablePorts = availableBlocks.get(portType) - usedBlocks.getOrDefault(portType, 0);
            for (int i = 0; i < Math.min(ports, availablePorts); ++i) {
                portsToPlace.add(portType);
            }
        }
        if (availableBlocks.containsKey(adapterType = "mekanismgenerators:fission_reactor_logic_adapter")) {
            int availableAdapters = availableBlocks.get(adapterType) - usedBlocks.getOrDefault(adapterType, 0);
            for (int i = 0; i < Math.min(adapters, availableAdapters); ++i) {
                portsToPlace.add(adapterType);
            }
        }
        if (portsToPlace.isEmpty()) {
            return;
        }
        int totalPortsToPlace = Math.min(portsToPlace.size(), wallPositions.size());
        Collections.shuffle(wallPositions);
        Collections.shuffle(portsToPlace);
        HashMap<String, Integer> replacedBlockCounts = new HashMap<String, Integer>();
        int portsPlaced = 0;
        for (int i = 0; i < wallPositions.size() && portsPlaced < totalPortsToPlace; ++i) {
            BlockPosition pos = wallPositions.get(i);
            String currentPortType = (String)portsToPlace.get(portsPlaced);
            if (!MekanismStructureGenerator.canUseBlock(currentPortType, availableBlocks, usedBlocks)) continue;
            String replacedBlockType = MekanismStructureGenerator.determineReplacedBlockType(pos.x, pos.y, pos.z, width, height, length, availableBlocks, usedBlocks);
            if (replacedBlockType != null) {
                replacedBlockCounts.put(replacedBlockType, replacedBlockCounts.getOrDefault(replacedBlockType, 0) + 1);
            }
            MekanismStructureGenerator.addBlockToStructure(blocksList, palette, paletteMap, pos.x, pos.y, pos.z, currentPortType, paletteIndex);
            usedBlocks.put(currentPortType, usedBlocks.getOrDefault(currentPortType, 0) + 1);
            ++portsPlaced;
        }
        for (Map.Entry entry : replacedBlockCounts.entrySet()) {
            String blockType = (String)entry.getKey();
            int replacedCount = (Integer)entry.getValue();
            int currentUsed = usedBlocks.getOrDefault(blockType, 0);
            if (currentUsed < replacedCount) continue;
            usedBlocks.put(blockType, currentUsed - replacedCount);
        }
    }

    private static String determineReplacedBlockType(int x, int y, int z, int width, int height, int length, Map<String, Integer> availableBlocks, Map<String, Integer> usedBlocks) {
        boolean isCeiling;
        boolean isCorner = MekanismStructureGenerator.isCornerPosition(x, y, z, width, height, length);
        boolean isEdge = MekanismStructureGenerator.isEdgePosition(x, y, z, width, height, length);
        boolean isWall = MekanismStructureGenerator.isWallPosition(x, y, z, width, height, length);
        boolean isFloor = y == 0;
        boolean bl = isCeiling = y == height - 1;
        if (isCorner || isEdge) {
            return "mekanismgenerators:fission_reactor_casing";
        }
        if (isWall || isCeiling || isFloor) {
            if (availableBlocks.containsKey("mekanismgenerators:reactor_glass")) {
                return "mekanismgenerators:reactor_glass";
            }
            return "mekanismgenerators:fission_reactor_casing";
        }
        return null;
    }

    private static boolean validateTurbineDimensions(int height, int width, int length) {
        if (width % 2 == 0 || length % 2 == 0) {
            return false;
        }
        if (width < 3 || height < 4 || length < 3) {
            return false;
        }
        return width <= 17 && height <= 18 && length <= 17;
    }

    private static String determineTurbineBlockType(int x, int y, int z, int width, int height, int length, Map<String, Integer> availableBlocks, Map<String, Integer> usedBlocks) {
        boolean isCeiling;
        boolean isCorner = MekanismStructureGenerator.isCornerPosition(x, y, z, width, height, length);
        boolean isEdge = MekanismStructureGenerator.isEdgePosition(x, y, z, width, height, length);
        boolean isWall = MekanismStructureGenerator.isWallPosition(x, y, z, width, height, length);
        boolean isInterior = !isWall;
        boolean isFloor = y == 0;
        boolean bl = isCeiling = y == height - 1;
        if (isCorner || isEdge) {
            return "mekanismgenerators:turbine_casing";
        }
        if (isFloor) {
            if (availableBlocks.containsKey("mekanism:structural_glass") && MekanismStructureGenerator.canUseBlock("mekanism:structural_glass", availableBlocks, usedBlocks)) {
                return "mekanism:structural_glass";
            }
            return "mekanismgenerators:turbine_casing";
        }
        if (isCeiling) {
            if (availableBlocks.containsKey("mekanismgenerators:turbine_vent") && MekanismStructureGenerator.canUseBlock("mekanismgenerators:turbine_vent", availableBlocks, usedBlocks)) {
                return "mekanismgenerators:turbine_vent";
            }
            if (availableBlocks.containsKey("mekanism:structural_glass") && MekanismStructureGenerator.canUseBlock("mekanism:structural_glass", availableBlocks, usedBlocks)) {
                return "mekanism:structural_glass";
            }
            return "mekanismgenerators:turbine_casing";
        }
        if (isWall) {
            int rotorHeight = height - 3;
            if (y >= rotorHeight && availableBlocks.containsKey("mekanismgenerators:turbine_vent") && MekanismStructureGenerator.canUseBlock("mekanismgenerators:turbine_vent", availableBlocks, usedBlocks)) {
                return "mekanismgenerators:turbine_vent";
            }
            if (availableBlocks.containsKey("mekanism:structural_glass") && MekanismStructureGenerator.canUseBlock("mekanism:structural_glass", availableBlocks, usedBlocks)) {
                return "mekanism:structural_glass";
            }
            return "mekanismgenerators:turbine_casing";
        }
        if (isInterior) {
            return MekanismStructureGenerator.determineTurbineInteriorBlock(x, y, z, width, height, length, availableBlocks, usedBlocks);
        }
        return null;
    }

    private static String determineTurbineInteriorBlock(int x, int y, int z, int width, int height, int length, Map<String, Integer> availableBlocks, Map<String, Integer> usedBlocks) {
        int distanceFromCenter;
        int centerX = width / 2;
        int centerZ = length / 2;
        boolean isCenter = x == centerX && z == centerZ;
        int rotorHeight = height - 3;
        if (isCenter && y >= 1 && y < rotorHeight && availableBlocks.containsKey("mekanismgenerators:turbine_rotor") && MekanismStructureGenerator.canUseBlock("mekanismgenerators:turbine_rotor", availableBlocks, usedBlocks)) {
            return "mekanismgenerators:turbine_rotor";
        }
        if (isCenter && y == rotorHeight && availableBlocks.containsKey("mekanismgenerators:rotational_complex") && MekanismStructureGenerator.canUseBlock("mekanismgenerators:rotational_complex", availableBlocks, usedBlocks)) {
            return "mekanismgenerators:rotational_complex";
        }
        if (isCenter && y > rotorHeight && y < height - 1 && availableBlocks.containsKey("mekanismgenerators:electromagnetic_coil") && MekanismStructureGenerator.canUseBlock("mekanismgenerators:electromagnetic_coil", availableBlocks, usedBlocks)) {
            return "mekanismgenerators:electromagnetic_coil";
        }
        if (y == rotorHeight && !isCenter && availableBlocks.containsKey("mekanism:pressure_disperser") && MekanismStructureGenerator.canUseBlock("mekanism:pressure_disperser", availableBlocks, usedBlocks)) {
            return "mekanism:pressure_disperser";
        }
        if (y > rotorHeight && y < height - 1 && (distanceFromCenter = Math.max(Math.abs(x - centerX), Math.abs(z - centerZ))) >= 1 && distanceFromCenter <= 2 && availableBlocks.containsKey("mekanismgenerators:saturating_condenser") && MekanismStructureGenerator.canUseBlock("mekanismgenerators:saturating_condenser", availableBlocks, usedBlocks)) {
            return "mekanismgenerators:saturating_condenser";
        }
        return null;
    }

    private static void addTurbinePorts(List<BlockPosition> wallPositions, Map<String, Integer> availableBlocks, Map<String, Integer> usedBlocks, ListTag blocksList, ListTag palette, Map<String, Integer> paletteMap, AtomicInteger paletteIndex, int width, int height, int length) {
        String portType = "mekanismgenerators:turbine_valve";
        if (!availableBlocks.containsKey(portType) || !MekanismStructureGenerator.canUseBlock(portType, availableBlocks, usedBlocks)) {
            return;
        }
        int availableValves = availableBlocks.get(portType) - usedBlocks.getOrDefault(portType, 0);
        int portsToPlace = Math.min(availableValves, wallPositions.size());
        Collections.shuffle(wallPositions);
        HashMap<String, Integer> replacedBlockCounts = new HashMap<String, Integer>();
        int portsPlaced = 0;
        for (int i = 0; i < wallPositions.size() && portsPlaced < portsToPlace; ++i) {
            BlockPosition pos = wallPositions.get(i);
            if (!MekanismStructureGenerator.canUseBlock(portType, availableBlocks, usedBlocks)) continue;
            String replacedBlockType = MekanismStructureGenerator.determineTurbineReplacedBlockType(pos.x, pos.y, pos.z, width, height, length, availableBlocks, usedBlocks);
            if (replacedBlockType != null) {
                replacedBlockCounts.put(replacedBlockType, replacedBlockCounts.getOrDefault(replacedBlockType, 0) + 1);
            }
            MekanismStructureGenerator.addBlockToStructure(blocksList, palette, paletteMap, pos.x, pos.y, pos.z, portType, paletteIndex);
            usedBlocks.put(portType, usedBlocks.getOrDefault(portType, 0) + 1);
            ++portsPlaced;
        }
        for (Map.Entry entry : replacedBlockCounts.entrySet()) {
            String blockType = (String)entry.getKey();
            int replacedCount = (Integer)entry.getValue();
            int currentUsed = usedBlocks.getOrDefault(blockType, 0);
            if (currentUsed < replacedCount) continue;
            usedBlocks.put(blockType, currentUsed - replacedCount);
        }
    }

    private static String determineTurbineReplacedBlockType(int x, int y, int z, int width, int height, int length, Map<String, Integer> availableBlocks, Map<String, Integer> usedBlocks) {
        boolean isCeiling;
        boolean isCorner = MekanismStructureGenerator.isCornerPosition(x, y, z, width, height, length);
        boolean isEdge = MekanismStructureGenerator.isEdgePosition(x, y, z, width, height, length);
        boolean isWall = MekanismStructureGenerator.isWallPosition(x, y, z, width, height, length);
        boolean isFloor = y == 0;
        boolean bl = isCeiling = y == height - 1;
        if (isCorner || isEdge) {
            return "mekanismgenerators:turbine_casing";
        }
        if (isFloor) {
            if (availableBlocks.containsKey("mekanism:structural_glass")) {
                return "mekanism:structural_glass";
            }
            return "mekanismgenerators:turbine_casing";
        }
        if (isCeiling) {
            if (availableBlocks.containsKey("mekanismgenerators:turbine_vent")) {
                return "mekanismgenerators:turbine_vent";
            }
            if (availableBlocks.containsKey("mekanism:structural_glass")) {
                return "mekanism:structural_glass";
            }
            return "mekanismgenerators:turbine_casing";
        }
        if (isWall) {
            int rotorHeight = height - 3;
            if (y >= rotorHeight && availableBlocks.containsKey("mekanismgenerators:turbine_vent")) {
                return "mekanismgenerators:turbine_vent";
            }
            if (availableBlocks.containsKey("mekanism:structural_glass")) {
                return "mekanism:structural_glass";
            }
            return "mekanismgenerators:turbine_casing";
        }
        return null;
    }

    private static class BlockPosition {
        final int x;
        final int y;
        final int z;

        BlockPosition(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

