/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.util;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.AABB;

public class PlacedStructure {
    private final String structureId;
    private final AABB boundingBox;
    private final UUID placedBy;
    private final long placedTime;
    private final int rotation;

    public PlacedStructure(String structureId, AABB boundingBox, UUID placedBy, int rotation) {
        this.structureId = structureId;
        this.boundingBox = boundingBox;
        this.placedBy = placedBy;
        this.placedTime = System.currentTimeMillis();
        this.rotation = rotation;
    }

    public PlacedStructure(CompoundTag tag) {
        this.structureId = tag.m_128461_("structureId");
        this.boundingBox = new AABB((double)tag.m_128451_("minX"), (double)tag.m_128451_("minY"), (double)tag.m_128451_("minZ"), (double)tag.m_128451_("maxX"), (double)tag.m_128451_("maxY"), (double)tag.m_128451_("maxZ"));
        this.placedBy = tag.m_128342_("placedBy");
        this.placedTime = tag.m_128454_("placedTime");
        this.rotation = tag.m_128451_("rotation");
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("structureId", this.structureId);
        tag.m_128405_("minX", (int)this.boundingBox.f_82288_);
        tag.m_128405_("minY", (int)this.boundingBox.f_82289_);
        tag.m_128405_("minZ", (int)this.boundingBox.f_82290_);
        tag.m_128405_("maxX", (int)this.boundingBox.f_82291_);
        tag.m_128405_("maxY", (int)this.boundingBox.f_82292_);
        tag.m_128405_("maxZ", (int)this.boundingBox.f_82293_);
        tag.m_128362_("placedBy", this.placedBy);
        tag.m_128356_("placedTime", this.placedTime);
        tag.m_128405_("rotation", this.rotation);
        return tag;
    }

    public String getStructureId() {
        return this.structureId;
    }

    public AABB getBoundingBox() {
        return this.boundingBox;
    }

    public UUID getPlacedBy() {
        return this.placedBy;
    }

    public long getPlacedTime() {
        return this.placedTime;
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean contains(BlockPos pos) {
        return this.boundingBox.m_82393_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }
}

