/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.util;

import igentuman.mbtool.util.PlacedStructure;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class PlacedStructuresManager {
    private static final String NBT_KEY = "placedStructures";

    public static void addPlacedStructure(ItemStack multibuilderStack, String structureId, AABB boundingBox, UUID placedBy, int rotation) {
        if (structureId == null) {
            return;
        }
        CompoundTag tag = multibuilderStack.m_41784_();
        ListTag structuresList = tag.m_128437_(NBT_KEY, 10);
        PlacedStructure structure = new PlacedStructure(structureId, boundingBox, placedBy, rotation);
        structuresList.add((Object)structure.toNBT());
        tag.m_128365_(NBT_KEY, (Tag)structuresList);
    }

    public static List<PlacedStructure> getPlacedStructures(ItemStack multibuilderStack) {
        ArrayList<PlacedStructure> structures = new ArrayList<PlacedStructure>();
        CompoundTag tag = multibuilderStack.m_41784_();
        if (tag.m_128441_(NBT_KEY)) {
            ListTag structuresList = tag.m_128437_(NBT_KEY, 10);
            for (int i = 0; i < structuresList.size(); ++i) {
                CompoundTag structureTag = structuresList.m_128728_(i);
                structures.add(new PlacedStructure(structureTag));
            }
        }
        return structures;
    }

    public static PlacedStructure findStructureAt(ItemStack multibuilderStack, BlockPos pos) {
        List<PlacedStructure> structures = PlacedStructuresManager.getPlacedStructures(multibuilderStack);
        for (PlacedStructure structure : structures) {
            if (!structure.contains(pos)) continue;
            return structure;
        }
        return null;
    }

    public static boolean removePlacedStructure(ItemStack multibuilderStack, PlacedStructure structureToRemove) {
        CompoundTag tag = multibuilderStack.m_41784_();
        if (!tag.m_128441_(NBT_KEY)) {
            return false;
        }
        ListTag structuresList = tag.m_128437_(NBT_KEY, 10);
        ListTag newStructuresList = new ListTag();
        boolean removed = false;
        for (int i = 0; i < structuresList.size(); ++i) {
            CompoundTag structureTag = structuresList.m_128728_(i);
            PlacedStructure structure = new PlacedStructure(structureTag);
            if (!structure.getBoundingBox().equals((Object)structureToRemove.getBoundingBox()) || !structure.getStructureId().equals(structureToRemove.getStructureId())) {
                newStructuresList.add((Object)structureTag);
                continue;
            }
            removed = true;
        }
        tag.m_128365_(NBT_KEY, (Tag)newStructuresList);
        return removed;
    }

    public static void clearPlacedStructures(ItemStack multibuilderStack) {
        CompoundTag tag = multibuilderStack.m_41784_();
        tag.m_128473_(NBT_KEY);
    }
}

