/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.util;

import igentuman.mbtool.config.MbtoolConfig;
import igentuman.mbtool.item.MultibuilderItem;
import igentuman.mbtool.util.CapabilityUtils;
import igentuman.mbtool.util.MultiblockStructure;
import igentuman.mbtool.util.MultiblocksProvider;
import igentuman.mbtool.util.PlacedStructure;
import igentuman.mbtool.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public class StructureDismantler {
    public static DismantleResult dismantleStructure(Level level, Player player, ItemStack multibuilderStack, PlacedStructure structure) {
        MultibuilderItem multibuilderItem;
        if (level.f_46443_) {
            return new DismantleResult(false, (Component)Component.m_237113_((String)"Cannot dismantle on client side"));
        }
        boolean isCreative = player.m_7500_();
        MultiblockStructure originalStructure = StructureDismantler.getOriginalStructure(structure.getStructureId());
        if (originalStructure == null) {
            return new DismantleResult(false, (Component)Component.m_237115_((String)"message.mbtool.structure_not_found"));
        }
        ArrayList<BlockPos> blocksToRemove = new ArrayList<BlockPos>();
        ArrayList<ItemStack> collectedItems = new ArrayList<ItemStack>();
        AABB boundingBox = structure.getBoundingBox();
        BlockPos structureOrigin = new BlockPos((int)boundingBox.f_82288_, (int)boundingBox.f_82289_, (int)boundingBox.f_82290_);
        BlockPos originalOrigin = new BlockPos(originalStructure.getMinX(), originalStructure.getMinY(), originalStructure.getMinZ());
        BlockPos offset = structureOrigin.m_121996_((Vec3i)originalOrigin);
        Map<BlockPos, BlockState> rotatedBlocks = StructureDismantler.applyRotation(originalStructure.getBlocks(), structure.getRotation());
        for (Map.Entry<BlockPos, BlockState> entry : rotatedBlocks.entrySet()) {
            BlockPos worldPos;
            BlockState currentState;
            BlockPos originalPos = entry.getKey();
            BlockState originalBlockState = entry.getValue();
            if (originalBlockState.m_60795_() || (currentState = level.m_8055_(worldPos = originalPos.m_121955_((Vec3i)offset))).m_60795_()) continue;
            if (!StructureDismantler.canPlayerBreakBlockAt(level, player, worldPos)) {
                return new DismantleResult(false, (Component)Component.m_237110_((String)"message.mbtool.cannot_break_protected", (Object[])new Object[]{worldPos.m_123341_(), worldPos.m_123342_(), worldPos.m_123343_()}));
            }
            if (!StructureDismantler.shouldDismantleBlock(originalBlockState, currentState)) continue;
            blocksToRemove.add(worldPos);
            List drops = Block.m_49869_((BlockState)currentState, (ServerLevel)((ServerLevel)level), (BlockPos)worldPos, (BlockEntity)level.m_7702_(worldPos));
            for (ItemStack drop : drops) {
                if (drop.m_41619_()) continue;
                collectedItems.add(drop.m_41777_());
            }
        }
        if (blocksToRemove.isEmpty()) {
            return new DismantleResult(false, (Component)Component.m_237115_((String)"message.mbtool.no_blocks_to_dismantle"));
        }
        int totalEnergyCost = blocksToRemove.size() * MbtoolConfig.getEnergyPerBlock() / 2;
        if (!isCreative && !(multibuilderItem = (MultibuilderItem)multibuilderStack.m_41720_()).hasEnergy(multibuilderStack, totalEnergyCost)) {
            return new DismantleResult(false, (Component)Component.m_237110_((String)"message.mbtool.insufficient_energy", (Object[])new Object[]{TextUtils.formatEnergy(totalEnergyCost)}));
        }
        if (!isCreative) {
            IItemHandler inventory = StructureDismantler.getInventory(multibuilderStack);
            if (inventory == null) {
                return new DismantleResult(false, (Component)Component.m_237115_((String)"message.mbtool.no_inventory"));
            }
            for (ItemStack itemStack : collectedItems) {
                ItemStack remaining = StructureDismantler.insertItemIntoInventory(inventory, itemStack, true);
                if (remaining.m_41619_()) continue;
                return new DismantleResult(false, (Component)Component.m_237115_((String)"message.mbtool.insufficient_inventory_space"));
            }
        }
        int blocksRemoved = 0;
        for (BlockPos pos : blocksToRemove) {
            BlockState state = level.m_8055_(pos);
            if (state.m_60795_()) continue;
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            ++blocksRemoved;
        }
        if (!isCreative) {
            IItemHandler inventory = StructureDismantler.getInventory(multibuilderStack);
            for (ItemStack itemStack : collectedItems) {
                StructureDismantler.insertItemIntoInventory(inventory, itemStack, false);
            }
        }
        if (!isCreative) {
            MultibuilderItem multibuilderItem2 = (MultibuilderItem)multibuilderStack.m_41720_();
            multibuilderItem2.consumeEnergy(multibuilderStack, totalEnergyCost);
        }
        if (level instanceof ServerLevel) {
            level.m_5594_(null, new BlockPos((int)boundingBox.m_82399_().f_82479_, (int)boundingBox.m_82399_().f_82480_, (int)boundingBox.m_82399_().f_82481_), SoundEvents.f_12198_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return new DismantleResult(true, (Component)Component.m_237110_((String)"message.mbtool.structure_dismantled", (Object[])new Object[]{blocksRemoved}));
    }

    private static boolean canPlayerBreakBlockAt(Level level, Player player, BlockPos pos) {
        return level.m_7966_(player, pos);
    }

    private static IItemHandler getInventory(ItemStack stack) {
        return (IItemHandler)CapabilityUtils.getPresentCapability((ICapabilityProvider)stack, ForgeCapabilities.ITEM_HANDLER);
    }

    private static ItemStack insertItemIntoInventory(IItemHandler inventory, ItemStack itemToInsert, boolean simulate) {
        ItemStack remaining = itemToInsert.m_41777_();
        for (int i = 0; i < inventory.getSlots() && !remaining.m_41619_(); ++i) {
            remaining = inventory.insertItem(i, remaining, simulate);
        }
        return remaining;
    }

    private static MultiblockStructure getOriginalStructure(String structureId) {
        for (MultiblockStructure structure : MultiblocksProvider.getStructures()) {
            if (!structure.getName().equals(structureId)) continue;
            return structure;
        }
        return null;
    }

    private static Map<BlockPos, BlockState> applyRotation(Map<BlockPos, BlockState> originalBlocks, int rotation) {
        if (rotation == 0) {
            return originalBlocks;
        }
        HashMap<BlockPos, BlockState> rotatedBlocks = new HashMap<BlockPos, BlockState>();
        int minX = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : originalBlocks.keySet()) {
            minX = Math.min(minX, pos.m_123341_());
            maxX = Math.max(maxX, pos.m_123341_());
            minZ = Math.min(minZ, pos.m_123343_());
            maxZ = Math.max(maxZ, pos.m_123343_());
        }
        double centerX = (double)(minX + maxX) / 2.0;
        double centerZ = (double)(minZ + maxZ) / 2.0;
        for (Map.Entry<BlockPos, BlockState> entry : originalBlocks.entrySet()) {
            BlockPos originalPos = entry.getKey();
            BlockState originalState = entry.getValue();
            BlockPos rotatedPos = StructureDismantler.rotateBlockPos(originalPos, centerX, centerZ, rotation);
            BlockState rotatedState = StructureDismantler.rotateBlockState(originalState, rotation);
            rotatedBlocks.put(rotatedPos, rotatedState);
        }
        return rotatedBlocks;
    }

    private static BlockPos rotateBlockPos(BlockPos pos, double centerX, double centerZ, int rotation) {
        double rotatedX;
        double x = (double)pos.m_123341_() - centerX;
        double z = (double)pos.m_123343_() - centerZ;
        return new BlockPos((int)Math.round(rotatedX + centerX), pos.m_123342_(), (int)Math.round((switch (rotation % 4) {
            case 1 -> {
                rotatedX = -z;
                yield x;
            }
            case 2 -> {
                rotatedX = -x;
                yield -z;
            }
            case 3 -> {
                rotatedX = z;
                yield -x;
            }
            default -> {
                rotatedX = x;
                yield z;
            }
        }) + centerZ));
    }

    private static BlockState rotateBlockState(BlockState state, int rotation) {
        return state;
    }

    private static boolean shouldDismantleBlock(BlockState originalState, BlockState currentState) {
        if (originalState.equals(currentState)) {
            return true;
        }
        return originalState.m_60734_() == currentState.m_60734_();
    }

    public static class DismantleResult {
        private final boolean success;
        private final Component message;

        public DismantleResult(boolean success, Component message) {
            this.success = success;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public Component getMessage() {
            return this.message;
        }
    }
}

