/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.cloudchat;

import dev.booky.cloudchat.CloudChatApi;
import dev.booky.cloudchat.CloudChatManager;
import dev.booky.cloudchat.JoinQuitListener;
import dev.booky.cloudchat.PaperConfigChecker;
import dev.booky.cloudchat.bstats.bukkit.Metrics;
import java.util.UUID;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.event.EventSubscription;
import net.luckperms.api.event.user.UserDataRecalculateEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CloudChatMain
extends JavaPlugin {
    private CloudChatManager manager;
    private EventSubscription<?> subscription;

    public CloudChatMain() {
        try {
            Class.forName("io.papermc.paper.configuration.Configuration");
        }
        catch (ClassNotFoundException exception) {
            throw new RuntimeException("Please use paper for this plugin to function! Download it at https://papermc.io/.");
        }
    }

    public void onLoad() {
        this.manager = new CloudChatManager();
        Bukkit.getServicesManager().register(CloudChatApi.class, (Object)this.manager, (Plugin)this, ServicePriority.Normal);
        new Metrics((Plugin)this, 18256);
    }

    public void onEnable() {
        PaperConfigChecker.checkVanillaColoring(this.getSLF4JLogger());
        Bukkit.getPluginManager().registerEvents((Listener)new JoinQuitListener(this.manager), (Plugin)this);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.manager.createTeam(player);
        }
        this.subscription = LuckPermsProvider.get().getEventBus().subscribe(UserDataRecalculateEvent.class, event -> {
            Player player = Bukkit.getPlayer((UUID)event.getUser().getUniqueId());
            if (player != null) {
                Bukkit.getScheduler().runTask((Plugin)this, () -> this.manager.updateTeam(player));
            }
        });
    }

    public void onDisable() {
        if (this.subscription != null) {
            this.subscription.close();
            this.subscription = null;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.manager.removeTeam(player);
        }
    }
}

