/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.cloudchat;

import dev.booky.cloudchat.CloudChatApi;
import java.text.DecimalFormat;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import org.apache.commons.lang3.RandomStringUtils;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

class CloudChatManager
implements CloudChatApi {
    private static final DecimalFormat FORMAT = new DecimalFormat("0000");
    private static final Component SEPARATOR = Component.text((String)" \u25cf ", (TextColor)NamedTextColor.DARK_GRAY);

    CloudChatManager() {
    }

    @Override
    public boolean createTeam(Scoreboard scoreboard, UUID playerId, String username) {
        LuckPerms luckperms = LuckPermsProvider.get();
        User user = luckperms.getUserManager().getUser(playerId);
        if (user == null) {
            return false;
        }
        Group group = luckperms.getGroupManager().getGroup(user.getPrimaryGroup());
        if (group == null) {
            return false;
        }
        String teamName = FORMAT.format(9999 - group.getWeight().orElse(0)) + RandomStringUtils.randomAlphanumeric((int)12);
        Team team = scoreboard.getEntryTeam(username);
        if (team == null) {
            team = scoreboard.registerNewTeam(teamName);
            team.addEntry(username);
        }
        this.updateTeam(user, team);
        return true;
    }

    @Override
    public boolean removeTeam(Scoreboard scoreboard, UUID playerId, String username) {
        Team team = scoreboard.getEntryTeam(username);
        if (team == null) {
            return false;
        }
        team.unregister();
        return true;
    }

    @Override
    public boolean updateTeam(Scoreboard scoreboard, UUID playerId, String username) {
        LuckPerms luckperms = LuckPermsProvider.get();
        User user = luckperms.getUserManager().getUser(playerId);
        if (user == null) {
            return false;
        }
        Team team = scoreboard.getEntryTeam(username);
        if (team != null) {
            this.updateTeam(user, team);
            return true;
        }
        return false;
    }

    private void updateTeam(User user, Team team) {
        MiniMessage serializer = MiniMessage.miniMessage();
        CachedMetaData meta = user.getCachedData().getMetaData();
        String prefixStr = meta.getPrefix();
        if (prefixStr != null) {
            team.prefix(serializer.deserialize((Object)prefixStr).colorIfAbsent((TextColor)NamedTextColor.WHITE).append(SEPARATOR));
        } else {
            team.prefix((Component)Component.empty());
        }
        String suffixStr = meta.getSuffix();
        if (suffixStr != null) {
            team.suffix(SEPARATOR.append(serializer.deserialize((Object)suffixStr).colorIfAbsent((TextColor)NamedTextColor.WHITE)));
        } else {
            team.suffix((Component)Component.empty());
        }
        team.color(NamedTextColor.GRAY);
        team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.ALWAYS);
    }
}

