/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.cloudchat;

import com.destroystokyo.paper.profile.PlayerProfile;
import dev.booky.cloudchat.CloudChatApi;
import io.papermc.paper.connection.PlayerConfigurationConnection;
import io.papermc.paper.connection.PlayerConnection;
import io.papermc.paper.event.connection.PlayerConnectionValidateLoginEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

class JoinQuitListener
implements Listener {
    private final CloudChatApi api;

    public JoinQuitListener(CloudChatApi api) {
        this.api = api;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onLogin(PlayerConnectionValidateLoginEvent event) {
        if (event.getKickMessage() != null) {
            return;
        }
        PlayerConnection playerConnection = event.getConnection();
        if (!(playerConnection instanceof PlayerConfigurationConnection)) {
            return;
        }
        PlayerConfigurationConnection connection = (PlayerConfigurationConnection)playerConnection;
        PlayerProfile profile = connection.getProfile();
        this.api.createTeam(profile.getId(), profile.getName());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent event) {
        this.api.removeTeam(event.getPlayer());
    }
}

