/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.cloudchat;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
final class PaperConfigChecker {
    private PaperConfigChecker() {
    }

    public static void checkVanillaColoring(Logger logger) throws IllegalStateException {
        List worlds = Bukkit.getWorlds();
        ArrayList<Key> invalidWorlds = new ArrayList<Key>(worlds.size());
        for (World world : worlds) {
            if (PaperConfigChecker.hasVanillaScoreboardColoring(world)) continue;
            invalidWorlds.add(world.key());
        }
        if (invalidWorlds.isEmpty()) {
            return;
        }
        logger.warn("'scoreboards.use-vanilla-world-scoreboard-name-coloring' is not enabled in {}", (Object)(worlds.size() == invalidWorlds.size() ? "all worlds" : ((Object)invalidWorlds).toString()));
        logger.warn("This plugin doesn't change the chat format, this option is required to be enabled for chat formatting");
    }

    private static boolean hasVanillaScoreboardColoring(World world) {
        try {
            Object serverLevel = world.getClass().getMethod("getHandle", new Class[0]).invoke((Object)world, new Object[0]);
            Object paperWorldCfg = serverLevel.getClass().getSuperclass().getMethod("paperConfig", new Class[0]).invoke(serverLevel, new Object[0]);
            Object scoreboardsCfg = paperWorldCfg.getClass().getField("scoreboards").get(paperWorldCfg);
            return scoreboardsCfg.getClass().getField("useVanillaWorldScoreboardNameColoring").getBoolean(scoreboardsCfg);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
    }
}

