/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival;

import com.armilp.ezvcsurvival.config.EntityVoiceConfig;
import com.armilp.ezvcsurvival.config.VoiceConfig;
import com.armilp.ezvcsurvival.data.SoundData;
import com.armilp.ezvcsurvival.events.ArmorEventHandler;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.common.Mod;

@ForgeVoicechatPlugin
@Mod(value="ezvcsurvival")
public class Plugin
implements VoicechatPlugin {
    private boolean DEBUG;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final Map<UUID, SoundData> playerSoundLocations = new ConcurrentHashMap<UUID, SoundData>();
    private static VoicechatApi voicechatApi;
    @Nullable
    private OpusDecoder decoder;

    public String getPluginId() {
        return "ezvcsurvival";
    }

    public void initialize(VoicechatApi api) {
        voicechatApi = api;
        this.DEBUG = (Boolean)VoiceConfig.DEBUG.get();
        if (this.DEBUG) {
            System.out.println("[DEBUG] VoiceChat Plugin initialized");
        }
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(MicrophonePacketEvent.class, this::onMicrophonePacket);
        if (this.DEBUG) {
            System.out.println("[DEBUG] Registered MicrophonePacketEvent");
        }
    }

    public static double getMaxAudioLevel(short[] samples) {
        double rms = 0.0;
        for (int i = 0; i < samples.length; ++i) {
            double sample = (double)samples[i] / 32767.0;
            rms += sample * sample;
        }
        int sampleCount = samples.length / 2;
        rms = sampleCount == 0 ? 0.0 : Math.sqrt(rms / (double)sampleCount);
        double db = rms > 0.0 ? Math.min(Math.max(20.0 * Math.log10(rms), -127.0), 0.0) : -127.0;
        return db;
    }

    public static BlockPos getLastSoundLocation(BlockPos mobPosition, double range, double minDb) {
        return playerSoundLocations.values().stream().filter(data -> data.getAudioLevelDb() >= minDb).filter(data -> mobPosition.distSqr((Vec3i)data.getPosition()) <= range * range).min(Comparator.comparingDouble(data -> mobPosition.distSqr((Vec3i)data.getPosition()))).map(SoundData::getPosition).orElse(null);
    }

    public void onMicrophonePacket(MicrophonePacketEvent event) {
        short[] decoded;
        ServerPlayer player;
        VoicechatConnection sender = event.getSenderConnection();
        if (sender == null || sender.getPlayer() == null) {
            return;
        }
        Object object = sender.getPlayer().getPlayer();
        if (object instanceof ServerPlayer && ((player = (ServerPlayer)object).isCreative() || player.isSpectator())) {
            return;
        }
        OpusDecoder localDecoder = this.decoder;
        if (localDecoder == null || localDecoder.isClosed()) {
            this.decoder = localDecoder = voicechatApi.createDecoder();
        }
        if (localDecoder == null) {
            return;
        }
        localDecoder.resetState();
        byte[] opusEncodedData = ((MicrophonePacket)event.getPacket()).getOpusEncodedData();
        try {
            decoded = localDecoder.decode(opusEncodedData);
        }
        catch (Exception e) {
            return;
        }
        double audioLevel = Plugin.getMaxAudioLevel(decoded);
        UUID playerUUID = sender.getPlayer().getUuid();
        Position voicechatPosition = sender.getPlayer().getPosition();
        Vec3 senderVec = new Vec3(voicechatPosition.getX(), voicechatPosition.getY(), voicechatPosition.getZ());
        BlockPos playerPosition = new BlockPos((int)Math.floor(senderVec.x), (int)Math.floor(senderVec.y), (int)Math.floor(senderVec.z));
        boolean isWhispering = ((MicrophonePacket)event.getPacket()).isWhispering();
        double whisperRangeMultiplier = (Double)VoiceConfig.WHISPER_RANGE_MULTIPLIER.get();
        double whisperSpeedMultiplier = (Double)VoiceConfig.WHISPER_SPEED_MULTIPLIER.get();
        double thunderRangeMultiplier = (Double)VoiceConfig.THUNDER_RANGE_MULTIPLIER.get();
        double sneakingRangeMultiplier = (Double)VoiceConfig.SNEAKING_RANGE_MULTIPLIER.get();
        ArrayList<String> allIds = new ArrayList<String>(EntityVoiceConfig.getAllEntityIds());
        for (String id : allIds) {
            Object object2;
            EntityVoiceConfig.EntityConfig cfg = EntityVoiceConfig.getMonster(id);
            if (cfg == null) {
                cfg = EntityVoiceConfig.getAnimal(id);
            }
            if (cfg == null || !cfg.enabled) continue;
            double threshold = cfg.threshold;
            double detectionRange = cfg.range;
            double speed = cfg.speed;
            if (isWhispering) {
                detectionRange *= whisperRangeMultiplier;
                speed *= whisperSpeedMultiplier;
            }
            if ((object2 = sender.getPlayer().getPlayer()) instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)object2;
                if (p.isCrouching()) {
                    detectionRange *= sneakingRangeMultiplier;
                }
                if (p.level().isRaining() || p.level().isThundering()) {
                    detectionRange *= thunderRangeMultiplier;
                }
                double[] armorMult = ArmorEventHandler.getArmorMultipliers((Player)p);
                detectionRange *= armorMult[1];
                speed *= armorMult[0];
            }
            double modifiedRange = detectionRange;
            double distance = senderVec.distanceTo(new Vec3((double)playerPosition.getX(), (double)playerPosition.getY(), (double)playerPosition.getZ()));
            double distanceVolume = 1.0 - Math.min(distance, modifiedRange) / modifiedRange;
            if (!(audioLevel >= threshold) || !(distanceVolume > 0.0)) continue;
            BlockPos precisePos = new BlockPos((int)Math.floor(senderVec.x), (int)Math.floor(senderVec.y), (int)Math.floor(senderVec.z));
            playerSoundLocations.put(playerUUID, new SoundData(precisePos, audioLevel));
            if (this.DEBUG) {
                System.out.println("[DEBUG] " + id + " detects sound! Threshold: " + threshold + " dB | AudioLevel: " + audioLevel + " dB | Range: " + detectionRange + " | Speed: " + speed + " | Position: " + String.valueOf(precisePos));
            }
            if (!this.DEBUG) continue;
            System.out.println("[DEBUG] Intensity/range too low for " + id + ": " + audioLevel + " dB | " + distanceVolume);
        }
        scheduler.schedule(() -> playerSoundLocations.remove(playerUUID), 5L, TimeUnit.SECONDS);
    }
}

