/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.client.gui;

import com.armilp.ezvcsurvival.client.gui.list.ConfigListScreen;
import com.armilp.ezvcsurvival.util.ModInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class ConfigEditorScreen
extends Screen {
    private static final int BUTTON_WIDTH = 120;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_SPACING = 20;
    private int centerX;
    private int centerY;
    private int startY;

    public ConfigEditorScreen() {
        super((Component)Component.translatable((String)"screen.ezvcsurvival.config_editor"));
    }

    protected void init() {
        super.init();
        this.centerX = this.width / 2;
        this.centerY = this.height / 2;
        this.startY = Math.max(this.centerY - 30, 70);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.ezvcsurvival.entity_config"), btn -> Minecraft.getInstance().setScreen((Screen)new ConfigListScreen(ConfigListScreen.ListType.ENTITY_CONFIG, this))).bounds(this.centerX - 60, this.startY, 120, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.ezvcsurvival.general_sounds"), btn -> Minecraft.getInstance().setScreen((Screen)new ConfigListScreen(ConfigListScreen.ListType.GENERAL_SOUNDS_CONFIG, this))).bounds(this.centerX - 60, this.startY + 20, 120, 20).build());
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        int titleY = Math.max(30, this.height / 10);
        graphics.drawCenteredString(this.font, this.title, this.centerX + 1, titleY + 1, -2013265920);
        graphics.drawCenteredString(this.font, this.title, this.centerX, titleY, 0xFFFFFF);
        MutableComponent subtitle = Component.translatable((String)"screen.ezvcsurvival.config_editor.subtitle");
        int subtitleY = titleY + 20;
        graphics.drawCenteredString(this.font, (Component)subtitle, this.centerX, subtitleY, 0xCCCCCC);
        int subtitleWidth = this.font.width((FormattedText)subtitle);
        int lineY = subtitleY + 12;
        int lineWidth = Math.min(subtitleWidth + 30, this.width - 60);
        graphics.fill(this.centerX - lineWidth / 2, lineY, this.centerX + lineWidth / 2, lineY + 1, 0x44FFFFFF);
        MutableComponent info = Component.translatable((String)"screen.ezvcsurvival.config_editor.info");
        int infoY = lineY + 15;
        graphics.drawCenteredString(this.font, (Component)info, this.centerX, infoY, 0x888888);
        Component version = ModInfo.getVersion();
        int versionWidth = this.font.width((FormattedText)version);
        graphics.drawString(this.font, version, this.width - versionWidth - 10, 10, 0x666666, false);
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            Minecraft.getInstance().setScreen(null);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.centerX = this.width / 2;
        this.centerY = this.height / 2;
        this.startY = Math.max(this.centerY - 30, 70);
    }
}

