/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.client.gui.edit;

import com.armilp.ezvcsurvival.client.gui.edit.SoundFilterEditScreen;
import com.armilp.ezvcsurvival.client.gui.list.ConfigListScreen;
import com.armilp.ezvcsurvival.config.EntityVoiceConfig;
import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.config.SoundConfig;
import com.armilp.ezvcsurvival.network.UpdateConfigPacket;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public class ConfigEditScreen
extends Screen {
    private final Screen parent;
    private final EditType editType;
    private final String elementId;
    private final String elementName;
    private Button enabledButton;
    private EditBox speedBox;
    private EditBox rangeBox;
    private EditBox thresholdBox;
    private Button priorityButton;
    private Button saveButton;
    private Button soundFiltersButton;
    private boolean enabled;
    private double speed;
    private double range;
    private double threshold;
    private boolean isPriority;
    private boolean originalEnabled;
    private double originalSpeed;
    private double originalRange;
    private double originalThreshold;
    private boolean originalIsPriority;
    private static final int TOP_MARGIN = 30;
    private static final int CENTER_X_OFFSET = 80;
    private static final int FIELD_WIDTH = 160;
    private static final int FIELD_HEIGHT = 20;
    private static final int FIELD_SPACING = 30;
    private static final int BUTTON_WIDTH = 80;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_SPACING = 10;

    public ConfigEditScreen(Screen parent, EditType editType, String elementId, String elementName) {
        super((Component)Component.translatable((String)ConfigEditScreen.getTitleKey(editType), (Object[])new Object[]{elementName}));
        this.parent = parent;
        this.editType = editType;
        this.elementId = elementId;
        this.elementName = elementName;
        this.loadCurrentValues();
    }

    private static String getTitleKey(EditType editType) {
        return switch (editType.ordinal()) {
            case 0 -> "screen.ezvcsurvival.entity_config_edit";
            case 1 -> "screen.ezvcsurvival.general_sound_config_edit";
            case 2 -> "screen.ezvcsurvival.general_sound_entity_edit";
            default -> "screen.ezvcsurvival.config_edit";
        };
    }

    private void loadCurrentValues() {
        switch (this.editType.ordinal()) {
            case 0: {
                EntityVoiceConfig.EntityConfig entityConfig = EntityVoiceConfig.get(this.elementId);
                if (entityConfig != null) {
                    this.enabled = entityConfig.enabled;
                    this.speed = entityConfig.speed;
                    this.range = entityConfig.range;
                    this.threshold = entityConfig.threshold;
                    this.originalEnabled = entityConfig.enabled;
                    this.originalSpeed = entityConfig.speed;
                    this.originalRange = entityConfig.range;
                    this.originalThreshold = entityConfig.threshold;
                    break;
                }
                this.enabled = true;
                this.speed = 1.0;
                this.range = 50.0;
                this.threshold = 0.0;
                this.originalEnabled = this.enabled;
                this.originalSpeed = this.speed;
                this.originalRange = this.range;
                this.originalThreshold = this.threshold;
                break;
            }
            case 1: {
                GeneralSoundsConfig.SoundEntry soundConfig = GeneralSoundsConfig.getSounds().get(this.elementId);
                if (soundConfig != null) {
                    this.enabled = soundConfig.enabled;
                    this.speed = soundConfig.speed_multiplier;
                    this.range = soundConfig.range_multiplier;
                    this.isPriority = soundConfig.is_priority;
                    this.originalEnabled = soundConfig.enabled;
                    this.originalSpeed = soundConfig.speed_multiplier;
                    this.originalRange = soundConfig.range_multiplier;
                    this.originalIsPriority = soundConfig.is_priority;
                    break;
                }
                this.enabled = false;
                this.speed = 1.0;
                this.range = 1.0;
                this.isPriority = false;
                this.originalEnabled = this.enabled;
                this.originalSpeed = this.speed;
                this.originalRange = this.range;
                this.originalIsPriority = this.isPriority;
                break;
            }
            case 2: {
                GeneralSoundsConfig.Reaction generalReaction;
                Map<String, GeneralSoundsConfig.Reaction> reactions = GeneralSoundsConfig.getMobReactions();
                GeneralSoundsConfig.Reaction reaction = generalReaction = reactions != null ? reactions.get(this.elementId) : null;
                if (generalReaction != null) {
                    this.enabled = generalReaction.enabled;
                    this.speed = generalReaction.speed;
                    this.range = generalReaction.range;
                    this.originalEnabled = generalReaction.enabled;
                    this.originalSpeed = generalReaction.speed;
                    this.originalRange = generalReaction.range;
                    break;
                }
                this.enabled = true;
                this.speed = 1.0;
                this.range = 50.0;
                this.originalEnabled = this.enabled;
                this.originalSpeed = this.speed;
                this.originalRange = this.range;
            }
        }
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        int startY = 70;
        this.clearWidgets();
        this.initFields(centerX, startY);
        this.initActionButtons(centerX, startY);
        this.updateSaveButtonState();
    }

    private void initFields(int centerX, int startY) {
        int currentY = startY;
        this.enabledButton = Button.builder((Component)Component.translatable((String)(this.enabled ? "button.ezvcsurvival.enabled" : "button.ezvcsurvival.disabled")), b -> this.toggleEnabled()).bounds(centerX - 80, currentY, 160, 20).build();
        this.addRenderableWidget((GuiEventListener)this.enabledButton);
        this.speedBox = new EditBox(this.font, centerX - 80, currentY += 50, 160, 20, (Component)Component.literal((String)""));
        this.speedBox.setValue(String.valueOf(this.speed));
        this.speedBox.setMaxLength(20);
        this.speedBox.setResponder(s -> {
            try {
                this.speed = Double.parseDouble(s);
                this.updateSaveButtonState();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.addRenderableWidget((GuiEventListener)this.speedBox);
        this.rangeBox = new EditBox(this.font, centerX - 80, currentY += 50, 160, 20, (Component)Component.literal((String)""));
        this.rangeBox.setValue(String.valueOf(this.range));
        this.rangeBox.setMaxLength(20);
        this.rangeBox.setResponder(s -> {
            try {
                this.range = Double.parseDouble(s);
                this.updateSaveButtonState();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.addRenderableWidget((GuiEventListener)this.rangeBox);
        currentY += 50;
        if (this.editType == EditType.ENTITY_CONFIG) {
            this.thresholdBox = new EditBox(this.font, centerX - 80, currentY, 160, 20, (Component)Component.literal((String)""));
            this.thresholdBox.setValue(String.valueOf(this.threshold));
            this.thresholdBox.setMaxLength(20);
            this.thresholdBox.setResponder(s -> {
                try {
                    this.threshold = Double.parseDouble(s);
                    this.updateSaveButtonState();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            this.addRenderableWidget((GuiEventListener)this.thresholdBox);
            currentY += 50;
        }
        if (this.editType == EditType.GENERAL_SOUND_CONFIG) {
            this.priorityButton = Button.builder((Component)Component.translatable((String)(this.isPriority ? "button.ezvcsurvival.priority_on" : "button.ezvcsurvival.priority_off")), b -> this.togglePriority()).bounds(centerX - 80, currentY, 160, 20).build();
            this.addRenderableWidget((GuiEventListener)this.priorityButton);
            currentY += 50;
        }
        if (this.editType == EditType.GENERAL_SOUND_ENTITY) {
            this.soundFiltersButton = Button.builder((Component)Component.literal((String)"Sound Filters..."), b -> Minecraft.getInstance().setScreen((Screen)new SoundFilterEditScreen(this, this.elementId, this.elementName))).bounds(centerX - 80, currentY, 160, 20).build();
            this.addRenderableWidget((GuiEventListener)this.soundFiltersButton);
        }
    }

    private void initActionButtons(int centerX, int startY) {
        int fieldCount = this.getFieldCount();
        int buttonY = startY + fieldCount * 30 + 30;
        this.saveButton = Button.builder((Component)Component.translatable((String)"button.ezvcsurvival.save"), b -> this.saveConfig()).bounds(centerX - 80 - 80 - 10, buttonY, 80, 20).build();
        this.addRenderableWidget((GuiEventListener)this.saveButton);
        Button cancelButton = Button.builder((Component)Component.translatable((String)"button.ezvcsurvival.cancel"), b -> Minecraft.getInstance().setScreen(this.parent)).bounds(centerX + 80, buttonY, 80, 20).build();
        this.addRenderableWidget((GuiEventListener)cancelButton);
        Button resetButton = Button.builder((Component)Component.translatable((String)"button.ezvcsurvival.reset"), b -> this.resetToDefaults()).bounds(centerX - 40, buttonY + 10 + 20, 80, 20).build();
        this.addRenderableWidget((GuiEventListener)resetButton);
    }

    private int getFieldCount() {
        return switch (this.editType.ordinal()) {
            case 0, 1, 2 -> 4;
            default -> 3;
        };
    }

    private void toggleEnabled() {
        this.enabled = !this.enabled;
        this.enabledButton.setMessage((Component)Component.translatable((String)(this.enabled ? "button.ezvcsurvival.enabled" : "button.ezvcsurvival.disabled")));
        this.updateSaveButtonState();
    }

    private void togglePriority() {
        this.isPriority = !this.isPriority;
        this.priorityButton.setMessage((Component)Component.translatable((String)(this.isPriority ? "button.ezvcsurvival.priority_on" : "button.ezvcsurvival.priority_off")));
        this.updateSaveButtonState();
    }

    private void saveConfig() {
        block16: {
            try {
                boolean localSuccess;
                try {
                    this.speed = Double.parseDouble(this.speedBox.getValue());
                    this.range = Double.parseDouble(this.rangeBox.getValue());
                    if (this.thresholdBox != null) {
                        this.threshold = Double.parseDouble(this.thresholdBox.getValue());
                    }
                }
                catch (NumberFormatException e) {
                    this.showError();
                    return;
                }
                if (this.editType == EditType.ENTITY_CONFIG && this.thresholdBox != null) {
                    this.threshold = Math.max(-100.0, Math.min(100.0, this.threshold));
                }
                switch (this.editType.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        EntityVoiceConfig.set(this.elementId, new EntityVoiceConfig.EntityConfig(this.enabled, this.speed, this.range, this.threshold));
                        EntityVoiceConfig.persist();
                        boolean bl = true;
                        break;
                    }
                    case 1: {
                        boolean bl;
                        GeneralSoundsConfig.setSoundEntry(this.elementId, this.enabled, this.speed, this.range, this.isPriority);
                        GeneralSoundsConfig.persist();
                        GeneralSoundsConfig.SoundEntry updated = GeneralSoundsConfig.getSounds().get(this.elementId);
                        if (updated != null && updated.enabled == this.enabled && Math.abs(updated.speed_multiplier - this.speed) < 0.001 && Math.abs(updated.range_multiplier - this.range) < 0.001 && updated.is_priority == this.isPriority) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 2: {
                        GeneralSoundsConfig.setMobReaction(this.elementId, this.enabled, this.speed, this.range);
                        GeneralSoundsConfig.persist();
                        boolean bl = localSuccess = true;
                    }
                }
                if (localSuccess) {
                    try {
                        SoundConfig.loadConfigs();
                    }
                    catch (Exception updated) {
                        // empty catch block
                    }
                    this.sendUpdate();
                    this.updateOriginalValues();
                    Screen screen = this.parent;
                    if (screen instanceof ConfigListScreen) {
                        ConfigListScreen configList = (ConfigListScreen)screen;
                        configList.onConfigUpdated();
                    }
                    Minecraft.getInstance().setScreen(this.parent);
                    break block16;
                }
                this.showError();
            }
            catch (Exception e) {
                this.showError();
            }
        }
    }

    private void resetToDefaults() {
        switch (this.editType.ordinal()) {
            case 0: {
                EntityVoiceConfig.EntityConfig defaultConfig = EntityVoiceConfig.EntityConfig.defaultFor(null);
                this.enabled = defaultConfig.enabled;
                this.speed = defaultConfig.speed;
                this.range = defaultConfig.range;
                this.threshold = defaultConfig.threshold;
                if (this.thresholdBox == null) break;
                this.thresholdBox.setValue(String.valueOf(this.threshold));
                break;
            }
            case 1: {
                this.enabled = false;
                this.speed = 1.0;
                this.range = 1.0;
                this.isPriority = false;
                if (this.priorityButton == null) break;
                this.priorityButton.setMessage((Component)Component.translatable((String)(this.isPriority ? "button.ezvcsurvival.priority_on" : "button.ezvcsurvival.priority_off")));
                break;
            }
            case 2: {
                this.enabled = true;
                this.speed = 1.0;
                this.range = 50.0;
            }
        }
        if (this.enabledButton != null) {
            this.enabledButton.setMessage((Component)Component.translatable((String)(this.enabled ? "button.ezvcsurvival.enabled" : "button.ezvcsurvival.disabled")));
        }
        if (this.speedBox != null) {
            this.speedBox.setValue(String.valueOf(this.speed));
        }
        if (this.rangeBox != null) {
            this.rangeBox.setValue(String.valueOf(this.range));
        }
        this.updateSaveButtonState();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        int titleY = 30;
        graphics.drawCenteredString(this.font, this.title, this.width / 2 + 1, titleY + 1, -2013265920);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, titleY, 0xFFFFFF);
        String elementInfo = "ID: " + this.elementId;
        int elementInfoY = titleY + 18;
        graphics.drawCenteredString(this.font, elementInfo, this.width / 2, elementInfoY, 0xAAAAAA);
        int lineY = elementInfoY + 10;
        int lineWidth = Math.min(180, this.width - 100);
        graphics.fill(this.width / 2 - lineWidth / 2, lineY, this.width / 2 + lineWidth / 2, lineY + 1, 0x44FFFFFF);
        this.renderFieldLabels(graphics);
    }

    private void renderFieldLabels(GuiGraphics graphics) {
        int startY;
        int centerX = this.width / 2;
        int currentY = startY = 70;
        graphics.drawString(this.font, "Enabled", centerX - 80, currentY - 15, 0xFFFFFF);
        graphics.drawString(this.font, "Speed", centerX - 80, (currentY += 50) - 15, 0xFFFFFF);
        graphics.drawString(this.font, "Range", centerX - 80, (currentY += 50) - 15, 0xFFFFFF);
        currentY += 50;
        if (this.editType == EditType.ENTITY_CONFIG) {
            graphics.drawString(this.font, "Threshold", centerX - 80, currentY - 15, 0xFFFFFF);
            currentY += 50;
        }
        if (this.editType == EditType.GENERAL_SOUND_CONFIG) {
            graphics.drawString(this.font, "Priority Sound", centerX - 80, currentY - 15, 0xFFFFFF);
        }
        if (this.editType == EditType.GENERAL_SOUND_ENTITY) {
            graphics.drawString(this.font, "Configure Filters", centerX - 80, currentY - 15, 0xFFFFFF);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            Minecraft.getInstance().setScreen(this.parent);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void sendUpdate() {
        try {
            switch (this.editType.ordinal()) {
                case 0: {
                    PacketDistributor.sendToServer((CustomPacketPayload)new UpdateConfigPacket(this.elementId, this.enabled, this.speed, this.range, this.threshold), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    break;
                }
                case 1: {
                    PacketDistributor.sendToServer((CustomPacketPayload)new UpdateConfigPacket(UpdateConfigPacket.ConfigType.GENERAL_SOUND, this.elementId, this.enabled, this.speed, this.range, this.isPriority), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    break;
                }
                case 2: {
                    PacketDistributor.sendToServer((CustomPacketPayload)new UpdateConfigPacket(UpdateConfigPacket.ConfigType.GENERAL_SOUND_ENTITY, this.elementId, this.enabled, this.speed, this.range), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
        catch (Exception e) {
            System.err.println("[EZVCSurvival] Error sending configuration: " + e.getMessage());
        }
    }

    private boolean hasChanges() {
        return switch (this.editType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this.enabled != this.originalEnabled || this.speed != this.originalSpeed || this.range != this.originalRange || this.threshold != this.originalThreshold) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (this.enabled != this.originalEnabled || this.speed != this.originalSpeed || this.range != this.originalRange || this.isPriority != this.originalIsPriority) {
                    yield true;
                }
                yield false;
            }
            case 2 -> this.enabled != this.originalEnabled || this.speed != this.originalSpeed || this.range != this.originalRange;
        };
    }

    private void updateSaveButtonState() {
        if (this.saveButton != null) {
            boolean hasChanges;
            this.saveButton.active = hasChanges = this.hasChanges();
            if (hasChanges) {
                this.saveButton.setMessage((Component)Component.translatable((String)"button.ezvcsurvival.save"));
            } else {
                this.saveButton.setMessage((Component)Component.translatable((String)"button.ezvcsurvival.no_changes"));
            }
        }
    }

    private void updateOriginalValues() {
        switch (this.editType.ordinal()) {
            case 0: {
                this.originalEnabled = this.enabled;
                this.originalSpeed = this.speed;
                this.originalRange = this.range;
                this.originalThreshold = this.threshold;
                break;
            }
            case 1: {
                this.originalEnabled = this.enabled;
                this.originalSpeed = this.speed;
                this.originalRange = this.range;
                this.originalIsPriority = this.isPriority;
                break;
            }
            case 2: {
                this.originalEnabled = this.enabled;
                this.originalSpeed = this.speed;
                this.originalRange = this.range;
            }
        }
    }

    private void showError() {
        System.err.println("[EZVCSurvival] Error: Values must be valid numbers.");
    }

    public static enum EditType {
        ENTITY_CONFIG,
        GENERAL_SOUND_CONFIG,
        GENERAL_SOUND_ENTITY;

    }
}

