/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.client.gui.list;

import com.armilp.ezvcsurvival.client.gui.ConfigEditorScreen;
import com.armilp.ezvcsurvival.client.gui.list.ConfigListWidget;
import com.armilp.ezvcsurvival.config.EntityVoiceConfig;
import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.network.UpdateConfigPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class ConfigListScreen
extends Screen {
    private final ListType listType;
    private final Screen parent;
    private EditBox searchBox;
    private String searchQuery = "";
    private Button clearSearchButton;
    private Button backButton;
    private Button toggleViewButton;
    private Button toggleEnabledButton;
    private ConfigListWidget list;
    private List<Object> items;
    private boolean showingSounds = true;
    private static final int MIN_WIDTH = 400;
    private static final int MIN_BUTTON_WIDTH = 60;
    private static final int MAX_BUTTON_WIDTH = 120;
    private static final int BUTTON_HEIGHT = 20;
    private static final int SEARCH_HEIGHT = 20;
    private static final int VERTICAL_SPACING = 6;
    private static final int HORIZONTAL_SPACING = 6;

    public ConfigListScreen(ListType listType, Screen parent) {
        super((Component)Component.translatable((String)ConfigListScreen.getTitleKey(listType)));
        this.listType = listType;
        this.parent = parent;
        this.items = new ArrayList<Object>();
        if (this.listType == ListType.GENERAL_SOUNDS_CONFIG) {
            this.showingSounds = false;
        }
    }

    private static String getTitleKey(ListType type) {
        switch (type.ordinal()) {
            case 0: {
                return "screen.ezvcsurvival.entity_config_list";
            }
            case 1: {
                return "screen.ezvcsurvival.general_sounds_config_list";
            }
        }
        return "screen.ezvcsurvival.config_list";
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void init() {
        int leftMargin;
        super.init();
        int usableWidth = Math.max(this.width - 40, 400);
        int rightMargin = leftMargin = (this.width - usableWidth) / 2;
        int topRowY = 20;
        int searchRowY = topRowY + 20 + 12;
        int listStartY = searchRowY + 20 + 18;
        int availableButtonWidth = usableWidth;
        int buttonCount = this.getButtonCount();
        int buttonWidth = Math.min(120, Math.max(60, (availableButtonWidth - (buttonCount - 1) * 6) / buttonCount));
        this.backButton = Button.builder((Component)Component.translatable((String)"button.ezvcsurvival.back"), b -> Minecraft.getInstance().setScreen((Screen)(this.parent != null ? this.parent : new ConfigEditorScreen()))).bounds(leftMargin, topRowY, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.backButton);
        int currentX = leftMargin + buttonWidth + 6;
        if (this.listType == ListType.GENERAL_SOUNDS_CONFIG) {
            this.toggleViewButton = Button.builder((Component)Component.translatable((String)(this.showingSounds ? "button.ezvcsurvival.show_entities" : "button.ezvcsurvival.show_sounds")), b -> this.toggleView()).bounds(currentX, topRowY, buttonWidth, 20).build();
            this.addRenderableWidget((GuiEventListener)this.toggleViewButton);
            currentX += buttonWidth + 6;
        }
        if (this.listType == ListType.GENERAL_SOUNDS_CONFIG || this.listType == ListType.ENTITY_CONFIG) {
            this.toggleEnabledButton = Button.builder((Component)this.getToggleEnabledMessage(), b -> this.toggleEnabled()).bounds(currentX, topRowY, buttonWidth, 20).build();
            this.addRenderableWidget((GuiEventListener)this.toggleEnabledButton);
            currentX += buttonWidth + 6;
        }
        int searchWidth = Math.min(300, usableWidth - 100);
        this.searchBox = new EditBox(this.font, leftMargin, searchRowY, searchWidth, 20, (Component)Component.translatable((String)"textbox.ezvcsurvival.search"));
        this.searchBox.setResponder(this::onSearchChanged);
        this.searchBox.setMaxLength(50);
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        this.clearSearchButton = Button.builder((Component)Component.literal((String)"\u2715"), b -> this.searchBox.setValue("")).bounds(leftMargin + searchWidth + 6, searchRowY, 20, 20).build();
        this.addRenderableWidget((GuiEventListener)this.clearSearchButton);
        this.list = new ConfigListWidget(this, this.minecraft, this.width, this.height, listStartY, 28, 20);
        this.addWidget((GuiEventListener)this.list);
        if (this.items == null || this.items.isEmpty()) {
            this.loadData();
        }
        this.updateList();
    }

    private int getButtonCount() {
        int count = 2;
        if (this.listType == ListType.GENERAL_SOUNDS_CONFIG) {
            count += 2;
        } else if (this.listType == ListType.ENTITY_CONFIG) {
            ++count;
        }
        return count;
    }

    private void loadData() {
        this.items = new ArrayList<Object>();
        switch (this.listType.ordinal()) {
            case 0: {
                this.loadEntityConfigs();
                break;
            }
            case 1: {
                if (this.showingSounds) {
                    this.loadGeneralSoundConfigs();
                    break;
                }
                this.loadGeneralEntityConfigs();
            }
        }
    }

    private void loadEntityConfigs() {
        this.items.clear();
        for (EntityType type : BuiltInRegistries.ENTITY_TYPE) {
            MobCategory category = type.getCategory();
            if (category == MobCategory.MISC) continue;
            String id = Objects.requireNonNull(BuiltInRegistries.ENTITY_TYPE.getKey((Object)type)).toString();
            EntityVoiceConfig.EntityConfig config = EntityVoiceConfig.get(id);
            if (config == null) {
                config = EntityVoiceConfig.EntityConfig.defaultFor(type);
                EntityVoiceConfig.set(id, config);
            }
            this.items.add(new EntityConfigItem(id, type, config));
        }
        this.items.sort(Comparator.comparing(item -> ((EntityConfigItem)item).getDisplayName()));
    }

    private void loadGeneralSoundConfigs() {
        this.items.clear();
        Map<String, GeneralSoundsConfig.SoundEntry> soundConfigs = GeneralSoundsConfig.getSounds();
        for (SoundEvent sound : BuiltInRegistries.SOUND_EVENT) {
            String id = Objects.requireNonNull(BuiltInRegistries.SOUND_EVENT.getKey((Object)sound)).toString();
            GeneralSoundsConfig.SoundEntry config = soundConfigs.get(id);
            if (config == null) {
                config = new GeneralSoundsConfig.SoundEntry(false, 1.0, 1.0);
                GeneralSoundsConfig.setSoundEntry(id, false, 1.0, 1.0);
            }
            this.items.add(new SoundConfigItem(id, sound, config, false));
        }
        this.items.sort(Comparator.comparing(item -> ((SoundConfigItem)item).getId()));
    }

    private void loadGeneralEntityConfigs() {
        this.items.clear();
        Map<String, GeneralSoundsConfig.Reaction> entityConfigs = GeneralSoundsConfig.getMobReactions();
        if (entityConfigs == null) {
            entityConfigs = Collections.emptyMap();
        }
        for (EntityType type : BuiltInRegistries.ENTITY_TYPE) {
            MobCategory category = type.getCategory();
            if (category == MobCategory.MISC) continue;
            String id = Objects.requireNonNull(BuiltInRegistries.ENTITY_TYPE.getKey((Object)type)).toString();
            GeneralSoundsConfig.Reaction reaction = entityConfigs.get(id);
            if (reaction == null) {
                reaction = new GeneralSoundsConfig.Reaction(true, 1.0, category == MobCategory.MONSTER ? 60.0 : 50.0);
                GeneralSoundsConfig.setMobReaction(id, true, 1.0, category == MobCategory.MONSTER ? 60.0 : 50.0);
            }
            this.items.add(new EntityReactionItem(id, reaction));
        }
        this.items.sort(Comparator.comparing(item -> ((EntityReactionItem)item).getId()));
    }

    private void toggleView() {
        if (this.listType != ListType.GENERAL_SOUNDS_CONFIG) {
            return;
        }
        this.showingSounds = !this.showingSounds;
        this.toggleViewButton.setMessage((Component)Component.translatable((String)(this.showingSounds ? "button.ezvcsurvival.show_entities" : "button.ezvcsurvival.show_sounds")));
        this.safeRefresh();
    }

    private void toggleEnabled() {
        switch (this.listType.ordinal()) {
            case 0: {
                boolean newEntityState;
                EntityVoiceConfig.ROOT.enabled = newEntityState = !EntityVoiceConfig.isEnabled();
                EntityVoiceConfig.persist();
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateConfigPacket(UpdateConfigPacket.ConfigType.ENTITY_VOICE, "global", newEntityState, 1.0, 1.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                break;
            }
            case 1: {
                boolean newGeneralState;
                GeneralSoundsConfig.ROOT.enabled = newGeneralState = !GeneralSoundsConfig.isEnabled();
                GeneralSoundsConfig.persist();
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateConfigPacket(UpdateConfigPacket.ConfigType.GENERAL_SOUND, "global", newGeneralState, 1.0, 1.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        this.toggleEnabledButton.setMessage(this.getToggleEnabledMessage());
        this.safeRefresh();
    }

    private Component getToggleEnabledMessage() {
        boolean isEnabled = false;
        switch (this.listType.ordinal()) {
            case 0: {
                isEnabled = EntityVoiceConfig.isEnabled();
                break;
            }
            case 1: {
                isEnabled = GeneralSoundsConfig.isEnabled();
            }
        }
        return Component.translatable((String)(isEnabled ? "button.ezvcsurvival.disable_all" : "button.ezvcsurvival.enable_all"));
    }

    public void refreshData() {
        this.safeRefresh();
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateConfigPacket(UpdateConfigPacket.ConfigType.GENERAL_SOUND, "refresh", true, 1.0, 1.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void updateList() {
        this.list.clear();
        ArrayList<Object> filtered = new ArrayList<Object>();
        for (Object item : this.items) {
            String searchableText = this.getSearchableText(item).toLowerCase();
            if (!this.searchQuery.isEmpty() && !searchableText.contains(this.searchQuery)) continue;
            filtered.add(item);
        }
        for (Object item : filtered) {
            this.list.addItem(item);
        }
    }

    private String getSearchableText(Object item) {
        if (item instanceof EntityConfigItem) {
            return ((EntityConfigItem)item).getDisplayName() + " " + ((EntityConfigItem)item).getId();
        }
        if (item instanceof SoundConfigItem) {
            return ((SoundConfigItem)item).getId();
        }
        if (item instanceof EntityReactionItem) {
            return ((EntityReactionItem)item).getId();
        }
        return "";
    }

    private void onSearchChanged(String query) {
        this.searchQuery = query.trim().toLowerCase();
        this.updateList();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 8, 0xFFFFFF);
        int titleWidth = this.font.width((FormattedText)this.title);
        int separatorY = 20;
        graphics.fill(this.width / 2 - titleWidth / 2 - 10, separatorY, this.width / 2 + titleWidth / 2 + 10, separatorY + 1, 0x55FFFFFF);
        this.list.render(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        this.searchBox.render(graphics, mouseX, mouseY, partialTick);
        if (this.searchBox.getValue().isEmpty() && !this.searchBox.isFocused()) {
            graphics.drawString(this.font, this.searchBox.getMessage().getString(), this.searchBox.getX() + 4, this.searchBox.getY() + 6, 0x888888, false);
        }
        int searchLabelY = this.searchBox.getY() - 12;
        graphics.drawString(this.font, (Component)Component.translatable((String)"gui.ezvcsurvival.search"), this.searchBox.getX(), searchLabelY, 0xCCCCCC, false);
        this.renderFooter(graphics);
        this.renderTooltips(graphics, mouseX, mouseY);
    }

    private void renderFooter(GuiGraphics graphics) {
        int footerY = this.height - 30;
        int leftMargin = (this.width - Math.max(this.width - 40, 400)) / 2;
        Component count = this.getCountComponent();
        int countWidth = this.font.width((FormattedText)count);
        graphics.drawString(this.font, count, this.width - countWidth - leftMargin, footerY, 0xAAAAAA, false);
        Component instructions = this.getInstructionsComponent();
        graphics.drawString(this.font, instructions, leftMargin, footerY, 0xCCCCCC, false);
    }

    private Component getCountComponent() {
        if (this.listType == ListType.ENTITY_CONFIG) {
            return Component.translatable((String)"gui.ezvcsurvival.entity_count", (Object[])new Object[]{this.list.children().size()});
        }
        if (this.listType == ListType.GENERAL_SOUNDS_CONFIG) {
            if (this.showingSounds) {
                return Component.translatable((String)"gui.ezvcsurvival.sound_count", (Object[])new Object[]{this.list.children().size()});
            }
            return Component.translatable((String)"gui.ezvcsurvival.entity_count", (Object[])new Object[]{this.list.children().size()});
        }
        return Component.translatable((String)"gui.ezvcsurvival.entity_count", (Object[])new Object[]{this.list.children().size()});
    }

    private Component getInstructionsComponent() {
        if (this.listType == ListType.ENTITY_CONFIG) {
            return Component.translatable((String)"gui.ezvcsurvival.click_to_edit_entity");
        }
        if (this.listType == ListType.GENERAL_SOUNDS_CONFIG) {
            if (this.showingSounds) {
                return Component.translatable((String)"gui.ezvcsurvival.click_to_edit_sound");
            }
            return Component.translatable((String)"gui.ezvcsurvival.click_to_edit_entity");
        }
        return Component.translatable((String)"gui.ezvcsurvival.click_to_edit_entity");
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.searchBox.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.minecraft.setScreen((Screen)(this.parent != null ? this.parent : new ConfigEditorScreen()));
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void tick() {
        super.tick();
    }

    public void onConfigUpdated() {
        this.loadData();
        this.updateList();
        switch (this.listType.ordinal()) {
            case 0: {
                EntityVoiceConfig.persist();
                break;
            }
            case 1: {
                GeneralSoundsConfig.persist();
            }
        }
    }

    public void safeRefresh() {
        if (this.minecraft != null && this.minecraft.screen == this) {
            this.loadData();
            this.updateList();
        }
    }

    private void renderTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.list == null) {
            return;
        }
        if (!this.list.isMouseOver(mouseX, mouseY)) {
            return;
        }
        int index = this.list.getEntryIndexAt(mouseX, mouseY);
        if (index < 0 || index >= this.list.children().size()) {
            return;
        }
        ConfigListWidget.Entry entry = (ConfigListWidget.Entry)((Object)this.list.children().get(index));
        if (entry instanceof ConfigListWidget.UniversalEntry) {
            ConfigListWidget.UniversalEntry universalEntry = (ConfigListWidget.UniversalEntry)entry;
            universalEntry.renderTooltip(graphics, mouseX, mouseY);
        }
    }

    public static enum ListType {
        ENTITY_CONFIG,
        GENERAL_SOUNDS_CONFIG;

    }

    public static class EntityConfigItem {
        private final String id;
        private final EntityType<?> type;
        private final EntityVoiceConfig.EntityConfig config;

        public EntityConfigItem(String id, EntityType<?> type, EntityVoiceConfig.EntityConfig config) {
            this.id = id;
            this.type = type;
            this.config = config;
        }

        public String getId() {
            return this.id;
        }

        public EntityVoiceConfig.EntityConfig getConfig() {
            return this.config;
        }

        public String getDisplayName() {
            return this.type.getDescription().getString();
        }
    }

    public static class SoundConfigItem {
        private final String id;
        private final SoundEvent sound;
        private final GeneralSoundsConfig.SoundEntry config;
        private final boolean isPriority;

        public SoundConfigItem(String id, SoundEvent sound, GeneralSoundsConfig.SoundEntry config, boolean isPriority) {
            this.id = id;
            this.sound = sound;
            this.config = config;
            this.isPriority = isPriority;
        }

        public String getId() {
            return this.id;
        }

        public SoundEvent getSound() {
            return this.sound;
        }

        public GeneralSoundsConfig.SoundEntry getConfig() {
            return this.config;
        }
    }

    public static class EntityReactionItem {
        private final String id;
        private final GeneralSoundsConfig.Reaction reaction;

        public EntityReactionItem(String id, GeneralSoundsConfig.Reaction reaction) {
            this.id = id;
            this.reaction = reaction;
        }

        public String getId() {
            return this.id;
        }

        public GeneralSoundsConfig.Reaction getReaction() {
            return this.reaction;
        }
    }
}

