/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.client.gui.list;

import com.armilp.ezvcsurvival.client.gui.edit.ConfigEditScreen;
import com.armilp.ezvcsurvival.client.gui.list.ConfigListScreen;
import com.armilp.ezvcsurvival.config.EntityVoiceConfig;
import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class ConfigListWidget
extends ObjectSelectionList<Entry> {
    private final ConfigListScreen parent;
    private static final int MIN_ENTRY_WIDTH = 300;
    private static final int STATUS_AREA_WIDTH = 120;
    private static final int PADDING = 10;

    public ConfigListWidget(ConfigListScreen parent, Minecraft mc, int width, int height, int top, int bottom, int itemHeight) {
        super(mc, width, height, top, itemHeight);
        this.parent = parent;
    }

    public void addItem(Object item) {
        this.addEntry((AbstractSelectionList.Entry)new UniversalEntry(item));
    }

    public void clear() {
        this.clearEntries();
    }

    public int getEntryIndexAt(double mouseX, double mouseY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return -1;
        }
        int rowLeft = this.getRowLeft();
        int rowWidth = this.getRowWidth();
        int count = this.children().size();
        for (int i = 0; i < count; ++i) {
            int rowTop = this.getRowTop(i);
            int rowBottom = rowTop + this.itemHeight;
            if (!(mouseX >= (double)rowLeft) || !(mouseX <= (double)(rowLeft + rowWidth)) || !(mouseY >= (double)rowTop) || !(mouseY <= (double)rowBottom)) continue;
            return i;
        }
        return -1;
    }

    public int getRowWidth() {
        return Math.max(300, this.width - 20);
    }

    public int getRowLeft() {
        return 10;
    }

    protected int getScrollbarPosition() {
        return this.getRowLeft() + this.getRowWidth() + 5;
    }

    public class UniversalEntry
    extends Entry {
        private final Object item;

        public UniversalEntry(Object item) {
            this.item = item;
        }

        public void render(@NotNull GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
            boolean validHover;
            int actualLeft = ConfigListWidget.this.getRowLeft();
            int actualWidth = ConfigListWidget.this.getRowWidth();
            boolean bl = validHover = hovered && mouseX >= actualLeft && mouseX <= actualLeft + actualWidth;
            if (validHover) {
                graphics.fill(actualLeft, top, actualLeft + actualWidth, top + height, 0x30FFFFFF);
                graphics.fill(actualLeft, top, actualLeft + actualWidth, top + 1, 0x60FFFFFF);
                graphics.fill(actualLeft, top + height - 1, actualLeft + actualWidth, top + height, 0x60FFFFFF);
            }
            if (index % 2 == 0) {
                graphics.fill(actualLeft, top, actualLeft + actualWidth, top + height, 0x10000000);
            }
            int centerY = top + height / 2;
            int textLeft = actualLeft + 10;
            int statusRight = actualLeft + actualWidth - 10;
            if (this.item instanceof ConfigListScreen.EntityConfigItem) {
                this.renderEntityConfig(graphics, textLeft, top, actualWidth, height, centerY, statusRight);
            } else if (this.item instanceof ConfigListScreen.SoundConfigItem) {
                this.renderSoundConfig(graphics, textLeft, top, actualWidth, height, centerY, statusRight);
            } else if (this.item instanceof ConfigListScreen.EntityReactionItem) {
                this.renderEntityReaction(graphics, textLeft, top, actualWidth, height, centerY, statusRight);
            }
        }

        private void renderEntityConfig(GuiGraphics graphics, int textLeft, int top, int width, int height, int centerY, int statusRight) {
            ConfigListScreen.EntityConfigItem entityItem = (ConfigListScreen.EntityConfigItem)this.item;
            String entityName = entityItem.getDisplayName();
            int maxTextWidth = width - 120 - 20;
            String displayName = this.truncateText(entityName, maxTextWidth);
            graphics.drawString(Minecraft.getInstance().font, displayName, textLeft, centerY - 4, 0xFFFFFF, false);
            MutableComponent statusText = entityItem.getConfig().enabled ? Component.translatable((String)"gui.ezvcsurvival.enabled") : Component.translatable((String)"gui.ezvcsurvival.disabled");
            int statusColor = entityItem.getConfig().enabled ? 0x55FF55 : 0xFF5555;
            int statusWidth = Minecraft.getInstance().font.width((FormattedText)statusText);
            graphics.fill(statusRight - statusWidth - 6, centerY - 8, statusRight, centerY + 8, entityItem.getConfig().enabled ? 542506837 : 553604437);
            graphics.drawString(Minecraft.getInstance().font, (Component)statusText, statusRight - statusWidth - 3, centerY - 4, statusColor, false);
        }

        private void renderSoundConfig(GuiGraphics graphics, int textLeft, int top, int width, int height, int centerY, int statusRight) {
            ConfigListScreen.SoundConfigItem soundItem = (ConfigListScreen.SoundConfigItem)this.item;
            String soundName = soundItem.getId();
            int maxTextWidth = width - 120 - 20;
            String displayName = this.truncateText(soundName, maxTextWidth);
            graphics.drawString(Minecraft.getInstance().font, displayName, textLeft, centerY - 4, 0xFFFFFF, false);
            MutableComponent statusText = soundItem.getConfig().enabled ? Component.translatable((String)"gui.ezvcsurvival.enabled") : Component.translatable((String)"gui.ezvcsurvival.disabled");
            int statusColor = soundItem.getConfig().enabled ? 0x55FF55 : 0xFF5555;
            int statusWidth = Minecraft.getInstance().font.width((FormattedText)statusText);
            graphics.fill(statusRight - statusWidth - 6, centerY - 8, statusRight, centerY + 8, soundItem.getConfig().enabled ? 542506837 : 553604437);
            graphics.drawString(Minecraft.getInstance().font, (Component)statusText, statusRight - statusWidth - 3, centerY - 4, statusColor, false);
        }

        private void renderEntityReaction(GuiGraphics graphics, int textLeft, int top, int width, int height, int centerY, int statusRight) {
            ConfigListScreen.EntityReactionItem entityItem = (ConfigListScreen.EntityReactionItem)this.item;
            String entityId = entityItem.getId();
            String entityName = this.getEntityDisplayName(entityId);
            int maxTextWidth = width - 120 - 20;
            String displayName = this.truncateText(entityName, maxTextWidth);
            graphics.drawString(Minecraft.getInstance().font, displayName, textLeft, centerY - 4, 0xFFFFFF, false);
            MutableComponent statusText = entityItem.getReaction().enabled ? Component.translatable((String)"gui.ezvcsurvival.enabled") : Component.translatable((String)"gui.ezvcsurvival.disabled");
            int statusColor = entityItem.getReaction().enabled ? 0x55FF55 : 0xFF5555;
            int statusWidth = Minecraft.getInstance().font.width((FormattedText)statusText);
            graphics.fill(statusRight - statusWidth - 6, centerY - 8, statusRight, centerY + 8, entityItem.getReaction().enabled ? 542506837 : 553604437);
            graphics.drawString(Minecraft.getInstance().font, (Component)statusText, statusRight - statusWidth - 3, centerY - 4, statusColor, false);
        }

        private String truncateText(String text, int maxWidth) {
            if (maxWidth <= 0) {
                return text;
            }
            int textWidth = Minecraft.getInstance().font.width(text);
            if (textWidth <= maxWidth) {
                return text;
            }
            String ellipsis = "...";
            int ellipsisWidth = Minecraft.getInstance().font.width(ellipsis);
            int availableWidth = maxWidth - ellipsisWidth;
            if (availableWidth <= 0) {
                return ellipsis;
            }
            int left = 0;
            int right = text.length();
            while (left < right) {
                int mid = (left + right + 1) / 2;
                String truncated = text.substring(0, mid);
                if (Minecraft.getInstance().font.width(truncated) <= availableWidth) {
                    left = mid;
                    continue;
                }
                right = mid - 1;
            }
            return text.substring(0, left) + ellipsis;
        }

        private String getEntityDisplayName(String entityId) {
            try {
                ResourceLocation key = ResourceLocation.parse((String)entityId);
                EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(key);
                if (type != null) {
                    String translationKey = type.getDescriptionId();
                    return Component.translatable((String)translationKey).getString();
                }
                return key.getPath();
            }
            catch (Exception ignored) {
                return entityId.contains(":") ? entityId.substring(entityId.indexOf(58) + 1) : entityId;
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.openEditScreen();
                return true;
            }
            return false;
        }

        public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
            List<Component> tooltipLines = this.getTooltipLines();
            if (tooltipLines.isEmpty()) {
                return;
            }
            Font font = Minecraft.getInstance().font;
            int guiW = graphics.guiWidth();
            int guiH = graphics.guiHeight();
            int maxLineWidth = 0;
            for (Component c : tooltipLines) {
                int w = font.width((FormattedText)c);
                if (w <= maxLineWidth) continue;
                maxLineWidth = w;
            }
            int lineHeight = 10;
            int padding = 8;
            int tooltipHeight = padding + tooltipLines.size() * lineHeight;
            int tooltipX = mouseX + 12;
            int tooltipY = mouseY - 12;
            if (tooltipX + maxLineWidth + padding > guiW) {
                tooltipX = Math.max(8, mouseX - 12 - maxLineWidth - padding);
            }
            if (tooltipY + tooltipHeight > guiH) {
                tooltipY = Math.max(8, guiH - tooltipHeight - 8);
            }
            if (tooltipY < 8) {
                tooltipY = mouseY + 12;
            }
            graphics.renderComponentTooltip(font, tooltipLines, tooltipX, tooltipY);
        }

        private List<Component> getTooltipLines() {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            Object object = this.item;
            if (object instanceof ConfigListScreen.EntityConfigItem) {
                ConfigListScreen.EntityConfigItem entityItem = (ConfigListScreen.EntityConfigItem)object;
                config = entityItem.getConfig();
                tooltip.add((Component)Component.literal((String)("\u00a76\u00a7l" + entityItem.getDisplayName())));
                tooltip.add((Component)Component.literal((String)("\u00a77ID: \u00a7f" + entityItem.getId())));
                tooltip.add((Component)Component.literal((String)""));
                tooltip.add((Component)Component.translatable((String)"tooltip.ezvcsurvival.configuration"));
                tooltip.add((Component)Component.translatable((String)"tooltip.ezvcsurvival.enabled", (Object[])new Object[]{((EntityVoiceConfig.EntityConfig)config).enabled ? Component.translatable((String)"gui.ezvcsurvival.enabled") : Component.translatable((String)"gui.ezvcsurvival.disabled")}));
                tooltip.add((Component)Component.translatable((String)"tooltip.ezvcsurvival.speed", (Object[])new Object[]{Component.literal((String)("\u00a7e" + ((EntityVoiceConfig.EntityConfig)config).speed))}));
                tooltip.add((Component)Component.translatable((String)"tooltip.ezvcsurvival.range", (Object[])new Object[]{Component.literal((String)("\u00a7e" + ((EntityVoiceConfig.EntityConfig)config).range))}));
                tooltip.add((Component)Component.translatable((String)"tooltip.ezvcsurvival.threshold", (Object[])new Object[]{Component.literal((String)("\u00a7e" + ((EntityVoiceConfig.EntityConfig)config).threshold))}));
            } else {
                config = this.item;
                if (config instanceof ConfigListScreen.SoundConfigItem) {
                    ConfigListScreen.SoundConfigItem soundItem = (ConfigListScreen.SoundConfigItem)config;
                    config = soundItem.getConfig();
                    tooltip.add((Component)Component.literal((String)("\u00a76\u00a7lSound: \u00a7f" + soundItem.getId())));
                    tooltip.add((Component)Component.literal((String)""));
                    tooltip.add((Component)Component.translatable((String)"tooltip.ezvcsurvival.configuration"));
                    tooltip.add((Component)Component.translatable((String)"tooltip.ezvcsurvival.enabled", (Object[])new Object[]{((GeneralSoundsConfig.SoundEntry)config).enabled ? Component.translatable((String)"gui.ezvcsurvival.enabled") : Component.translatable((String)"gui.ezvcsurvival.disabled")}));
                    tooltip.add((Component)Component.translatable((String)"tooltip.ezvcsurvival.speed_multiplier", (Object[])new Object[]{Component.literal((String)("\u00a7e" + ((GeneralSoundsConfig.SoundEntry)config).speed_multiplier))}));
                    tooltip.add((Component)Component.translatable((String)"tooltip.ezvcsurvival.range_multiplier", (Object[])new Object[]{Component.literal((String)("\u00a7e" + ((GeneralSoundsConfig.SoundEntry)config).range_multiplier))}));
                } else {
                    config = this.item;
                    if (config instanceof ConfigListScreen.EntityReactionItem) {
                        ConfigListScreen.EntityReactionItem entityItem = (ConfigListScreen.EntityReactionItem)config;
                        GeneralSoundsConfig.Reaction reaction = entityItem.getReaction();
                        String entityName = this.getEntityDisplayName(entityItem.getId());
                        tooltip.add((Component)Component.literal((String)("\u00a76\u00a7l" + entityName)));
                        tooltip.add((Component)Component.literal((String)("\u00a77ID: \u00a7f" + entityItem.getId())));
                        tooltip.add((Component)Component.literal((String)""));
                        tooltip.add((Component)Component.translatable((String)"tooltip.ezvcsurvival.sound_reaction"));
                        tooltip.add((Component)Component.translatable((String)"tooltip.ezvcsurvival.enabled", (Object[])new Object[]{reaction.enabled ? Component.translatable((String)"gui.ezvcsurvival.enabled") : Component.translatable((String)"gui.ezvcsurvival.disabled")}));
                        tooltip.add((Component)Component.translatable((String)"tooltip.ezvcsurvival.speed", (Object[])new Object[]{Component.literal((String)("\u00a7e" + reaction.speed))}));
                        tooltip.add((Component)Component.translatable((String)"tooltip.ezvcsurvival.range", (Object[])new Object[]{Component.literal((String)("\u00a7e" + reaction.range))}));
                    }
                }
            }
            return tooltip;
        }

        private void openEditScreen() {
            ConfigEditScreen.EditType editType = null;
            String elementName = "";
            if (this.item instanceof ConfigListScreen.EntityConfigItem) {
                editType = ConfigEditScreen.EditType.ENTITY_CONFIG;
                elementName = ((ConfigListScreen.EntityConfigItem)this.item).getDisplayName();
            } else if (this.item instanceof ConfigListScreen.SoundConfigItem) {
                editType = ConfigEditScreen.EditType.GENERAL_SOUND_CONFIG;
                elementName = ((ConfigListScreen.SoundConfigItem)this.item).getId();
            } else if (this.item instanceof ConfigListScreen.EntityReactionItem) {
                editType = ConfigEditScreen.EditType.GENERAL_SOUND_ENTITY;
                elementName = this.getEntityDisplayName(((ConfigListScreen.EntityReactionItem)this.item).getId());
            }
            if (editType != null) {
                String elementId = this.getElementId();
                Minecraft.getInstance().setScreen((Screen)new ConfigEditScreen(ConfigListWidget.this.parent, editType, elementId, elementName));
            }
        }

        private String getElementId() {
            if (this.item instanceof ConfigListScreen.EntityConfigItem) {
                return ((ConfigListScreen.EntityConfigItem)this.item).getId();
            }
            if (this.item instanceof ConfigListScreen.SoundConfigItem) {
                return ((ConfigListScreen.SoundConfigItem)this.item).getId();
            }
            if (this.item instanceof ConfigListScreen.EntityReactionItem) {
                return ((ConfigListScreen.EntityReactionItem)this.item).getId();
            }
            return "";
        }

        @NotNull
        public Component getNarration() {
            Object object = this.item;
            if (object instanceof ConfigListScreen.EntityConfigItem) {
                ConfigListScreen.EntityConfigItem entityItem = (ConfigListScreen.EntityConfigItem)object;
                return Component.literal((String)entityItem.getDisplayName());
            }
            object = this.item;
            if (object instanceof ConfigListScreen.SoundConfigItem) {
                ConfigListScreen.SoundConfigItem soundItem = (ConfigListScreen.SoundConfigItem)object;
                return Component.literal((String)("Sound: " + soundItem.getId()));
            }
            object = this.item;
            if (object instanceof ConfigListScreen.EntityReactionItem) {
                ConfigListScreen.EntityReactionItem entityItem = (ConfigListScreen.EntityReactionItem)object;
                return Component.literal((String)this.getEntityDisplayName(entityItem.getId()));
            }
            return Component.literal((String)"Unknown Item");
        }
    }

    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry> {
    }
}

