/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.commands;

import com.armilp.ezvcsurvival.config.EntityVoiceConfig;
import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.config.SoundConfig;
import com.armilp.ezvcsurvival.config.VoiceConfig;
import com.armilp.ezvcsurvival.events.MobGoalInjector;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.lang.reflect.Method;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber
public class ReloadConfigCommand {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ezvcsurvival").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"reloadconfig").executes(ReloadConfigCommand::executeReload)));
    }

    private static int executeReload(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            source.sendSuccess(() -> Component.literal((String)"[EZVCSurvival] Reloading configuration files..."), false);
                            try {
                                ReloadConfigCommand.reloadEntityVoiceConfig();
                            }
                            catch (Exception e) {
                                source.sendFailure((Component)Component.literal((String)("[EZVCSurvival] Failed to reload EntityVoiceConfig: " + e.getMessage())));
                                if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block11;
                                e.printStackTrace();
                            }
                        }
                        try {
                            ReloadConfigCommand.reloadGeneralSoundsConfig();
                        }
                        catch (Exception e) {
                            source.sendFailure((Component)Component.literal((String)("[EZVCSurvival] Failed to reload GeneralSoundConfig: " + e.getMessage())));
                            if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block12;
                            e.printStackTrace();
                        }
                    }
                    try {
                        SoundConfig.loadConfigs();
                    }
                    catch (Exception e) {
                        source.sendFailure((Component)Component.literal((String)("[EZVCSurvival] Failed to reload SoundConfig: " + e.getMessage())));
                        if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block13;
                        e.printStackTrace();
                    }
                }
                try {
                    MobGoalInjector.refreshAll();
                }
                catch (Exception e) {
                    source.sendFailure((Component)Component.literal((String)("[EZVCSurvival] Failed to refresh mob goals: " + e.getMessage())));
                    if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block14;
                    e.printStackTrace();
                }
            }
            source.sendSuccess(() -> Component.literal((String)"[EZVCSurvival] All configurations reloaded successfully!"), false);
            return 1;
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)("[EZVCSurvival] \u00a7cAn unexpected error occurred: " + e.getMessage())));
            if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    private static void reloadEntityVoiceConfig() throws Exception {
        Method loadOrCreateMethod = EntityVoiceConfig.class.getDeclaredMethod("loadOrCreate", new Class[0]);
        loadOrCreateMethod.setAccessible(true);
        loadOrCreateMethod.invoke(null, new Object[0]);
    }

    private static void reloadGeneralSoundsConfig() throws Exception {
        Method loadOrCreateMethod = GeneralSoundsConfig.class.getDeclaredMethod("loadOrCreate", new Class[0]);
        loadOrCreateMethod.setAccessible(true);
        loadOrCreateMethod.invoke(null, new Object[0]);
    }
}

