/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.config;

import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class VoiceConfig {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec CONFIG;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> ARMOR_EFFECTS;
    public static final ModConfigSpec.DoubleValue WHISPER_RANGE_MULTIPLIER;
    public static final ModConfigSpec.DoubleValue WHISPER_SPEED_MULTIPLIER;
    public static final ModConfigSpec.DoubleValue THUNDER_RANGE_MULTIPLIER;
    public static final ModConfigSpec.DoubleValue SNEAKING_RANGE_MULTIPLIER;
    public static final ModConfigSpec.BooleanValue MOB_SPEED_BOOST_ENABLED;
    public static final ModConfigSpec.BooleanValue DEBUG;

    static {
        BUILDER.comment(new String[]{"Whisper Config", "Multipliers that affect the detection range and movement speed when the player is whispering."}).push("whisper_configs");
        WHISPER_RANGE_MULTIPLIER = BUILDER.defineInRange("whisper_range_multiplier", 0.5, 0.0, 1.0);
        WHISPER_SPEED_MULTIPLIER = BUILDER.defineInRange("whisper_speed_multiplier", 0.8, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.comment(new String[]{"Mob Speed Boost Config", "Enable or disable the mob speed boost when targeting speaking players"}).push("mob_speed_boost");
        MOB_SPEED_BOOST_ENABLED = BUILDER.define("mob_speed_boost_enabled", true);
        BUILDER.pop();
        BUILDER.comment(new String[]{"Misc Config", "Multipliers that affect the detection range of voices in specific situations."}).push("misc_config");
        THUNDER_RANGE_MULTIPLIER = BUILDER.defineInRange("thunder_range_multiplier", 0.65, 0.0, 1.0);
        SNEAKING_RANGE_MULTIPLIER = BUILDER.defineInRange("sneaking_range_multiplier", 0.5, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.comment(new String[]{"Armor Effects Config", "Define multipliers for mob detection range and speed when a player wears specific armor items.", "Format: item_id=speedMultiplier,rangeMultiplier", "Example: minecraft:diamond_helmet=0.5,0.5"});
        BUILDER.push("armor_effects");
        ARMOR_EFFECTS = BUILDER.defineList("effects", () -> List.of("minecraft:diamond_helmet=0.9,0.6", "minecraft:diamond_chestplate=1.0,0.7"), obj -> obj instanceof String && ((String)obj).contains("="));
        BUILDER.pop();
        BUILDER.comment("Debugging Config").push("debugging");
        DEBUG = BUILDER.define("debug", false);
        BUILDER.pop();
        CONFIG = BUILDER.build();
    }
}

