/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.events;

import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.network.GeneralSoundPacket;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.sound.PlaySoundEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="ezvcsurvival", value={Dist.CLIENT})
public class SoundEventHandler {
    @SubscribeEvent
    public static void onPlaySound(PlaySoundEvent event) {
        SoundInstance soundInstance = event.getSound();
        if (!(soundInstance instanceof SimpleSoundInstance)) {
            return;
        }
        SimpleSoundInstance sound = (SimpleSoundInstance)soundInstance;
        Minecraft mc = Minecraft.getInstance();
        if (mc.getConnection() == null || mc.player == null) {
            return;
        }
        Map<String, GeneralSoundsConfig.SoundEntry> soundMap = GeneralSoundsConfig.getSounds();
        if (soundMap == null) {
            return;
        }
        GeneralSoundsConfig.SoundEntry cfg = soundMap.get(sound.getLocation().toString());
        if (cfg == null || !cfg.enabled) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new GeneralSoundPacket(sound.getLocation(), sound.getX(), sound.getY(), sound.getZ(), cfg.speed_multiplier, cfg.range_multiplier), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

