/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.goals;

import com.armilp.ezvcsurvival.Plugin;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;

public class FollowVoiceGoal
extends Goal {
    private final Mob mob;
    private final double speedModifier;
    private final int voiceDetectionRange;
    private Player targetPlayer;
    private final double threshold;
    private BlockPos targetSoundPosition;
    private long timePlayerInRange;
    private final long maxFollowTime;

    public FollowVoiceGoal(Mob mob, double speedModifier, int detectionRange, double threshold, long maxFollowTime) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.voiceDetectionRange = detectionRange;
        this.threshold = threshold;
        this.maxFollowTime = maxFollowTime;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public boolean canUse() {
        if (this.mob.getTarget() != null) {
            return false;
        }
        this.targetPlayer = this.getNearestPlayerInRange();
        this.targetSoundPosition = Plugin.getLastSoundLocation(this.mob.blockPosition(), this.voiceDetectionRange, this.threshold);
        return this.targetPlayer != null || this.targetSoundPosition != null;
    }

    public void start() {
        if (this.targetPlayer != null) {
            this.timePlayerInRange = System.currentTimeMillis();
        } else if (this.targetSoundPosition != null) {
            this.moveToSoundPosition();
        }
    }

    public boolean canContinueToUse() {
        if (this.mob.getTarget() != null) {
            return false;
        }
        return this.targetPlayer != null || this.targetSoundPosition != null && !this.mob.getNavigation().isDone();
    }

    public void tick() {
        if (this.targetPlayer != null) {
            this.targetSoundPosition = null;
            this.handlePlayerInteraction();
        } else if (this.targetSoundPosition != null) {
            this.handleSoundInteraction();
        }
    }

    public void stop() {
        this.targetSoundPosition = null;
        this.targetPlayer = null;
        this.mob.getNavigation().stop();
    }

    private void handlePlayerInteraction() {
        if (this.targetPlayer.isCreative() || this.targetPlayer.isSpectator()) {
            this.targetPlayer = null;
            this.mob.getNavigation().stop();
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.timePlayerInRange > this.maxFollowTime) {
            this.targetPlayer = null;
            this.mob.getNavigation().stop();
            return;
        }
        this.mob.getNavigation().setSpeedModifier(this.speedModifier);
        if (this.mob.getTarget() == null) {
            this.mob.setTarget((LivingEntity)this.targetPlayer);
        }
    }

    private void handleSoundInteraction() {
        double arrivalThresholdSq;
        double dz;
        BlockPos groundedPos = this.mob.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.targetSoundPosition);
        double dx = this.mob.getX() - ((double)groundedPos.getX() + 0.5);
        double distanceSq = dx * dx + (dz = this.mob.getZ() - ((double)groundedPos.getZ() + 0.5)) * dz;
        if (distanceSq <= (arrivalThresholdSq = this.threshold * this.threshold)) {
            this.targetSoundPosition = Plugin.getLastSoundLocation(this.mob.blockPosition(), this.voiceDetectionRange, this.threshold);
            if (this.targetSoundPosition != null) {
                this.moveToSoundPosition();
            } else {
                this.mob.getNavigation().stop();
            }
            return;
        }
        if (distanceSq > (double)(this.voiceDetectionRange * this.voiceDetectionRange) / 2.0) {
            BlockPos newSoundPosition = Plugin.getLastSoundLocation(this.mob.blockPosition(), this.voiceDetectionRange, this.threshold);
            if (newSoundPosition == null) {
                this.targetSoundPosition = null;
                this.mob.getNavigation().stop();
                return;
            }
            this.targetSoundPosition = newSoundPosition;
            this.moveToSoundPosition();
        }
        this.mob.getNavigation().setSpeedModifier(this.speedModifier);
    }

    private Player getNearestPlayerInRange() {
        return this.mob.level().getNearestPlayer((Entity)this.mob, 5.0);
    }

    private void moveToSoundPosition() {
        if (this.targetSoundPosition != null) {
            BlockPos ground = this.mob.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.targetSoundPosition);
            this.mob.getNavigation().moveTo((double)ground.getX() + 0.5, (double)ground.getY(), (double)ground.getZ() + 0.5, this.speedModifier);
        }
    }
}

