/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.network;

import com.armilp.ezvcsurvival.events.SoundEventTracker;
import com.armilp.ezvcsurvival.network.EZVCNetwork;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record GeneralSoundPacket(ResourceLocation sound, double x, double y, double z, double speedMultiplier, double rangeMultiplier) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GeneralSoundPacket> TYPE = new CustomPacketPayload.Type(EZVCNetwork.id("general_sound"));
    public static final StreamCodec<ByteBuf, GeneralSoundPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, GeneralSoundPacket::sound, (StreamCodec)ByteBufCodecs.DOUBLE, GeneralSoundPacket::x, (StreamCodec)ByteBufCodecs.DOUBLE, GeneralSoundPacket::y, (StreamCodec)ByteBufCodecs.DOUBLE, GeneralSoundPacket::z, (StreamCodec)ByteBufCodecs.DOUBLE, GeneralSoundPacket::speedMultiplier, (StreamCodec)ByteBufCodecs.DOUBLE, GeneralSoundPacket::rangeMultiplier, GeneralSoundPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(GeneralSoundPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> SoundEventTracker.setLastPlayedPosition(packet.sound, packet.x, packet.y, packet.z, packet.speedMultiplier, packet.rangeMultiplier));
    }
}

