/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival;

import com.armilp.ezvcsurvival.commands.AggroVoiceEffectCommand;
import com.armilp.ezvcsurvival.commands.SoundEffectCommand;
import com.armilp.ezvcsurvival.config.EntityVoiceConfig;
import com.armilp.ezvcsurvival.config.VoiceConfig;
import com.armilp.ezvcsurvival.data.SoundData;
import com.armilp.ezvcsurvival.events.ArmorEventHandler;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.common.Mod;

@ForgeVoicechatPlugin
@Mod.EventBusSubscriber(modid="ezvcsurvival")
public class Plugin
implements VoicechatPlugin {
    private boolean DEBUG;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final Map<UUID, SoundData> playerSoundLocations = new ConcurrentHashMap<UUID, SoundData>();
    private static final Map<UUID, Long> lastVoiceEffectTime = new ConcurrentHashMap<UUID, Long>();
    private static final long DEATH_ANGELS_EFFECT_COOLDOWN_MS = 3000L;
    private static VoicechatApi voicechatApi;
    @Nullable
    private OpusDecoder decoder;

    public String getPluginId() {
        return "ezvcsurvival";
    }

    public void initialize(VoicechatApi api) {
        voicechatApi = api;
        this.DEBUG = (Boolean)VoiceConfig.DEBUG.get();
        if (this.DEBUG) {
            System.out.println("[DEBUG] VoiceChat Plugin initialized");
        }
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(MicrophonePacketEvent.class, this::onMicrophonePacket);
        if (this.DEBUG) {
            System.out.println("[DEBUG] Registered MicrophonePacketEvent");
        }
    }

    public static double getMaxAudioLevel(short[] samples) {
        double rms = 0.0;
        for (int i = 0; i < samples.length; ++i) {
            double sample = (double)samples[i] / 32767.0;
            rms += sample * sample;
        }
        int sampleCount = samples.length / 2;
        rms = sampleCount == 0 ? 0.0 : Math.sqrt(rms / (double)sampleCount);
        double db = rms > 0.0 ? Math.min(Math.max(20.0 * Math.log10(rms), -127.0), 0.0) : -127.0;
        return db;
    }

    @Nullable
    public static BlockPos getLastSoundLocation(BlockPos mobPosition, double range, double minDb) {
        return playerSoundLocations.values().stream().filter(data -> data.audioLevelDb() >= minDb).filter(data -> mobPosition.m_123331_((Vec3i)data.position()) <= range * range).min(Comparator.comparingDouble(data -> mobPosition.m_123331_((Vec3i)data.position()))).map(SoundData::position).orElse(null);
    }

    public void onMicrophonePacket(MicrophonePacketEvent event) {
        short[] decoded;
        ServerPlayer player;
        VoicechatConnection sender = event.getSenderConnection();
        if (sender == null || sender.getPlayer() == null) {
            return;
        }
        Object object = sender.getPlayer().getPlayer();
        if (object instanceof ServerPlayer && ((player = (ServerPlayer)object).m_7500_() || player.m_5833_())) {
            return;
        }
        OpusDecoder localDecoder = this.decoder;
        if (localDecoder == null || localDecoder.isClosed()) {
            this.decoder = localDecoder = voicechatApi.createDecoder();
        }
        if (localDecoder == null) {
            return;
        }
        localDecoder.resetState();
        byte[] opusEncodedData = ((MicrophonePacket)event.getPacket()).getOpusEncodedData();
        try {
            decoded = localDecoder.decode(opusEncodedData);
        }
        catch (Exception e) {
            return;
        }
        double audioLevel = Plugin.getMaxAudioLevel(decoded);
        UUID playerUUID = sender.getPlayer().getUuid();
        Position voicechatPosition = sender.getPlayer().getPosition();
        Vec3 senderVec = new Vec3(voicechatPosition.getX(), voicechatPosition.getY(), voicechatPosition.getZ());
        BlockPos playerPosition = new BlockPos((int)Math.floor(senderVec.f_82479_), (int)Math.floor(senderVec.f_82480_), (int)Math.floor(senderVec.f_82481_));
        boolean isWhispering = ((MicrophonePacket)event.getPacket()).isWhispering();
        double whisperRangeMultiplier = (Double)VoiceConfig.WHISPER_RANGE_MULTIPLIER.get();
        double whisperSpeedMultiplier = (Double)VoiceConfig.WHISPER_SPEED_MULTIPLIER.get();
        double thunderRangeMultiplier = (Double)VoiceConfig.THUNDER_RANGE_MULTIPLIER.get();
        double sneakingRangeMultiplier = (Double)VoiceConfig.SNEAKING_RANGE_MULTIPLIER.get();
        ArrayList<String> allIds = new ArrayList<String>(EntityVoiceConfig.getAllEntityIds());
        long currentTime = System.currentTimeMillis();
        for (String id : allIds) {
            Object object2;
            EntityVoiceConfig.EntityConfig cfg = EntityVoiceConfig.getMonster(id);
            if (cfg == null) {
                cfg = EntityVoiceConfig.getAnimal(id);
            }
            if (cfg == null || !cfg.enabled) continue;
            double threshold = cfg.threshold;
            double detectionRange = cfg.range;
            double speed = cfg.speed;
            if (isWhispering) {
                detectionRange *= whisperRangeMultiplier;
                speed *= whisperSpeedMultiplier;
            }
            if ((object2 = sender.getPlayer().getPlayer()) instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)object2;
                if (p.m_6047_()) {
                    detectionRange *= sneakingRangeMultiplier;
                }
                if (p.m_9236_().m_46471_() || p.m_9236_().m_46470_()) {
                    detectionRange *= thunderRangeMultiplier;
                }
                double[] armorMult = ArmorEventHandler.getArmorMultipliers((Player)p);
                detectionRange *= armorMult[1];
                speed *= armorMult[0];
            }
            double modifiedRange = detectionRange;
            double distance = senderVec.m_82554_(new Vec3((double)playerPosition.m_123341_(), (double)playerPosition.m_123342_(), (double)playerPosition.m_123343_()));
            double distanceVolume = 1.0 - Math.min(distance, modifiedRange) / modifiedRange;
            if (audioLevel >= threshold && distanceVolume > 0.0) {
                ServerPlayer serverPlayer;
                Object object3;
                BlockPos precisePos = new BlockPos((int)Math.floor(senderVec.f_82479_), (int)Math.floor(senderVec.f_82480_), (int)Math.floor(senderVec.f_82481_));
                playerSoundLocations.put(playerUUID, new SoundData(precisePos, audioLevel));
                if (this.DEBUG) {
                    System.out.println("[DEBUG] " + id + " detects sound! Threshold: " + threshold + " dB | AudioLevel: " + audioLevel + " dB | Range: " + detectionRange + " | Speed: " + speed + " | Position: " + precisePos);
                }
                if (id.equals("death_angels:death_angel") && audioLevel >= (Double)VoiceConfig.DEATH_ANGELS_THRESHOLD.get() && (!lastVoiceEffectTime.containsKey(playerUUID) || currentTime - lastVoiceEffectTime.get(playerUUID) > 3000L) && (object3 = sender.getPlayer().getPlayer()) instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)object3;
                    SoundEffectCommand.applyEffect(serverPlayer);
                    lastVoiceEffectTime.put(playerUUID, currentTime);
                    if (this.DEBUG) {
                        System.out.println("[DEBUG] Effect applied to the player " + playerUUID);
                    }
                }
                if (!id.equals("quiet_place:death_angel") || !(audioLevel >= (Double)VoiceConfig.QUIET_PLACE_OVERMAN_THRESHOLD.get()) || lastVoiceEffectTime.containsKey(playerUUID) && currentTime - lastVoiceEffectTime.get(playerUUID) <= 3000L || !((object3 = sender.getPlayer().getPlayer()) instanceof ServerPlayer)) continue;
                serverPlayer = (ServerPlayer)object3;
                AggroVoiceEffectCommand.applyEffect(serverPlayer);
                lastVoiceEffectTime.put(playerUUID, currentTime);
                if (!this.DEBUG) continue;
                System.out.println("[DEBUG] Effect applied to the player " + playerUUID);
                continue;
            }
            if (!this.DEBUG) continue;
            System.out.println("[DEBUG] Intensity/range too low for " + id + ": " + audioLevel + " dB | " + distanceVolume);
        }
        scheduler.schedule(() -> playerSoundLocations.remove(playerUUID), 5L, TimeUnit.SECONDS);
    }
}

