/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.client.gui.edit;

import com.armilp.ezvcsurvival.client.gui.edit.SoundFilterEditScreen;
import com.armilp.ezvcsurvival.client.gui.list.ConfigListScreen;
import com.armilp.ezvcsurvival.config.EntityVoiceConfig;
import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.config.GunfireConfig;
import com.armilp.ezvcsurvival.config.SoundConfig;
import com.armilp.ezvcsurvival.network.EZVCNetwork;
import com.armilp.ezvcsurvival.network.UpdateConfigPacket;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ConfigEditScreen
extends Screen {
    private final Screen parent;
    private final EditType editType;
    private final String elementId;
    private final String elementName;
    private Button enabledButton;
    private EditBox speedBox;
    private EditBox rangeBox;
    private EditBox thresholdBox;
    private Button priorityButton;
    private Button saveButton;
    private Button soundFiltersButton;
    private boolean enabled;
    private double speed;
    private double range;
    private double threshold;
    private boolean isPriority;
    private boolean originalEnabled;
    private double originalSpeed;
    private double originalRange;
    private double originalThreshold;
    private boolean originalIsPriority;
    private static final int TOP_MARGIN = 30;
    private static final int CENTER_X_OFFSET = 80;
    private static final int FIELD_WIDTH = 160;
    private static final int FIELD_HEIGHT = 20;
    private static final int FIELD_SPACING = 30;
    private static final int BUTTON_WIDTH = 80;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_SPACING = 10;

    public ConfigEditScreen(Screen parent, EditType editType, String elementId, String elementName) {
        super((Component)Component.m_237110_((String)ConfigEditScreen.getTitleKey(editType), (Object[])new Object[]{elementName}));
        this.parent = parent;
        this.editType = editType;
        this.elementId = elementId;
        this.elementName = elementName;
        this.loadCurrentValues();
    }

    private static String getTitleKey(EditType editType) {
        switch (editType) {
            case ENTITY_CONFIG: {
                return "screen.ezvcsurvival.entity_config_edit";
            }
            case GENERAL_SOUND_CONFIG: {
                return "screen.ezvcsurvival.general_sound_config_edit";
            }
            case GENERAL_SOUND_ENTITY: {
                return "screen.ezvcsurvival.general_sound_entity_edit";
            }
            case GUNFIRE_ENTITY: {
                return "screen.ezvcsurvival.gunfire_entity_edit";
            }
        }
        return "screen.ezvcsurvival.config_edit";
    }

    private void loadCurrentValues() {
        switch (this.editType) {
            case ENTITY_CONFIG: {
                EntityVoiceConfig.EntityConfig entityConfig = EntityVoiceConfig.get(this.elementId);
                if (entityConfig != null) {
                    this.enabled = entityConfig.enabled;
                    this.speed = entityConfig.speed;
                    this.range = entityConfig.range;
                    this.threshold = entityConfig.threshold;
                    this.originalEnabled = entityConfig.enabled;
                    this.originalSpeed = entityConfig.speed;
                    this.originalRange = entityConfig.range;
                    this.originalThreshold = entityConfig.threshold;
                    break;
                }
                this.enabled = true;
                this.speed = 1.0;
                this.range = 50.0;
                this.threshold = 0.0;
                this.originalEnabled = this.enabled;
                this.originalSpeed = this.speed;
                this.originalRange = this.range;
                this.originalThreshold = this.threshold;
                break;
            }
            case GENERAL_SOUND_CONFIG: {
                GeneralSoundsConfig.SoundEntry soundConfig = GeneralSoundsConfig.getSounds().get(this.elementId);
                if (soundConfig != null) {
                    this.enabled = soundConfig.enabled;
                    this.speed = soundConfig.speed_multiplier;
                    this.range = soundConfig.range_multiplier;
                    this.isPriority = soundConfig.is_priority;
                    this.originalEnabled = soundConfig.enabled;
                    this.originalSpeed = soundConfig.speed_multiplier;
                    this.originalRange = soundConfig.range_multiplier;
                    this.originalIsPriority = soundConfig.is_priority;
                    break;
                }
                this.enabled = false;
                this.speed = 1.0;
                this.range = 1.0;
                this.isPriority = false;
                this.originalEnabled = this.enabled;
                this.originalSpeed = this.speed;
                this.originalRange = this.range;
                this.originalIsPriority = this.isPriority;
                break;
            }
            case GENERAL_SOUND_ENTITY: {
                GeneralSoundsConfig.Reaction generalReaction;
                Map<String, GeneralSoundsConfig.Reaction> reactions = GeneralSoundsConfig.getMobReactions();
                GeneralSoundsConfig.Reaction reaction = generalReaction = reactions != null ? reactions.get(this.elementId) : null;
                if (generalReaction != null) {
                    this.enabled = generalReaction.enabled;
                    this.speed = generalReaction.speed;
                    this.range = generalReaction.range;
                    this.originalEnabled = generalReaction.enabled;
                    this.originalSpeed = generalReaction.speed;
                    this.originalRange = generalReaction.range;
                    break;
                }
                this.enabled = true;
                this.speed = 1.0;
                this.range = 50.0;
                this.originalEnabled = this.enabled;
                this.originalSpeed = this.speed;
                this.originalRange = this.range;
                break;
            }
            case GUNFIRE_ENTITY: {
                GunfireConfig.Reaction gunfireReaction = GunfireConfig.getMobReactions().get(this.elementId);
                if (gunfireReaction != null) {
                    this.enabled = gunfireReaction.enabled;
                    this.speed = gunfireReaction.speed;
                    this.range = gunfireReaction.range;
                    this.originalEnabled = gunfireReaction.enabled;
                    this.originalSpeed = gunfireReaction.speed;
                    this.originalRange = gunfireReaction.range;
                    break;
                }
                this.enabled = true;
                this.speed = 1.0;
                this.range = 40.0;
                this.originalEnabled = this.enabled;
                this.originalSpeed = this.speed;
                this.originalRange = this.range;
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int startY = 70;
        this.m_169413_();
        this.initFields(centerX, startY);
        this.initActionButtons(centerX, startY);
        this.updateSaveButtonState();
    }

    private void initFields(int centerX, int startY) {
        int currentY = startY;
        this.enabledButton = Button.m_253074_((Component)Component.m_237115_((String)(this.enabled ? "button.ezvcsurvival.enabled" : "button.ezvcsurvival.disabled")), b -> this.toggleEnabled()).m_252987_(centerX - 80, currentY, 160, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.enabledButton);
        this.speedBox = new EditBox(this.f_96547_, centerX - 80, currentY += 50, 160, 20, (Component)Component.m_237113_((String)""));
        this.speedBox.m_94144_(String.valueOf(this.speed));
        this.speedBox.m_94199_(20);
        this.speedBox.m_94151_(s -> {
            try {
                this.speed = Double.parseDouble(s);
                this.updateSaveButtonState();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.m_142416_((GuiEventListener)this.speedBox);
        this.rangeBox = new EditBox(this.f_96547_, centerX - 80, currentY += 50, 160, 20, (Component)Component.m_237113_((String)""));
        this.rangeBox.m_94144_(String.valueOf(this.range));
        this.rangeBox.m_94199_(20);
        this.rangeBox.m_94151_(s -> {
            try {
                this.range = Double.parseDouble(s);
                this.updateSaveButtonState();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.m_142416_((GuiEventListener)this.rangeBox);
        currentY += 50;
        if (this.editType == EditType.ENTITY_CONFIG) {
            this.thresholdBox = new EditBox(this.f_96547_, centerX - 80, currentY, 160, 20, (Component)Component.m_237113_((String)""));
            this.thresholdBox.m_94144_(String.valueOf(this.threshold));
            this.thresholdBox.m_94199_(20);
            this.thresholdBox.m_94151_(s -> {
                try {
                    this.threshold = Double.parseDouble(s);
                    this.updateSaveButtonState();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            this.m_142416_((GuiEventListener)this.thresholdBox);
            currentY += 50;
        }
        if (this.editType == EditType.GENERAL_SOUND_CONFIG) {
            this.priorityButton = Button.m_253074_((Component)Component.m_237115_((String)(this.isPriority ? "button.ezvcsurvival.priority_on" : "button.ezvcsurvival.priority_off")), b -> this.togglePriority()).m_252987_(centerX - 80, currentY, 160, 20).m_253136_();
            this.m_142416_((GuiEventListener)this.priorityButton);
            currentY += 50;
        }
        if (this.editType == EditType.GENERAL_SOUND_ENTITY) {
            this.soundFiltersButton = Button.m_253074_((Component)Component.m_237113_((String)"Sound Filters..."), b -> Minecraft.m_91087_().m_91152_((Screen)new SoundFilterEditScreen(this, this.elementId, this.elementName))).m_252987_(centerX - 80, currentY, 160, 20).m_253136_();
            this.m_142416_((GuiEventListener)this.soundFiltersButton);
            currentY += 50;
        }
    }

    private void initActionButtons(int centerX, int startY) {
        int fieldCount = this.getFieldCount();
        int buttonY = startY + fieldCount * 30 + 30;
        this.saveButton = Button.m_253074_((Component)Component.m_237115_((String)"button.ezvcsurvival.save"), b -> this.saveConfig()).m_252987_(centerX - 80 - 80 - 10, buttonY, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.saveButton);
        Button cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"button.ezvcsurvival.cancel"), b -> Minecraft.m_91087_().m_91152_(this.parent)).m_252987_(centerX + 80, buttonY, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)cancelButton);
        Button resetButton = Button.m_253074_((Component)Component.m_237115_((String)"button.ezvcsurvival.reset"), b -> this.resetToDefaults()).m_252987_(centerX - 40, buttonY + 10 + 20, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)resetButton);
    }

    private int getFieldCount() {
        switch (this.editType) {
            case ENTITY_CONFIG: {
                return 4;
            }
            case GENERAL_SOUND_CONFIG: {
                return 4;
            }
            case GENERAL_SOUND_ENTITY: {
                return 4;
            }
            case GUNFIRE_ENTITY: {
                return 3;
            }
        }
        return 3;
    }

    private void toggleEnabled() {
        this.enabled = !this.enabled;
        this.enabledButton.m_93666_((Component)Component.m_237115_((String)(this.enabled ? "button.ezvcsurvival.enabled" : "button.ezvcsurvival.disabled")));
        this.updateSaveButtonState();
    }

    private void togglePriority() {
        this.isPriority = !this.isPriority;
        this.priorityButton.m_93666_((Component)Component.m_237115_((String)(this.isPriority ? "button.ezvcsurvival.priority_on" : "button.ezvcsurvival.priority_off")));
        this.updateSaveButtonState();
    }

    private void saveConfig() {
        block18: {
            try {
                try {
                    this.speed = Double.parseDouble(this.speedBox.m_94155_());
                    this.range = Double.parseDouble(this.rangeBox.m_94155_());
                    if (this.thresholdBox != null) {
                        this.threshold = Double.parseDouble(this.thresholdBox.m_94155_());
                    }
                }
                catch (NumberFormatException e) {
                    this.showError();
                    return;
                }
                if (this.editType == EditType.ENTITY_CONFIG && this.thresholdBox != null) {
                    if (this.threshold < -100.0) {
                        this.threshold = -100.0;
                    }
                    if (this.threshold > 100.0) {
                        this.threshold = 100.0;
                    }
                }
                boolean localSuccess = false;
                switch (this.editType) {
                    case ENTITY_CONFIG: {
                        EntityVoiceConfig.set(this.elementId, new EntityVoiceConfig.EntityConfig(this.enabled, this.speed, this.range, this.threshold));
                        EntityVoiceConfig.persist();
                        localSuccess = true;
                        break;
                    }
                    case GENERAL_SOUND_CONFIG: {
                        GeneralSoundsConfig.setSoundEntry(this.elementId, this.enabled, this.speed, this.range, this.isPriority);
                        GeneralSoundsConfig.persist();
                        GeneralSoundsConfig.SoundEntry updated = GeneralSoundsConfig.getSounds().get(this.elementId);
                        localSuccess = updated != null && updated.enabled == this.enabled && Math.abs(updated.speed_multiplier - this.speed) < 0.001 && Math.abs(updated.range_multiplier - this.range) < 0.001 && updated.is_priority == this.isPriority;
                        break;
                    }
                    case GENERAL_SOUND_ENTITY: {
                        GeneralSoundsConfig.setMobReaction(this.elementId, this.enabled, this.speed, this.range);
                        GeneralSoundsConfig.persist();
                        localSuccess = true;
                        break;
                    }
                    case GUNFIRE_ENTITY: {
                        GunfireConfig.setMobReaction(this.elementId, this.enabled, this.speed, this.range);
                        GunfireConfig.persist();
                        localSuccess = true;
                    }
                }
                if (localSuccess) {
                    try {
                        SoundConfig.loadConfigs();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.sendUpdate();
                    this.updateOriginalValues();
                    if (this.parent instanceof ConfigListScreen) {
                        ((ConfigListScreen)this.parent).onConfigUpdated();
                    }
                    Minecraft.m_91087_().m_91152_(this.parent);
                    break block18;
                }
                this.showError();
            }
            catch (Exception e) {
                this.showError();
            }
        }
    }

    private void resetToDefaults() {
        switch (this.editType) {
            case ENTITY_CONFIG: {
                EntityVoiceConfig.EntityConfig defaultConfig = EntityVoiceConfig.EntityConfig.defaultFor(null);
                this.enabled = defaultConfig.enabled;
                this.speed = defaultConfig.speed;
                this.range = defaultConfig.range;
                this.threshold = defaultConfig.threshold;
                if (this.thresholdBox == null) break;
                this.thresholdBox.m_94144_(String.valueOf(this.threshold));
                break;
            }
            case GENERAL_SOUND_CONFIG: {
                this.enabled = false;
                this.speed = 1.0;
                this.range = 1.0;
                this.isPriority = false;
                if (this.priorityButton == null) break;
                this.priorityButton.m_93666_((Component)Component.m_237115_((String)(this.isPriority ? "button.ezvcsurvival.priority_on" : "button.ezvcsurvival.priority_off")));
                break;
            }
            case GENERAL_SOUND_ENTITY: {
                this.enabled = true;
                this.speed = 1.0;
                this.range = 50.0;
                break;
            }
            case GUNFIRE_ENTITY: {
                this.enabled = true;
                this.speed = 1.0;
                this.range = 40.0;
            }
        }
        if (this.enabledButton != null) {
            this.enabledButton.m_93666_((Component)Component.m_237115_((String)(this.enabled ? "button.ezvcsurvival.enabled" : "button.ezvcsurvival.disabled")));
        }
        if (this.speedBox != null) {
            this.speedBox.m_94144_(String.valueOf(this.speed));
        }
        if (this.rangeBox != null) {
            this.rangeBox.m_94144_(String.valueOf(this.range));
        }
        this.updateSaveButtonState();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        int titleY = 30;
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2 + 1, titleY + 1, -2013265920);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, titleY, 0xFFFFFF);
        String elementInfo = "ID: " + this.elementId;
        int elementInfoY = titleY + 18;
        graphics.m_280137_(this.f_96547_, elementInfo, this.f_96543_ / 2, elementInfoY, 0xAAAAAA);
        int lineY = elementInfoY + 10;
        int lineWidth = Math.min(180, this.f_96543_ - 100);
        graphics.m_280509_(this.f_96543_ / 2 - lineWidth / 2, lineY, this.f_96543_ / 2 + lineWidth / 2, lineY + 1, 0x44FFFFFF);
        this.renderFieldLabels(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void renderFieldLabels(GuiGraphics graphics) {
        int startY;
        int centerX = this.f_96543_ / 2;
        int currentY = startY = 70;
        graphics.m_280488_(this.f_96547_, "Enabled", centerX - 80, currentY - 15, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Speed", centerX - 80, (currentY += 50) - 15, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Range", centerX - 80, (currentY += 50) - 15, 0xFFFFFF);
        currentY += 50;
        if (this.editType == EditType.ENTITY_CONFIG) {
            graphics.m_280488_(this.f_96547_, "Threshold", centerX - 80, currentY - 15, 0xFFFFFF);
            currentY += 50;
        }
        if (this.editType == EditType.GENERAL_SOUND_CONFIG) {
            graphics.m_280488_(this.f_96547_, "Priority Sound", centerX - 80, currentY - 15, 0xFFFFFF);
        }
        if (this.editType == EditType.GENERAL_SOUND_ENTITY) {
            graphics.m_280488_(this.f_96547_, "Configure Filters", centerX - 80, currentY - 15, 0xFFFFFF);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            Minecraft.m_91087_().m_91152_(this.parent);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void sendUpdate() {
        try {
            switch (this.editType) {
                case ENTITY_CONFIG: {
                    EZVCNetwork.INSTANCE.sendToServer((Object)new UpdateConfigPacket(this.elementId, this.enabled, this.speed, this.range, this.threshold));
                    break;
                }
                case GENERAL_SOUND_CONFIG: {
                    EZVCNetwork.INSTANCE.sendToServer((Object)new UpdateConfigPacket(UpdateConfigPacket.ConfigType.GENERAL_SOUND, this.elementId, this.enabled, this.speed, this.range, this.isPriority));
                    break;
                }
                case GENERAL_SOUND_ENTITY: {
                    EZVCNetwork.INSTANCE.sendToServer((Object)new UpdateConfigPacket(UpdateConfigPacket.ConfigType.GENERAL_SOUND_ENTITY, this.elementId, this.enabled, this.speed, this.range));
                    break;
                }
                case GUNFIRE_ENTITY: {
                    EZVCNetwork.INSTANCE.sendToServer((Object)new UpdateConfigPacket(UpdateConfigPacket.ConfigType.GUNFIRE_ENTITY, this.elementId, this.enabled, this.speed, this.range));
                }
            }
        }
        catch (Exception e) {
            System.err.println("[EZVCSurvival] Error sending configuration: " + e.getMessage());
        }
    }

    private boolean hasChanges() {
        switch (this.editType) {
            case ENTITY_CONFIG: {
                return this.enabled != this.originalEnabled || this.speed != this.originalSpeed || this.range != this.originalRange || this.threshold != this.originalThreshold;
            }
            case GENERAL_SOUND_CONFIG: {
                return this.enabled != this.originalEnabled || this.speed != this.originalSpeed || this.range != this.originalRange || this.isPriority != this.originalIsPriority;
            }
            case GENERAL_SOUND_ENTITY: 
            case GUNFIRE_ENTITY: {
                return this.enabled != this.originalEnabled || this.speed != this.originalSpeed || this.range != this.originalRange;
            }
        }
        return false;
    }

    private void updateSaveButtonState() {
        if (this.saveButton != null) {
            boolean hasChanges;
            this.saveButton.f_93623_ = hasChanges = this.hasChanges();
            if (hasChanges) {
                this.saveButton.m_93666_((Component)Component.m_237115_((String)"button.ezvcsurvival.save"));
            } else {
                this.saveButton.m_93666_((Component)Component.m_237115_((String)"button.ezvcsurvival.no_changes"));
            }
        }
    }

    private void updateOriginalValues() {
        switch (this.editType) {
            case ENTITY_CONFIG: {
                this.originalEnabled = this.enabled;
                this.originalSpeed = this.speed;
                this.originalRange = this.range;
                this.originalThreshold = this.threshold;
                break;
            }
            case GENERAL_SOUND_CONFIG: {
                this.originalEnabled = this.enabled;
                this.originalSpeed = this.speed;
                this.originalRange = this.range;
                this.originalIsPriority = this.isPriority;
                break;
            }
            case GENERAL_SOUND_ENTITY: 
            case GUNFIRE_ENTITY: {
                this.originalEnabled = this.enabled;
                this.originalSpeed = this.speed;
                this.originalRange = this.range;
            }
        }
    }

    private void showError() {
        System.err.println("[EZVCSurvival] Error: Values must be valid numbers.");
    }

    public static enum EditType {
        ENTITY_CONFIG,
        GENERAL_SOUND_CONFIG,
        GENERAL_SOUND_ENTITY,
        GUNFIRE_ENTITY;

    }
}

