/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.client.gui.edit;

import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class SoundFilterEditScreen
extends Screen {
    private final Screen parent;
    private final String entityId;
    private final String entityName;
    private EditBox searchBox;
    private Button saveButton;
    private Button backButton;
    private Button clearButton;
    private List<String> blockedSounds;
    private List<SuggestionEntry> suggestions;
    private int scrollOffset = 0;
    private boolean isDraggingScrollbar = false;
    private int dragStartY = 0;
    private int dragStartOffset = 0;
    private boolean showOnlyBlocked = false;
    private Button toggleFilterButton;
    private static final int MAX_VISIBLE_SUGGESTIONS = 15;
    private static final int FIELD_WIDTH = 500;
    private static final int FIELD_HEIGHT = 20;
    private static final int SUGGESTION_HEIGHT = 20;
    private static final int SCROLLBAR_WIDTH = 10;

    public SoundFilterEditScreen(Screen parent, String entityId, String entityName) {
        super((Component)Component.m_237113_((String)("Sound Filters: " + entityName)));
        this.parent = parent;
        this.entityId = entityId;
        this.entityName = entityName;
        this.loadCurrentFilters();
        this.loadSuggestions();
    }

    private void loadCurrentFilters() {
        GeneralSoundsConfig.Reaction reaction = GeneralSoundsConfig.getMobReactions().get(this.entityId);
        this.blockedSounds = reaction != null && reaction.blocked_sounds != null ? new ArrayList<String>(reaction.blocked_sounds) : new ArrayList<String>();
    }

    private void loadSuggestions() {
        this.suggestions = new ArrayList<SuggestionEntry>();
        ForgeRegistries.SOUND_EVENTS.forEach(sound -> {
            ResourceLocation key = ForgeRegistries.SOUND_EVENTS.getKey(sound);
            if (key != null) {
                String soundId = key.toString();
                String category = this.categorizeSound(soundId);
                this.suggestions.add(new SuggestionEntry(soundId, category));
            }
        });
        this.suggestions.sort((a, b) -> {
            int catCompare = a.category.compareTo(b.category);
            return catCompare != 0 ? catCompare : a.soundId.compareTo(b.soundId);
        });
    }

    private String categorizeSound(String soundId) {
        String lower = soundId.toLowerCase();
        if (lower.contains("explosion") || lower.contains("explode")) {
            return "Explosions";
        }
        if (lower.contains("gun") || lower.contains("shoot") || lower.contains("fire")) {
            return "Gunfire";
        }
        if (lower.contains("place") || lower.contains("break") || lower.contains("hit")) {
            return "Blocks";
        }
        if (lower.contains("step") || lower.contains("walk")) {
            return "Movement";
        }
        if (lower.contains("ambient") || lower.contains("idle")) {
            return "Ambient";
        }
        if (lower.contains("hurt") || lower.contains("death")) {
            return "Entity Sounds";
        }
        if (lower.contains("music")) {
            return "Music";
        }
        if (lower.contains("weather") || lower.contains("rain") || lower.contains("thunder")) {
            return "Weather";
        }
        if (soundId.startsWith("minecraft:")) {
            return "Minecraft";
        }
        if (soundId.contains(":")) {
            return soundId.split(":")[0].toUpperCase();
        }
        return "Other";
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int startY = 40;
        this.searchBox = new EditBox(this.f_96547_, centerX - 250, startY, 390, 20, (Component)Component.m_237113_((String)"Search Sounds"));
        this.searchBox.m_257771_((Component)Component.m_237113_((String)"Search sounds...").m_130938_(style -> style.m_178520_(0x888888)));
        this.searchBox.m_94151_(this::onSearchChanged);
        this.searchBox.m_94199_(100);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.toggleFilterButton = Button.m_253074_((Component)Component.m_237113_((String)"Show Blocked"), b -> this.toggleShowBlocked()).m_252987_(centerX + 250 - 100, startY, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.toggleFilterButton);
        int buttonY = this.f_96544_ - 30;
        this.clearButton = Button.m_253074_((Component)Component.m_237113_((String)"Clear All"), b -> this.clearFilters()).m_252987_(centerX - 210, buttonY, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.clearButton);
        this.saveButton = Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> this.saveFilters()).m_252987_(centerX - 100, buttonY, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.saveButton);
        this.backButton = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> Minecraft.m_91087_().m_91152_(this.parent)).m_252987_(centerX + 10, buttonY, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.backButton);
    }

    private void onSearchChanged(String query) {
        this.scrollOffset = 0;
    }

    private void toggleShowBlocked() {
        this.showOnlyBlocked = !this.showOnlyBlocked;
        this.scrollOffset = 0;
        this.toggleFilterButton.m_93666_((Component)Component.m_237113_((String)(this.showOnlyBlocked ? "Show All" : "Show Blocked")));
    }

    private void clearFilters() {
        this.blockedSounds.clear();
    }

    private void saveFilters() {
        GeneralSoundsConfig.Reaction reaction = GeneralSoundsConfig.getMobReactions().get(this.entityId);
        if (reaction != null) {
            reaction.blocked_sounds = new ArrayList<String>(this.blockedSounds);
            GeneralSoundsConfig.persist();
        }
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Search and click to block/unblock sounds:", this.f_96543_ / 2 - 250, 25, 0xFFFFFF);
        this.renderSuggestions(graphics, mouseX, mouseY);
        graphics.m_280137_(this.f_96547_, "\u00a77Blocked: " + this.blockedSounds.size() + " sounds", this.f_96543_ / 2, this.f_96544_ - 50, 0xAAAAAA);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.renderSuggestionTooltip(graphics, mouseX, mouseY);
    }

    private void renderSuggestions(GuiGraphics graphics, int mouseX, int mouseY) {
        String query = this.searchBox.m_94155_().toLowerCase().trim();
        List filtered = this.suggestions.stream().filter(s -> {
            if (this.showOnlyBlocked && !this.blockedSounds.contains(s.soundId)) {
                return false;
            }
            return query.isEmpty() || s.soundId.toLowerCase().contains(query) || s.category.toLowerCase().contains(query);
        }).collect(Collectors.toList());
        int startX = this.f_96543_ / 2 - 250;
        int startY = this.searchBox.m_252907_() + 20 + 10;
        int endY = this.f_96544_ - 70;
        int boxHeight = endY - startY;
        int contentWidth = 488;
        graphics.m_280509_(startX, startY, startX + 500, endY, -587202560);
        graphics.m_280509_(startX, startY, startX + 500, startY + 1, -11184811);
        graphics.m_280509_(startX, endY - 1, startX + 500, endY, -11184811);
        if (filtered.isEmpty()) {
            String noResults = query.isEmpty() ? "Start typing to search..." : "No sounds found";
            graphics.m_280137_(this.f_96547_, noResults, startX + contentWidth / 2, startY + boxHeight / 2 - 4, 0x888888);
        } else {
            int maxVisible = boxHeight / 20;
            int maxScroll = Math.max(0, filtered.size() - maxVisible);
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, maxScroll));
            String lastCategory = null;
            int renderY = startY;
            int visibleCount = 0;
            for (int i = this.scrollOffset; i < filtered.size() && visibleCount < maxVisible; ++visibleCount, ++i) {
                boolean isBlocked;
                boolean isHovered;
                SuggestionEntry entry = (SuggestionEntry)filtered.get(i);
                if (renderY + 20 > endY) break;
                boolean bl = isHovered = mouseX >= startX && mouseX <= startX + contentWidth && mouseY >= renderY && mouseY <= renderY + 20;
                if (i % 2 == 0) {
                    graphics.m_280509_(startX, renderY, startX + contentWidth, renderY + 20, 0x20FFFFFF);
                }
                if (isHovered) {
                    graphics.m_280509_(startX, renderY, startX + contentWidth, renderY + 20, 0x40FFFFFF);
                }
                if (!entry.category.equals(lastCategory)) {
                    graphics.m_280509_(startX, renderY, startX + 4, renderY + 20, this.getCategoryColor(entry.category));
                    lastCategory = entry.category;
                }
                String displayText = entry.soundId;
                int maxTextWidth = contentWidth - 50;
                if (this.f_96547_.m_92895_(displayText) > maxTextWidth) {
                    displayText = this.truncateText(displayText, maxTextWidth);
                }
                int textColor = (isBlocked = this.blockedSounds.contains(entry.soundId)) ? 0xFF5555 : 0xFFFFFF;
                graphics.m_280488_(this.f_96547_, displayText, startX + 10, renderY + 6, textColor);
                if (isBlocked) {
                    graphics.m_280509_(startX + contentWidth - 25, renderY + 5, startX + contentWidth - 5, renderY + 20 - 5, -11184811);
                    graphics.m_280488_(this.f_96547_, "\u2713", startX + contentWidth - 20, renderY + 6, 0xFFFFFF);
                }
                renderY += 20;
            }
            if (filtered.size() > maxVisible) {
                boolean isScrollbarHovered;
                int scrollbarX = startX + 500 - 10;
                int scrollbarTrackHeight = boxHeight;
                int scrollbarThumbHeight = Math.max(30, maxVisible * scrollbarTrackHeight / filtered.size());
                int scrollbarThumbY = startY + this.scrollOffset * (scrollbarTrackHeight - scrollbarThumbHeight) / Math.max(1, filtered.size() - maxVisible);
                graphics.m_280509_(scrollbarX, startY, scrollbarX + 10, endY, -14540254);
                boolean bl = isScrollbarHovered = mouseX >= scrollbarX && mouseX <= scrollbarX + 10 && mouseY >= scrollbarThumbY && mouseY <= scrollbarThumbY + scrollbarThumbHeight;
                int thumbColor = this.isDraggingScrollbar ? -3355444 : (isScrollbarHovered ? -4473925 : -5592406);
                graphics.m_280509_(scrollbarX + 1, scrollbarThumbY, scrollbarX + 10 - 1, scrollbarThumbY + scrollbarThumbHeight, thumbColor);
            }
        }
    }

    private void renderSuggestionTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        int relativeY;
        int index;
        String query = this.searchBox.m_94155_().toLowerCase().trim();
        List filtered = this.suggestions.stream().filter(s -> {
            if (this.showOnlyBlocked && !this.blockedSounds.contains(s.soundId)) {
                return false;
            }
            return query.isEmpty() || s.soundId.toLowerCase().contains(query) || s.category.toLowerCase().contains(query);
        }).collect(Collectors.toList());
        int startX = this.f_96543_ / 2 - 250;
        int startY = this.searchBox.m_252907_() + 20 + 10;
        int endY = this.f_96544_ - 70;
        int boxHeight = endY - startY;
        int contentWidth = 488;
        if (filtered.isEmpty()) {
            return;
        }
        if (mouseX >= startX && mouseX <= startX + contentWidth && mouseY >= startY && mouseY < endY && (index = (relativeY = mouseY - startY) / 20 + this.scrollOffset) >= 0 && index < filtered.size()) {
            SuggestionEntry entry = (SuggestionEntry)filtered.get(index);
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237113_((String)("\u00a76" + entry.category)));
            if (this.blockedSounds.contains(entry.soundId)) {
                tooltip.add(Component.m_237113_((String)"\u00a7cClick to unblock"));
            } else {
                tooltip.add(Component.m_237113_((String)"\u00a7aClick to block"));
            }
            graphics.m_280666_(this.f_96547_, tooltip, mouseX, mouseY);
        }
    }

    private int getCategoryColor(String category) {
        return switch (category) {
            case "Explosions" -> -43691;
            case "Gunfire" -> -22016;
            case "Blocks" -> -11141291;
            case "Movement" -> -11184641;
            case "Entity Sounds" -> -43521;
            case "Music" -> -11141121;
            default -> -5592406;
        };
    }

    private String truncateText(String text, int maxWidth) {
        if (this.f_96547_.m_92895_(text) <= maxWidth) {
            return text;
        }
        String ellipsis = "...";
        StringBuilder truncated = new StringBuilder();
        for (char c : text.toCharArray()) {
            truncated.append(c);
            if (this.f_96547_.m_92895_(truncated.toString() + ellipsis) < maxWidth) continue;
            truncated.setLength(truncated.length() - 1);
            break;
        }
        return truncated.toString() + ellipsis;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int relativeY;
            int index;
            String query = this.searchBox.m_94155_().toLowerCase().trim();
            List filtered = this.suggestions.stream().filter(s -> {
                if (this.showOnlyBlocked && !this.blockedSounds.contains(s.soundId)) {
                    return false;
                }
                return query.isEmpty() || s.soundId.toLowerCase().contains(query) || s.category.toLowerCase().contains(query);
            }).collect(Collectors.toList());
            int startX = this.f_96543_ / 2 - 250;
            int startY = this.searchBox.m_252907_() + 20 + 10;
            int endY = this.f_96544_ - 70;
            int boxHeight = endY - startY;
            int contentWidth = 488;
            int maxVisible = boxHeight / 20;
            if (filtered.size() > maxVisible) {
                int scrollbarX = startX + 500 - 10;
                int scrollbarTrackHeight = boxHeight;
                int scrollbarThumbHeight = Math.max(30, maxVisible * scrollbarTrackHeight / filtered.size());
                int scrollbarThumbY = startY + this.scrollOffset * (scrollbarTrackHeight - scrollbarThumbHeight) / Math.max(1, filtered.size() - maxVisible);
                if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + 10) && mouseY >= (double)scrollbarThumbY && mouseY <= (double)(scrollbarThumbY + scrollbarThumbHeight)) {
                    this.isDraggingScrollbar = true;
                    this.dragStartY = (int)mouseY;
                    this.dragStartOffset = this.scrollOffset;
                    return true;
                }
            }
            if (mouseX >= (double)startX && mouseX <= (double)(startX + contentWidth) && mouseY >= (double)startY && mouseY < (double)endY && (index = (relativeY = (int)mouseY - startY) / 20 + this.scrollOffset) >= 0 && index < filtered.size()) {
                SuggestionEntry entry = (SuggestionEntry)filtered.get(index);
                this.toggleBlockedSound(entry.soundId);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isDraggingScrollbar) {
            this.isDraggingScrollbar = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingScrollbar) {
            String query = this.searchBox.m_94155_().toLowerCase().trim();
            long filteredCount = this.suggestions.stream().filter(s -> {
                if (this.showOnlyBlocked && !this.blockedSounds.contains(s.soundId)) {
                    return false;
                }
                return query.isEmpty() || s.soundId.toLowerCase().contains(query) || s.category.toLowerCase().contains(query);
            }).count();
            int startY = this.searchBox.m_252907_() + 20 + 10;
            int endY = this.f_96544_ - 70;
            int boxHeight = endY - startY;
            int maxVisible = boxHeight / 20;
            int scrollbarTrackHeight = boxHeight;
            int scrollbarThumbHeight = Math.max(30, maxVisible * scrollbarTrackHeight / (int)filteredCount);
            int availableTrackHeight = scrollbarTrackHeight - scrollbarThumbHeight;
            int deltaY = (int)mouseY - this.dragStartY;
            int maxScroll = Math.max(0, (int)filteredCount - maxVisible);
            if (availableTrackHeight > 0) {
                int deltaScroll = deltaY * maxScroll / availableTrackHeight;
                this.scrollOffset = Math.max(0, Math.min(this.dragStartOffset + deltaScroll, maxScroll));
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    private void toggleBlockedSound(String soundId) {
        if (this.blockedSounds.contains(soundId)) {
            this.blockedSounds.remove(soundId);
        } else {
            this.blockedSounds.add(soundId);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int startX = this.f_96543_ / 2 - 250;
        int startY = this.searchBox.m_252907_() + 20 + 10;
        int endY = this.f_96544_ - 70;
        if (mouseX >= (double)startX && mouseX <= (double)(startX + 500) && mouseY >= (double)startY && mouseY < (double)endY) {
            this.scrollOffset -= (int)delta;
            String query = this.searchBox.m_94155_().toLowerCase().trim();
            long filteredCount = this.suggestions.stream().filter(s -> {
                if (this.showOnlyBlocked && !this.blockedSounds.contains(s.soundId)) {
                    return false;
                }
                return query.isEmpty() || s.soundId.toLowerCase().contains(query) || s.category.toLowerCase().contains(query);
            }).count();
            int boxHeight = endY - startY;
            int maxVisible = boxHeight / 20;
            int maxScroll = Math.max(0, (int)filteredCount - maxVisible);
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, maxScroll));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            Minecraft.m_91087_().m_91152_(this.parent);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private static class SuggestionEntry {
        final String soundId;
        final String category;

        SuggestionEntry(String soundId, String category) {
            this.soundId = soundId;
            this.category = category;
        }
    }
}

