/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.commands;

import com.armilp.ezvcsurvival.config.EntityVoiceConfig;
import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.config.GunfireConfig;
import com.armilp.ezvcsurvival.config.SoundConfig;
import com.armilp.ezvcsurvival.config.VoiceConfig;
import com.armilp.ezvcsurvival.util.IGoalRefresher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.lang.reflect.Method;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ReloadConfigCommand {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ezvcsurvival").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"reloadconfig").executes(ReloadConfigCommand::executeReload)));
    }

    private static int executeReload(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                source.m_288197_(() -> Component.m_237113_((String)"\u00a76[EZVCSurvival] \u00a7eReloading configuration files..."), false);
                                try {
                                    ReloadConfigCommand.reloadEntityVoiceConfig();
                                }
                                catch (Exception e) {
                                    source.m_81352_((Component)Component.m_237113_((String)("\u00a76[EZVCSurvival] \u00a7cFailed to reload EntityVoiceConfig: " + e.getMessage())));
                                    if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block13;
                                    e.printStackTrace();
                                }
                            }
                            try {
                                ReloadConfigCommand.reloadGeneralSoundsConfig();
                            }
                            catch (Exception e) {
                                source.m_81352_((Component)Component.m_237113_((String)("\u00a76[EZVCSurvival] \u00a7cFailed to reload GeneralSoundConfig: " + e.getMessage())));
                                if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block14;
                                e.printStackTrace();
                            }
                        }
                        try {
                            ReloadConfigCommand.reloadGunfireConfig();
                        }
                        catch (Exception e) {
                            source.m_81352_((Component)Component.m_237113_((String)("\u00a76[EZVCSurvival] \u00a7cFailed to reload GunfireConfig: " + e.getMessage())));
                            if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block15;
                            e.printStackTrace();
                        }
                    }
                    try {
                        SoundConfig.loadConfigs();
                    }
                    catch (Exception e) {
                        source.m_81352_((Component)Component.m_237113_((String)("\u00a76[EZVCSurvival] \u00a7cFailed to reload SoundConfig: " + e.getMessage())));
                        if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block16;
                        e.printStackTrace();
                    }
                }
                try {
                    ReloadConfigCommand.refreshAllMobGoals(source);
                }
                catch (Exception e) {
                    source.m_81352_((Component)Component.m_237113_((String)("\u00a76[EZVCSurvival] \u00a7cFailed to refresh mob goals: " + e.getMessage())));
                    if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block17;
                    e.printStackTrace();
                }
            }
            source.m_288197_(() -> Component.m_237113_((String)"\u00a76[EZVCSurvival] \u00a7aAll configurations reloaded successfully!"), false);
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("\u00a76[EZVCSurvival] \u00a7cAn unexpected error occurred: " + e.getMessage())));
            if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    private static void reloadEntityVoiceConfig() throws Exception {
        Method loadOrCreateMethod = EntityVoiceConfig.class.getDeclaredMethod("loadOrCreate", new Class[0]);
        loadOrCreateMethod.setAccessible(true);
        loadOrCreateMethod.invoke(null, new Object[0]);
    }

    private static void reloadGeneralSoundsConfig() throws Exception {
        Method loadOrCreateMethod = GeneralSoundsConfig.class.getDeclaredMethod("loadOrCreate", new Class[0]);
        loadOrCreateMethod.setAccessible(true);
        loadOrCreateMethod.invoke(null, new Object[0]);
    }

    private static void reloadGunfireConfig() throws Exception {
        Method loadOrCreateMethod = GunfireConfig.class.getDeclaredMethod("loadOrCreate", new Class[0]);
        loadOrCreateMethod.setAccessible(true);
        loadOrCreateMethod.invoke(null, new Object[0]);
    }

    private static void refreshAllMobGoals(CommandSourceStack source) {
        if (source.m_81377_() != null) {
            int totalRefreshed = 0;
            for (ServerLevel level : source.m_81377_().m_129785_()) {
                for (Entity entity : level.m_8583_()) {
                    if (!(entity instanceof Mob)) continue;
                    Mob mob = (Mob)entity;
                    if (!(entity instanceof IGoalRefresher)) continue;
                    IGoalRefresher goalRefresher = (IGoalRefresher)entity;
                    try {
                        goalRefresher.ezvcsurvival$RefreshGoals();
                        ++totalRefreshed;
                    }
                    catch (Exception e) {
                        if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) continue;
                        System.err.println("[EZVCSurvival] Error refreshing goals for mob " + mob.m_6095_() + ": " + e.getMessage());
                    }
                }
            }
            if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
                System.out.println("[EZVCSurvival] Refreshed goals for " + totalRefreshed + " mobs across all levels");
            }
        } else if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
            System.err.println("[EZVCSurvival] Could not access server to refresh mob goals");
        }
    }
}

