/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.compat.mobs;

import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.armilp.ezvcsurvival.compat.mobs.SporeVoiceTargetGoal;
import com.armilp.ezvcsurvival.config.EntityVoiceConfig;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class SporeCompatLoader {
    public static void init() {
        if (!ModList.get().isLoaded("spore")) {
            System.out.println("[EZVCSurvival] Spore not found, skipping compatibility.");
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)new SporeCompatLoader());
        System.out.println("[EZVCSurvival] Spore compatibility active.");
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Infected)) {
            return;
        }
        Infected infected = (Infected)entity;
        if (!EntityVoiceConfig.isEnabled()) {
            return;
        }
        String id = event.getEntity().m_6095_().m_204041_().m_205785_().m_135782_().toString();
        if (!id.startsWith("spore:")) {
            return;
        }
        EntityVoiceConfig.EntityConfig cfg = EntityVoiceConfig.getOrCreate(id);
        if (!cfg.enabled) {
            return;
        }
        try {
            SporeVoiceTargetGoal voiceGoal = new SporeVoiceTargetGoal(infected, cfg.speed, (int)cfg.range, cfg.threshold, 10000L);
            infected.f_21345_.m_25352_(1, (Goal)voiceGoal);
            System.out.println("[EZVCSurvival] Added SporeVoiceTargetGoal to " + id);
        }
        catch (Exception e) {
            System.err.println("[EZVCSurvival] Failed to add goal to Spore infected: " + e);
        }
    }
}

