/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.config;

import com.armilp.ezvcsurvival.EZVCSurvival;
import com.armilp.ezvcsurvival.compat.guns.PointBlankSoundsConfig;
import com.armilp.ezvcsurvival.compat.guns.SBWarfareSoundsConfig;
import com.armilp.ezvcsurvival.data.SoundGroupData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public final class GeneralSoundsConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type ROOT_TYPE = new TypeToken<Root>(){}.getType();
    public static Root ROOT = new Root();
    private static boolean isInitialized = false;

    private GeneralSoundsConfig() {
    }

    public static void init() {
        if (!isInitialized) {
            GeneralSoundsConfig.loadOrCreate();
            isInitialized = true;
        } else {
            GeneralSoundsConfig.reloadFromDisk();
        }
    }

    private static void reloadFromDisk() {
        Path path = GeneralSoundsConfig.getPath();
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                Root loaded = (Root)GSON.fromJson((Reader)reader, ROOT_TYPE);
                if (loaded != null) {
                    ROOT = loaded;
                    if (GeneralSoundsConfig.ROOT.mobs == null) {
                        GeneralSoundsConfig.ROOT.mobs = new HashMap<String, Reaction>();
                    }
                    if (GeneralSoundsConfig.ROOT.sounds == null) {
                        GeneralSoundsConfig.ROOT.sounds = new HashMap<String, SoundEntry>();
                    }
                }
            }
            catch (Exception e) {
                EZVCSurvival.LOGGER.warn("Error reloading generalsounds.json: {}", (Object)e.getMessage());
            }
        }
    }

    public static Map<String, Reaction> getMobReactions() {
        if (ROOT == null) {
            ROOT = new Root();
        }
        if (GeneralSoundsConfig.ROOT.mobs == null) {
            GeneralSoundsConfig.ROOT.mobs = new HashMap<String, Reaction>();
        }
        return GeneralSoundsConfig.ROOT.mobs;
    }

    public static void setMobReaction(String entityId, boolean enabled, double speed, double range) {
        Reaction existing;
        if (ROOT == null) {
            ROOT = new Root();
        }
        if (GeneralSoundsConfig.ROOT.mobs == null) {
            GeneralSoundsConfig.ROOT.mobs = new HashMap<String, Reaction>();
        }
        if ((existing = GeneralSoundsConfig.ROOT.mobs.get(entityId)) != null) {
            existing.enabled = enabled;
            existing.speed = speed;
            existing.range = range;
        } else {
            GeneralSoundsConfig.ROOT.mobs.put(entityId, new Reaction(enabled, speed, range));
        }
    }

    public static boolean canEntityReactToSound(String entityId, String soundId) {
        if (ROOT == null || GeneralSoundsConfig.ROOT.mobs == null) {
            return true;
        }
        Reaction reaction = GeneralSoundsConfig.ROOT.mobs.get(entityId);
        if (reaction == null || reaction.blocked_sounds == null || reaction.blocked_sounds.isEmpty()) {
            return true;
        }
        String normalizedSoundId = soundId.toLowerCase();
        for (String blocked : reaction.blocked_sounds) {
            if (blocked == null || blocked.trim().isEmpty()) continue;
            String normalizedBlocked = blocked.toLowerCase().trim();
            if (normalizedSoundId.equals(normalizedBlocked)) {
                return false;
            }
            if (!(normalizedBlocked.contains("*") ? GeneralSoundsConfig.matchesWildcard(normalizedSoundId, normalizedBlocked) : normalizedSoundId.startsWith(normalizedBlocked))) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesWildcard(String text, String pattern) {
        String regex = pattern.replace(".", "\\.").replace("*", ".*");
        try {
            return text.matches(regex);
        }
        catch (Exception e) {
            return text.startsWith(pattern.replace("*", ""));
        }
    }

    public static Map<String, SoundEntry> getSounds() {
        if (ROOT == null) {
            ROOT = new Root();
        }
        if (GeneralSoundsConfig.ROOT.sounds == null) {
            GeneralSoundsConfig.ROOT.sounds = new HashMap<String, SoundEntry>();
        }
        return GeneralSoundsConfig.ROOT.sounds;
    }

    public static void setSoundEntry(String soundId, boolean enabled, double speedMultiplier, double rangeMultiplier) {
        GeneralSoundsConfig.setSoundEntry(soundId, enabled, speedMultiplier, rangeMultiplier, false);
    }

    public static void setSoundEntry(String soundId, boolean enabled, double speedMultiplier, double rangeMultiplier, boolean isPriority) {
        SoundEntry existing;
        if (ROOT == null) {
            ROOT = new Root();
        }
        if (GeneralSoundsConfig.ROOT.sounds == null) {
            GeneralSoundsConfig.ROOT.sounds = new HashMap<String, SoundEntry>();
        }
        if ((existing = GeneralSoundsConfig.ROOT.sounds.get(soundId)) != null) {
            existing.enabled = enabled;
            existing.speed_multiplier = speedMultiplier;
            existing.range_multiplier = rangeMultiplier;
            existing.is_priority = isPriority;
        } else {
            SoundEntry newEntry = new SoundEntry(enabled, speedMultiplier, rangeMultiplier, isPriority);
            GeneralSoundsConfig.ROOT.sounds.put(soundId, newEntry);
        }
    }

    public static void processPrioritySounds(List<SoundGroupData> priorityGroups) {
        Map<String, SoundEntry> sounds = GeneralSoundsConfig.getSounds();
        if (sounds == null) {
            return;
        }
        priorityGroups.removeIf(group -> group.groupName().startsWith("auto_priority_"));
        for (Map.Entry<String, SoundEntry> entry : sounds.entrySet()) {
            String groupName;
            SoundGroupData priorityGroup;
            String soundId = entry.getKey();
            SoundEntry soundEntry = entry.getValue();
            if (!soundEntry.enabled || !soundEntry.is_priority || (priorityGroup = GeneralSoundsConfig.createPriorityGroup(groupName = "auto_priority_" + soundId.replace(':', '_').replace('.', '_'), soundId, soundEntry)) == null) continue;
            priorityGroups.add(priorityGroup);
            EZVCSurvival.LOGGER.debug("Added active priority group: {} for sound: {}", (Object)groupName, (Object)soundId);
        }
    }

    private static SoundGroupData createPriorityGroup(String groupName, String soundId, SoundEntry config) {
        try {
            double prioritySpeedMultiplier = config.speed_multiplier * 1.5;
            double priorityRangeMultiplier = config.range_multiplier * 1.5;
            return new SoundGroupData(groupName, List.of(soundId), prioritySpeedMultiplier, priorityRangeMultiplier);
        }
        catch (Exception e) {
            EZVCSurvival.LOGGER.warn("Could not create priority sound group for {}: {}", (Object)soundId, (Object)e.getMessage());
            return null;
        }
    }

    public static void enableAllPrioritySounds(boolean enabled) {
        Map<String, SoundEntry> sounds = GeneralSoundsConfig.getSounds();
        boolean changed = false;
        for (Map.Entry<String, SoundEntry> entry : sounds.entrySet()) {
            SoundEntry sound = entry.getValue();
            if (!sound.is_priority) continue;
            sound.enabled = enabled;
            changed = true;
            EZVCSurvival.LOGGER.debug("Set priority sound '{}' enabled to: {}", (Object)entry.getKey(), (Object)enabled);
        }
        if (changed) {
            GeneralSoundsConfig.persist();
            EZVCSurvival.LOGGER.info("Updated all priority sounds to enabled={}", (Object)enabled);
        }
    }

    public static boolean isEnabled() {
        return ROOT == null || GeneralSoundsConfig.ROOT.enabled;
    }

    public static void setEnabled(boolean enabled) {
        if (ROOT == null) {
            ROOT = new Root();
        }
        GeneralSoundsConfig.ROOT.enabled = enabled;
        GeneralSoundsConfig.persist();
    }

    public static void persist() {
        GeneralSoundsConfig.save(GeneralSoundsConfig.getPath());
    }

    private static Path getPath() {
        Path configDir = FMLPaths.CONFIGDIR.get().resolve("ezvcsurvival");
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return configDir.resolve("generalsounds.json");
    }

    private static void loadOrCreate() {
        Path path = GeneralSoundsConfig.getPath();
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                Root loaded = (Root)GSON.fromJson((Reader)reader, ROOT_TYPE);
                if (loaded != null) {
                    ROOT = loaded;
                    if (GeneralSoundsConfig.ROOT.mobs == null) {
                        GeneralSoundsConfig.ROOT.mobs = new HashMap<String, Reaction>();
                    }
                    if (GeneralSoundsConfig.ROOT.sounds == null) {
                        GeneralSoundsConfig.ROOT.sounds = new HashMap<String, SoundEntry>();
                    }
                } else {
                    ROOT = new Root();
                    GeneralSoundsConfig.generateDefaults();
                    GeneralSoundsConfig.save(path);
                }
            }
            catch (JsonParseException | MalformedJsonException e) {
                EZVCSurvival.LOGGER.warn("Malformed JSON in generalsounds.json, using defaults (no backup): {}", (Object)e.getMessage());
                ROOT = new Root();
                GeneralSoundsConfig.generateDefaults();
                GeneralSoundsConfig.save(path);
            }
            catch (IOException e) {
                EZVCSurvival.LOGGER.warn("Error reading generalsounds.json, regenerating: {}", (Object)e.getMessage());
                ROOT = new Root();
                GeneralSoundsConfig.generateDefaults();
                GeneralSoundsConfig.save(path);
            }
        } else {
            ROOT = new Root();
            GeneralSoundsConfig.generateDefaults();
            GeneralSoundsConfig.save(path);
        }
        boolean addedNew = GeneralSoundsConfig.ensureNewEntitiesOnly();
        if (addedNew) {
            GeneralSoundsConfig.save(path);
        }
    }

    private static boolean ensureNewEntitiesOnly() {
        boolean added = false;
        if (GeneralSoundsConfig.ROOT.mobs == null) {
            GeneralSoundsConfig.ROOT.mobs = new HashMap<String, Reaction>();
        }
        for (EntityType type : ForgeRegistries.ENTITY_TYPES) {
            String id;
            MobCategory category = type.m_20674_();
            if (category == MobCategory.MISC || GeneralSoundsConfig.ROOT.mobs.containsKey(id = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)type)).toString())) continue;
            GeneralSoundsConfig.ROOT.mobs.put(id, Reaction.defaultFor(type));
            added = true;
        }
        if (GeneralSoundsConfig.ROOT.sounds == null) {
            GeneralSoundsConfig.ROOT.sounds = new HashMap<String, SoundEntry>();
        }
        for (SoundEvent sound : ForgeRegistries.SOUND_EVENTS) {
            String id = Objects.requireNonNull(ForgeRegistries.SOUND_EVENTS.getKey((Object)sound)).toString();
            if (GeneralSoundsConfig.ROOT.sounds.containsKey(id)) continue;
            boolean shouldEnable = GeneralSoundsConfig.shouldEnableByDefault(id);
            boolean shouldBePriority = GeneralSoundsConfig.shouldBePriorityByDefault(id);
            GeneralSoundsConfig.ROOT.sounds.put(id, new SoundEntry(shouldEnable, 1.0, 1.0, shouldBePriority));
            added = true;
        }
        PointBlankSoundsConfig.apply(GeneralSoundsConfig.ROOT.sounds);
        SBWarfareSoundsConfig.apply(GeneralSoundsConfig.ROOT.sounds);
        return added;
    }

    private static boolean shouldEnableByDefault(String soundId) {
        if (soundId.startsWith("pointblank:") || soundId.contains("superbwarfare:")) {
            return false;
        }
        return soundId.contains("place") || soundId.contains("break") || soundId.contains("explode") || soundId.contains("explosion");
    }

    private static boolean shouldBePriorityByDefault(String soundId) {
        if (soundId.startsWith("pointblank:") || soundId.contains("superbwarfare:")) {
            return false;
        }
        return soundId.contains("explode") || soundId.contains("explosion");
    }

    private static void generateDefaults() {
        if (GeneralSoundsConfig.ROOT.mobs == null) {
            GeneralSoundsConfig.ROOT.mobs = new HashMap<String, Reaction>();
        }
        if (GeneralSoundsConfig.ROOT.sounds == null) {
            GeneralSoundsConfig.ROOT.sounds = new HashMap<String, SoundEntry>();
        }
        GeneralSoundsConfig.ROOT.mobs.clear();
        for (EntityType type : ForgeRegistries.ENTITY_TYPES) {
            MobCategory category = type.m_20674_();
            if (category == MobCategory.MISC) continue;
            GeneralSoundsConfig.ROOT.mobs.put(Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)type)).toString(), Reaction.defaultFor(type));
        }
        GeneralSoundsConfig.putIfPresent(GeneralSoundsConfig.ROOT.mobs, "minecraft:zombie", new Reaction(true, 1.7, 60.0));
        GeneralSoundsConfig.putIfPresent(GeneralSoundsConfig.ROOT.mobs, "minecraft:skeleton", new Reaction(true, 1.2, 40.0));
        GeneralSoundsConfig.putIfPresent(GeneralSoundsConfig.ROOT.mobs, "quiet_place:death_angel", new Reaction(true, 1.2, 50.0));
        GeneralSoundsConfig.putIfPresent(GeneralSoundsConfig.ROOT.mobs, "minecraft:cow", new Reaction(true, 1.5, 25.0));
        GeneralSoundsConfig.putIfPresent(GeneralSoundsConfig.ROOT.mobs, "minecraft:pig", new Reaction(true, 1.2, 15.0));
        GeneralSoundsConfig.activateEntitiesFromMod(GeneralSoundsConfig.ROOT.mobs, "zombie_extreme", new Reaction(true, 1.0, 40.0));
        GeneralSoundsConfig.activateEntitiesFromMod(GeneralSoundsConfig.ROOT.mobs, "apocalypsenow", new Reaction(true, 1.0, 40.0));
    }

    private static void putIfPresent(Map<String, Reaction> map, String id, Reaction config) {
        if (map.containsKey(id)) {
            map.put(id, config);
        }
    }

    private static void activateEntitiesFromMod(Map<String, Reaction> map, String modId, Reaction config) {
        for (String entityId : map.keySet()) {
            if (!entityId.startsWith(modId + ":")) continue;
            map.put(entityId, config);
        }
    }

    private static void save(Path path) {
        if (ROOT == null) {
            EZVCSurvival.LOGGER.warn("Cannot save null configuration");
            return;
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                GSON.toJson((Object)ROOT, ROOT_TYPE, (Appendable)writer);
                writer.flush();
            }
        }
        catch (IOException e) {
            EZVCSurvival.LOGGER.error("Failed to save generalsounds.json: {}", (Object)e.getMessage());
        }
    }

    public static final class Root {
        public boolean enabled = true;
        public Map<String, Reaction> mobs;
        public Map<String, SoundEntry> sounds;
    }

    public static final class Reaction {
        public boolean enabled;
        public double speed;
        public double range;
        public List<String> blocked_sounds;

        public Reaction(boolean enabled, double speed, double range) {
            this(enabled, speed, range, new ArrayList<String>());
        }

        public Reaction(boolean enabled, double speed, double range, List<String> blockedSounds) {
            this.enabled = enabled;
            this.speed = speed;
            this.range = range;
            this.blocked_sounds = blockedSounds != null ? new ArrayList<String>(blockedSounds) : new ArrayList();
        }

        public static Reaction defaultFor(EntityType<?> type) {
            double baseSpeed = 1.0;
            double baseRange = 50.0;
            if (type.m_20674_() == MobCategory.MONSTER) {
                baseRange = 60.0;
            }
            return new Reaction(false, baseSpeed, baseRange);
        }
    }

    public static final class SoundEntry {
        public boolean enabled;
        public double speed_multiplier;
        public double range_multiplier;
        public boolean is_priority;

        public SoundEntry(boolean enabled, double speedMultiplier, double rangeMultiplier) {
            this(enabled, speedMultiplier, rangeMultiplier, false);
        }

        public SoundEntry(boolean enabled, double speedMultiplier, double rangeMultiplier, boolean isPriority) {
            this.enabled = enabled;
            this.speed_multiplier = speedMultiplier;
            this.range_multiplier = rangeMultiplier;
            this.is_priority = isPriority;
        }
    }
}

