/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.config;

import com.armilp.ezvcsurvival.EZVCSurvival;
import com.armilp.ezvcsurvival.config.VoiceConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public final class GunfireConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type ROOT_TYPE = new TypeToken<Root>(){}.getType();
    public static Root ROOT = new Root();
    private static boolean isInitialized = false;

    private GunfireConfig() {
    }

    public static void init() {
        if (!isInitialized) {
            GunfireConfig.loadOrCreate();
            isInitialized = true;
        } else {
            GunfireConfig.reloadFromDisk();
        }
    }

    private static void reloadFromDisk() {
        Path path = GunfireConfig.getPath();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                String content = Files.readString(path, StandardCharsets.UTF_8);
                try (StringReader r = new StringReader(content);){
                    Root loaded = (Root)GSON.fromJson((Reader)r, ROOT_TYPE);
                    if (loaded != null) {
                        ROOT = loaded;
                        if (GunfireConfig.ROOT.mobs == null) {
                            GunfireConfig.ROOT.mobs = new HashMap<String, Reaction>();
                        }
                    }
                }
            }
            catch (Exception e) {
                EZVCSurvival.LOGGER.warn("Error reloading gunfire.json: {}", (Object)e.getMessage());
            }
        }
    }

    public static Map<String, Reaction> getMobReactions() {
        if (ROOT == null) {
            ROOT = new Root();
        }
        if (GunfireConfig.ROOT.mobs == null) {
            GunfireConfig.ROOT.mobs = new HashMap<String, Reaction>();
        }
        return GunfireConfig.ROOT.mobs;
    }

    public static boolean isEnabled() {
        return ROOT == null || GunfireConfig.ROOT.enabled;
    }

    private static Path getPath() {
        Path dir = FMLPaths.CONFIGDIR.get().resolve("ezvcsurvival");
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return dir.resolve("gunfire.json");
    }

    private static void loadOrCreate() {
        boolean changed;
        boolean isNewFile;
        Path path = GunfireConfig.getPath();
        boolean bl = isNewFile = !Files.exists(path, new LinkOption[0]);
        if (!isNewFile) {
            try {
                String content = Files.readString(path, StandardCharsets.UTF_8);
                try (StringReader r = new StringReader(content);){
                    Root loaded = (Root)GSON.fromJson((Reader)r, ROOT_TYPE);
                    ROOT = loaded != null ? loaded : GunfireConfig.defaultRoot();
                }
            }
            catch (MalformedJsonException e) {
                EZVCSurvival.LOGGER.warn("Malformed JSON in gunfire.json, using defaults (no backup): {}", (Object)e.getMessage());
                ROOT = GunfireConfig.defaultRoot();
                isNewFile = true;
                GunfireConfig.save(path);
            }
            catch (IOException e) {
                EZVCSurvival.LOGGER.warn("Error reading gunfire.json, regenerating: {}", (Object)e.getMessage());
                ROOT = GunfireConfig.defaultRoot();
                isNewFile = true;
                GunfireConfig.save(path);
            }
        } else {
            ROOT = GunfireConfig.defaultRoot();
        }
        if (changed = GunfireConfig.ensureAllPresent(isNewFile)) {
            GunfireConfig.save(path);
        }
    }

    private static boolean ensureAllPresent(boolean isNewFile) {
        boolean changed = false;
        if (GunfireConfig.ROOT.mobs == null) {
            GunfireConfig.ROOT.mobs = new HashMap<String, Reaction>();
            changed = true;
        }
        for (EntityType type : ForgeRegistries.ENTITY_TYPES) {
            String id;
            MobCategory cat = type.m_20674_();
            if (cat == MobCategory.MISC || GunfireConfig.ROOT.mobs.containsKey(id = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)type)).toString())) continue;
            boolean shouldEnable = isNewFile && (id.equals("minecraft:zombie") || id.equals("minecraft:skeleton") || id.equals("minecraft:cow") || id.equals("minecraft:pig") || id.startsWith("zombie_extreme:") || id.startsWith("apocalypsenow:"));
            double defaultRange = cat == MobCategory.MONSTER ? 50.0 : 40.0;
            GunfireConfig.ROOT.mobs.put(id, new Reaction(shouldEnable, 1.0, defaultRange));
            changed = true;
        }
        return changed;
    }

    private static Root defaultRoot() {
        Root r = new Root();
        r.mobs = new HashMap<String, Reaction>();
        return r;
    }

    private static void save(Path path) {
        if (ROOT == null) {
            EZVCSurvival.LOGGER.warn("Cannot save null ROOT configuration");
            return;
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                GSON.toJson((Object)ROOT, ROOT_TYPE, (Appendable)w);
                w.flush();
            }
            if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
                System.out.println("[EZVCSurvival] Successfully saved gunfire.json");
            }
        }
        catch (IOException e) {
            EZVCSurvival.LOGGER.error("Failed to save gunfire.json: {}", (Object)e.getMessage());
        }
    }

    public static void setMobReaction(String entityId, boolean enabled, double speed, double range) {
        if (GunfireConfig.ROOT.mobs == null) {
            GunfireConfig.ROOT.mobs = new HashMap<String, Reaction>();
        }
        GunfireConfig.ROOT.mobs.put(entityId, new Reaction(enabled, speed, range));
    }

    public static void persist() {
        GunfireConfig.save(GunfireConfig.getPath());
    }

    public static final class Root {
        public boolean enabled = true;
        public Map<String, Reaction> mobs;
    }

    public static final class Reaction {
        public boolean enabled;
        public double speed;
        public double range;

        public Reaction(boolean enabled, double speed, double range) {
            this.enabled = enabled;
            this.speed = speed;
            this.range = range;
        }
    }
}

