/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.goals;

import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.config.SoundConfig;
import com.armilp.ezvcsurvival.data.SoundGroupData;
import com.armilp.ezvcsurvival.events.SoundEventTracker;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ReactToGeneralSoundGoal
extends Goal {
    private final Mob mob;
    private final double speed;
    private final double range;
    private final List<SoundGroupData> soundGroups;
    private final String entityId;
    private final Vec3 lastAttackerPos = null;
    private static final List<ReactToGeneralSoundGoal> activeGoals = new CopyOnWriteArrayList<ReactToGeneralSoundGoal>();
    public static Vec3 lastPrioritySoundPos = null;
    public static long lastPrioritySoundTimestamp = 0L;
    private static final long PRIORITY_SOUND_DURATION_MS = 3500L;
    private static final AtomicInteger activeMobsReacting = new AtomicInteger(0);
    private static final int MAX_CONCURRENT_REACTIONS = 50;
    private boolean isReacting = false;
    private Vec3 cachedMobPos = null;
    private long lastPosUpdate = 0L;
    private static final long POS_CACHE_MS = 100L;

    public ReactToGeneralSoundGoal(Mob mob, double speed, double range, List<SoundGroupData> soundGroups) {
        this.mob = mob;
        this.speed = speed;
        this.range = range;
        this.soundGroups = soundGroups;
        this.entityId = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_())).toString();
        activeGoals.add(this);
    }

    public boolean m_8036_() {
        if (this.mob.m_5448_() != null) {
            return false;
        }
        if (!this.isReacting && activeMobsReacting.get() >= 50) {
            return false;
        }
        if (lastPrioritySoundPos != null && System.currentTimeMillis() - lastPrioritySoundTimestamp > 3500L) {
            lastPrioritySoundPos = null;
        }
        this.checkForPrioritySounds();
        Vec3 mobCenterPos = this.getCachedMobPosition();
        double effectiveRange = this.range;
        if (this.mob.m_9236_().m_46471_() || this.mob.m_9236_().m_46470_()) {
            effectiveRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
        }
        if (lastPrioritySoundPos != null) {
            double priorityRange = effectiveRange * 1.5;
            double distSq = mobCenterPos.m_82557_(lastPrioritySoundPos);
            if (distSq <= priorityRange * priorityRange) {
                return true;
            }
        }
        for (SoundGroupData group : this.soundGroups) {
            for (String soundStr : group.sounds()) {
                double distSq;
                ResourceLocation loc;
                Vec3 pos;
                if (!GeneralSoundsConfig.canEntityReactToSound(this.entityId, soundStr) || (pos = SoundEventTracker.getLastPlayedPositionForSound(loc = this.toLocation(soundStr))) == null) continue;
                double grpRange = this.range * group.rangeMultiplier();
                if (this.mob.m_9236_().m_46471_() || this.mob.m_9236_().m_46470_()) {
                    grpRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
                }
                if (!((distSq = mobCenterPos.m_82557_(pos)) <= grpRange * grpRange)) continue;
                return true;
            }
        }
        boolean hurtTriggered = !(this.mob instanceof Monster) && this.lastAttackerPos != null;
        return hurtTriggered;
    }

    public void m_8056_() {
        if (!this.isReacting) {
            activeMobsReacting.incrementAndGet();
            this.isReacting = true;
        }
        this.updateNavigation();
    }

    public void m_8037_() {
        Vec3 targetPos;
        this.updateNavigation();
        if (this.mob instanceof Monster && (targetPos = this.getCurrentTargetPosition()) != null) {
            this.mob.m_21563_().m_24950_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 30.0f, 30.0f);
        }
    }

    public void m_8041_() {
        if (this.isReacting) {
            activeMobsReacting.decrementAndGet();
            this.isReacting = false;
        }
        activeGoals.remove((Object)this);
    }

    private Vec3 getCachedMobPosition() {
        long now = System.currentTimeMillis();
        if (this.cachedMobPos == null || now - this.lastPosUpdate > 100L) {
            this.cachedMobPos = this.mob.m_20182_();
            this.lastPosUpdate = now;
        }
        return this.cachedMobPos;
    }

    private void checkForPrioritySounds() {
        for (SoundGroupData priority : SoundConfig.getPriorityGroups()) {
            for (String soundStr : priority.sounds()) {
                ResourceLocation soundLoc;
                Vec3 priorityPos;
                if (!GeneralSoundsConfig.canEntityReactToSound(this.entityId, soundStr) || (priorityPos = SoundEventTracker.getLastPlayedPositionForSound(soundLoc = this.toLocation(soundStr))) == null) continue;
                lastPrioritySoundPos = priorityPos;
                lastPrioritySoundTimestamp = System.currentTimeMillis();
                return;
            }
        }
    }

    private void updateNavigation() {
        if (this.mob.m_5448_() != null) {
            return;
        }
        if (lastPrioritySoundPos != null && System.currentTimeMillis() - lastPrioritySoundTimestamp > 3500L) {
            lastPrioritySoundPos = null;
        }
        this.checkForPrioritySounds();
        Vec3 currentPos = this.getCachedMobPosition();
        if (lastPrioritySoundPos != null) {
            double distance;
            double priorityRange = this.range * 1.5;
            double prioritySpeed = this.speed * 1.3;
            if (this.mob.m_9236_().m_46471_() || this.mob.m_9236_().m_46470_()) {
                priorityRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
            }
            if ((distance = currentPos.m_82554_(lastPrioritySoundPos)) <= priorityRange) {
                Vec3 target;
                if (this.mob instanceof Monster) {
                    target = this.grounded(lastPrioritySoundPos);
                } else {
                    Vec3 directionAway = currentPos.m_82546_(lastPrioritySoundPos).m_82541_();
                    target = this.grounded(currentPos.m_82549_(directionAway.m_82490_(priorityRange)));
                }
                if (distance > 50.0) {
                    this.mob.m_21573_().m_26519_(target.f_82479_, target.f_82480_, target.f_82481_, prioritySpeed * 0.8);
                } else {
                    this.mob.m_21573_().m_26519_(target.f_82479_, target.f_82480_, target.f_82481_, prioritySpeed);
                }
                if (distance < 2.0) {
                    lastPrioritySoundPos = null;
                }
                return;
            }
        }
        if (lastPrioritySoundPos == null) {
            for (SoundGroupData group : this.soundGroups) {
                for (String soundStr : group.sounds()) {
                    double distance;
                    ResourceLocation loc;
                    Vec3 pos;
                    if (!GeneralSoundsConfig.canEntityReactToSound(this.entityId, soundStr) || (pos = SoundEventTracker.getLastPlayedPositionForSound(loc = this.toLocation(soundStr))) == null) continue;
                    double grpRange = this.range * group.rangeMultiplier();
                    double grpSpeed = this.speed * group.speedMultiplier();
                    if (this.mob.m_9236_().m_46471_() || this.mob.m_9236_().m_46470_()) {
                        grpRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
                    }
                    if (!((distance = currentPos.m_82554_(pos)) <= grpRange)) continue;
                    if (this.mob instanceof Monster) {
                        Vec3 target = this.grounded(pos);
                        if (distance > 50.0) {
                            this.mob.m_21573_().m_26519_(target.f_82479_, target.f_82480_, target.f_82481_, grpSpeed * 0.8);
                        } else {
                            this.mob.m_21573_().m_26519_(target.f_82479_, target.f_82480_, target.f_82481_, grpSpeed);
                        }
                    } else {
                        Vec3 directionAway = currentPos.m_82546_(pos).m_82541_();
                        Vec3 fleeTarget = this.grounded(currentPos.m_82549_(directionAway.m_82490_(grpRange)));
                        this.mob.m_21573_().m_26519_(fleeTarget.f_82479_, fleeTarget.f_82480_, fleeTarget.f_82481_, grpSpeed);
                    }
                    return;
                }
            }
        }
    }

    private ResourceLocation toLocation(String soundStr) {
        if (soundStr.contains(":")) {
            return ResourceLocation.parse((String)soundStr);
        }
        return ResourceLocation.withDefaultNamespace((String)soundStr);
    }

    private Vec3 grounded(Vec3 desiredXZ) {
        BlockPos base = BlockPos.m_274561_((double)desiredXZ.f_82479_, (double)0.0, (double)desiredXZ.f_82481_);
        BlockPos top = this.mob.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, base);
        return new Vec3((double)top.m_123341_() + 0.5, (double)top.m_123342_(), (double)top.m_123343_() + 0.5);
    }

    private Vec3 getCurrentTargetPosition() {
        if (lastPrioritySoundPos != null) {
            return lastPrioritySoundPos;
        }
        for (SoundGroupData group : this.soundGroups) {
            for (String soundStr : group.sounds()) {
                double distSq;
                ResourceLocation loc;
                Vec3 pos;
                if (!GeneralSoundsConfig.canEntityReactToSound(this.entityId, soundStr) || (pos = SoundEventTracker.getLastPlayedPositionForSound(loc = this.toLocation(soundStr))) == null) continue;
                double grpRange = this.range * group.rangeMultiplier();
                if (this.mob.m_9236_().m_46471_() || this.mob.m_9236_().m_46470_()) {
                    grpRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
                }
                if (!((distSq = this.getCachedMobPosition().m_82557_(pos)) <= grpRange * grpRange)) continue;
                return pos;
            }
        }
        return null;
    }

    public static void setPrioritySound(Vec3 position) {
        lastPrioritySoundPos = position;
        lastPrioritySoundTimestamp = System.currentTimeMillis();
    }
}

