/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.goals;

import com.armilp.ezvcsurvival.compat.guns.GunFireListener;
import com.armilp.ezvcsurvival.config.SoundConfig;
import com.armilp.ezvcsurvival.data.GunshotData;
import com.armilp.ezvcsurvival.data.SoundGroupData;
import com.armilp.ezvcsurvival.events.SoundEventTracker;
import com.armilp.ezvcsurvival.goals.ReactToGeneralSoundGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class ReactToGunfireGoal
extends Goal {
    private final Mob mob;
    private final double baseSpeed;
    private final double baseRange;
    private static final long PRIORITY_SOUND_DURATION_MS = 3000L;

    public ReactToGunfireGoal(Mob mob, double speed, double range) {
        this.mob = mob;
        this.baseSpeed = speed;
        this.baseRange = range;
    }

    public boolean m_8036_() {
        if (this.mob.m_5448_() != null) {
            return false;
        }
        if (ReactToGeneralSoundGoal.lastPrioritySoundPos != null && System.currentTimeMillis() - ReactToGeneralSoundGoal.lastPrioritySoundTimestamp > 3000L) {
            ReactToGeneralSoundGoal.lastPrioritySoundPos = null;
        }
        this.checkForPrioritySounds();
        Vec3 mobCenterPos = this.mob.m_20182_();
        if (ReactToGeneralSoundGoal.lastPrioritySoundPos != null) {
            double priorityRange = this.baseRange * 1.5;
            if (this.mob.m_9236_().m_46471_() || this.mob.m_9236_().m_46470_()) {
                priorityRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
            }
            if (mobCenterPos.m_82554_(ReactToGeneralSoundGoal.lastPrioritySoundPos) <= priorityRange) {
                return true;
            }
        }
        if (ReactToGeneralSoundGoal.lastPrioritySoundPos == null) {
            double effectiveRange = this.baseRange;
            String effectiveGunType = null;
            GunshotData gunshotData = GunFireListener.getLastGunshotData();
            if (gunshotData != null) {
                effectiveGunType = gunshotData.gunType().name().toLowerCase();
            }
            if (effectiveGunType != null) {
                double rangeMultiplier = SoundConfig.getRangeMultiplier(effectiveGunType);
                effectiveRange = this.baseRange * rangeMultiplier;
            }
            if (this.mob.m_9236_().m_46471_() || this.mob.m_9236_().m_46470_()) {
                effectiveRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
            }
            return gunshotData != null && mobCenterPos.m_82554_(gunshotData.position()) <= effectiveRange;
        }
        return false;
    }

    public void m_8056_() {
        this.updateNavigation();
    }

    public void m_8037_() {
        this.updateNavigation();
    }

    private void checkForPrioritySounds() {
        String gunType;
        for (SoundGroupData priority : SoundConfig.getPriorityGroups()) {
            for (String soundStr : priority.sounds()) {
                ResourceLocation soundLoc = this.toLocation(soundStr);
                Vec3 priorityPos = SoundEventTracker.getLastPlayedPositionForSound(soundLoc);
                if (priorityPos == null) continue;
                ReactToGeneralSoundGoal.setPrioritySound(priorityPos);
                return;
            }
        }
        GunshotData gunshotData = GunFireListener.getLastGunshotData();
        if (gunshotData != null && this.isPriorityGunType(gunType = gunshotData.gunType().name().toLowerCase())) {
            ReactToGeneralSoundGoal.setPrioritySound(gunshotData.position());
        }
    }

    private boolean isPriorityGunType(String gunType) {
        double rangeMultiplier = SoundConfig.getRangeMultiplier(gunType);
        return rangeMultiplier >= 6.0;
    }

    private void updateNavigation() {
        if (ReactToGeneralSoundGoal.lastPrioritySoundPos != null && System.currentTimeMillis() - ReactToGeneralSoundGoal.lastPrioritySoundTimestamp > 3000L) {
            ReactToGeneralSoundGoal.lastPrioritySoundPos = null;
        }
        this.checkForPrioritySounds();
        Vec3 currentPos = this.mob.m_20182_();
        Vec3 target = null;
        double effectiveRange = this.baseRange;
        double effectiveSpeed = this.baseSpeed;
        if (ReactToGeneralSoundGoal.lastPrioritySoundPos != null) {
            effectiveRange = this.baseRange * 1.5;
            effectiveSpeed = this.baseSpeed * 1.3;
            if (this.mob.m_9236_().m_46471_() || this.mob.m_9236_().m_46470_()) {
                effectiveRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
            }
            if (currentPos.m_82554_(ReactToGeneralSoundGoal.lastPrioritySoundPos) <= effectiveRange) {
                if (this.mob instanceof Monster) {
                    target = this.grounded(ReactToGeneralSoundGoal.lastPrioritySoundPos);
                } else {
                    Vec3 directionAway = currentPos.m_82546_(ReactToGeneralSoundGoal.lastPrioritySoundPos).m_82541_();
                    target = this.grounded(currentPos.m_82549_(directionAway.m_82490_(effectiveRange)));
                }
                if (target != null) {
                    this.mob.m_21573_().m_26519_(target.f_82479_, target.f_82480_, target.f_82481_, effectiveSpeed);
                    if (currentPos.m_82554_(ReactToGeneralSoundGoal.lastPrioritySoundPos) < 2.0) {
                        ReactToGeneralSoundGoal.lastPrioritySoundPos = null;
                    }
                }
                return;
            }
        }
        if (ReactToGeneralSoundGoal.lastPrioritySoundPos == null) {
            String effectiveGunType = null;
            GunshotData gunshotData = GunFireListener.getLastGunshotData();
            if (gunshotData != null) {
                effectiveGunType = gunshotData.gunType().name().toLowerCase();
            }
            if (effectiveGunType != null) {
                double rangeMultiplier = SoundConfig.getRangeMultiplier(effectiveGunType);
                double speedMultiplier = SoundConfig.getSpeedMultiplier(effectiveGunType);
                effectiveRange = this.baseRange * rangeMultiplier;
                effectiveSpeed = this.baseSpeed * speedMultiplier;
            }
            if (this.mob.m_9236_().m_46471_() || this.mob.m_9236_().m_46470_()) {
                effectiveRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
            }
            if (this.mob instanceof Monster) {
                if (gunshotData != null && currentPos.m_82554_(gunshotData.position()) <= effectiveRange) {
                    target = this.grounded(gunshotData.position());
                }
                if (target != null) {
                    this.mob.m_21573_().m_26519_(target.f_82479_, target.f_82480_, target.f_82481_, effectiveSpeed);
                }
            } else if (gunshotData != null && currentPos.m_82554_(gunshotData.position()) <= effectiveRange) {
                Vec3 directionAway = currentPos.m_82546_(gunshotData.position()).m_82541_();
                Vec3 fleeTarget = this.grounded(currentPos.m_82549_(directionAway.m_82490_(effectiveRange)));
                this.mob.m_21573_().m_26519_(fleeTarget.f_82479_, fleeTarget.f_82480_, fleeTarget.f_82481_, effectiveSpeed);
            }
        }
    }

    private Vec3 grounded(Vec3 desiredXZ) {
        BlockPos base = BlockPos.m_274561_((double)desiredXZ.f_82479_, (double)0.0, (double)desiredXZ.f_82481_);
        BlockPos top = this.mob.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, base);
        return new Vec3((double)top.m_123341_() + 0.5, (double)top.m_123342_(), (double)top.m_123343_() + 0.5);
    }

    private ResourceLocation toLocation(String soundStr) {
        if (soundStr.contains(":")) {
            return ResourceLocation.parse((String)soundStr);
        }
        return ResourceLocation.withDefaultNamespace((String)soundStr);
    }
}

