/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.mixins;

import com.armilp.ezvcsurvival.Plugin;
import com.armilp.ezvcsurvival.config.EntityVoiceConfig;
import com.armilp.ezvcsurvival.config.VoiceConfig;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class})
public abstract class MobTargetMixin {
    @Unique
    private boolean ezvcsurvival$isSpeedBoosted = false;
    @Unique
    private static final UUID VOICE_SPEED_MODIFIER_UUID = UUID.fromString("7E0292F2-9434-48D5-BE13-93E4BA5B5178");
    @Unique
    private double ezvcsurvival$originalSpeed = -1.0;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void ezvcsurvival$checkTargetAndVoice(CallbackInfo ci) {
        block6: {
            Mob mob = (Mob)this;
            if (mob.m_9236_().f_46443_) {
                return;
            }
            if (!EntityVoiceConfig.isEnabled() || !((Boolean)VoiceConfig.MOB_SPEED_BOOST_ENABLED.get()).booleanValue()) {
                this.ezvcsurvival$removeSpeedBoost(mob);
                return;
            }
            try {
                LivingEntity livingEntity = mob.m_5448_();
                if (livingEntity instanceof Player) {
                    Player targetPlayer = (Player)livingEntity;
                    this.ezvcsurvival$handleTargetedPlayer(mob, targetPlayer);
                } else {
                    this.ezvcsurvival$removeSpeedBoost(mob);
                }
            }
            catch (Exception e) {
                if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block6;
                System.err.println("[EZVCSurvival] Error in target voice check: " + e.getMessage());
            }
        }
    }

    @Unique
    private void ezvcsurvival$handleTargetedPlayer(Mob mob, Player targetPlayer) {
        ResourceLocation mobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        String mobIdString = mobId.toString();
        double speedFromConfig = this.ezvcsurvival$getSpeedFromConfig(mobIdString);
        if (speedFromConfig == -1.0) {
            return;
        }
        boolean playerIsSpeaking = this.ezvcsurvival$isPlayerCurrentlySpeaking(targetPlayer);
        if (playerIsSpeaking && !this.ezvcsurvival$isSpeedBoosted) {
            this.ezvcsurvival$applySpeedBoost(mob, mobIdString, speedFromConfig);
        } else if (!playerIsSpeaking && this.ezvcsurvival$isSpeedBoosted) {
            this.ezvcsurvival$removeSpeedBoost(mob);
        }
    }

    @Unique
    private boolean ezvcsurvival$isPlayerCurrentlySpeaking(Player player) {
        return Plugin.getLastSoundLocation(player.m_20183_(), 64.0, -20.0) != null;
    }

    @Unique
    private double ezvcsurvival$getSpeedFromConfig(String mobIdString) {
        EntityVoiceConfig.EntityConfig cfg = EntityVoiceConfig.getMonster(mobIdString);
        if (cfg == null) {
            cfg = EntityVoiceConfig.getAnimal(mobIdString);
        }
        if (cfg != null && cfg.enabled) {
            return cfg.speed;
        }
        return -1.0;
    }

    @Unique
    private void ezvcsurvival$applySpeedBoost(Mob mob, String mobIdString, double speedFromConfig) {
        if (this.ezvcsurvival$originalSpeed == -1.0) {
            this.ezvcsurvival$originalSpeed = mob.m_21133_(Attributes.f_22279_);
        }
        if (mob.m_21051_(Attributes.f_22279_) == null) {
            return;
        }
        mob.m_21051_(Attributes.f_22279_).m_22120_(VOICE_SPEED_MODIFIER_UUID);
        double boostAmount = this.ezvcsurvival$originalSpeed * speedFromConfig * 0.5;
        AttributeModifier speedModifier = new AttributeModifier(VOICE_SPEED_MODIFIER_UUID, "Voice targeting speed boost", boostAmount, AttributeModifier.Operation.ADDITION);
        if (mob.m_21051_(Attributes.f_22279_) == null) {
            return;
        }
        mob.m_21051_(Attributes.f_22279_).m_22125_(speedModifier);
        this.ezvcsurvival$isSpeedBoosted = true;
        if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
            System.out.println("[EZVCSurvival] Applied speed boost to " + mobIdString + " targeting speaking player. Original: " + this.ezvcsurvival$originalSpeed + " Config Speed: " + speedFromConfig + " Boost: +" + boostAmount);
        }
    }

    @Unique
    private void ezvcsurvival$removeSpeedBoost(Mob mob) {
        if (!this.ezvcsurvival$isSpeedBoosted) {
            return;
        }
        if (mob.m_21051_(Attributes.f_22279_) == null) {
            return;
        }
        mob.m_21051_(Attributes.f_22279_).m_22120_(VOICE_SPEED_MODIFIER_UUID);
        this.ezvcsurvival$isSpeedBoosted = false;
        if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
            ResourceLocation mobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
            System.out.println("[EZVCSurvival] Removed speed boost from " + mobId.toString());
        }
    }
}

