/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.network;

import com.armilp.ezvcsurvival.config.EntityVoiceConfig;
import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.config.GunfireConfig;
import com.armilp.ezvcsurvival.config.SoundConfig;
import com.armilp.ezvcsurvival.config.VoiceConfig;
import com.armilp.ezvcsurvival.util.IGoalRefresher;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class UpdateConfigPacket {
    private final ConfigType configType;
    private final String targetId;
    private final boolean enabled;
    private final double value1;
    private final double value2;
    private final double value3;
    private final boolean boolValue;

    public UpdateConfigPacket(String entityId, boolean enabled, double speed, double range, double threshold) {
        this.configType = ConfigType.ENTITY_VOICE;
        this.targetId = entityId;
        this.enabled = enabled;
        this.value1 = speed;
        this.value2 = range;
        this.value3 = threshold;
        this.boolValue = false;
    }

    public UpdateConfigPacket(ConfigType type, String soundId, boolean enabled, double speedMultiplier, double rangeMultiplier) {
        this.configType = type;
        this.targetId = soundId;
        this.enabled = enabled;
        this.value1 = speedMultiplier;
        this.value2 = rangeMultiplier;
        this.value3 = 0.0;
        this.boolValue = false;
    }

    public UpdateConfigPacket(String entityId, boolean enabled, double speed, double range) {
        this.configType = ConfigType.GUNFIRE_ENTITY;
        this.targetId = entityId;
        this.enabled = enabled;
        this.value1 = speed;
        this.value2 = range;
        this.value3 = 0.0;
        this.boolValue = false;
    }

    public UpdateConfigPacket(ConfigType type, String soundId, boolean enabled, double speedMultiplier, double rangeMultiplier, boolean isPriority) {
        this.configType = type;
        this.targetId = soundId;
        this.enabled = enabled;
        this.value1 = speedMultiplier;
        this.value2 = rangeMultiplier;
        this.value3 = 0.0;
        this.boolValue = isPriority;
    }

    public static void encode(UpdateConfigPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.configType.getId());
        buf.m_130070_(msg.targetId);
        buf.writeBoolean(msg.enabled);
        buf.writeDouble(msg.value1);
        buf.writeDouble(msg.value2);
        buf.writeDouble(msg.value3);
        buf.writeBoolean(msg.boolValue);
    }

    public static UpdateConfigPacket decode(FriendlyByteBuf buf) {
        ConfigType type = ConfigType.fromId(buf.readInt());
        String targetId = buf.m_130277_();
        boolean enabled = buf.readBoolean();
        double value1 = buf.readDouble();
        double value2 = buf.readDouble();
        double value3 = buf.readDouble();
        boolean boolValue = buf.readBoolean();
        switch (type) {
            case ENTITY_VOICE: {
                return new UpdateConfigPacket(targetId, enabled, value1, value2, value3);
            }
            case GENERAL_SOUND: {
                return new UpdateConfigPacket(ConfigType.GENERAL_SOUND, targetId, enabled, value1, value2, boolValue);
            }
            case GUNFIRE_SOUND: {
                return new UpdateConfigPacket(ConfigType.GUNFIRE_SOUND, targetId, enabled, value1, value2);
            }
            case GUNFIRE_ENTITY: {
                return new UpdateConfigPacket(targetId, enabled, value1, value2);
            }
            case GENERAL_SOUND_ENTITY: {
                return new UpdateConfigPacket(ConfigType.GENERAL_SOUND_ENTITY, targetId, enabled, value1, value2);
            }
            case SOUND_PRIORITY: {
                return new UpdateConfigPacket(ConfigType.SOUND_PRIORITY, targetId, enabled, value1, value2, boolValue);
            }
        }
        return new UpdateConfigPacket(targetId, enabled, value1, value2, value3);
    }

    public static void handle(UpdateConfigPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            boolean configChanged = false;
            if ("global".equals(msg.targetId)) {
                UpdateConfigPacket.handleGlobalConfigChange(msg);
                configChanged = true;
            } else if ("refresh".equals(msg.targetId)) {
                UpdateConfigPacket.handleRefreshRequest(msg);
                configChanged = true;
            } else {
                switch (msg.configType) {
                    case ENTITY_VOICE: {
                        UpdateConfigPacket.handleEntityVoiceConfig(msg);
                        configChanged = true;
                        break;
                    }
                    case GENERAL_SOUND: {
                        UpdateConfigPacket.handleGeneralSoundConfig(msg);
                        configChanged = true;
                        break;
                    }
                    case GUNFIRE_SOUND: {
                        UpdateConfigPacket.handleGunfireSoundConfig(msg);
                        configChanged = true;
                        break;
                    }
                    case GUNFIRE_ENTITY: {
                        UpdateConfigPacket.handleGunfireEntityConfig(msg);
                        configChanged = true;
                        break;
                    }
                    case GENERAL_SOUND_ENTITY: {
                        UpdateConfigPacket.handleGeneralSoundEntityConfig(msg);
                        configChanged = true;
                        break;
                    }
                    case SOUND_PRIORITY: {
                        UpdateConfigPacket.handleSoundPriorityConfig(msg);
                        configChanged = true;
                    }
                }
            }
            if (configChanged) {
                block22: {
                    try {
                        switch (msg.configType) {
                            case ENTITY_VOICE: {
                                EntityVoiceConfig.init();
                                break;
                            }
                            case GENERAL_SOUND: 
                            case GENERAL_SOUND_ENTITY: 
                            case SOUND_PRIORITY: {
                                GeneralSoundsConfig.init();
                                break;
                            }
                            case GUNFIRE_SOUND: 
                            case GUNFIRE_ENTITY: {
                                GunfireConfig.init();
                            }
                        }
                        SoundConfig.loadConfigs();
                        if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
                            System.out.println("[EZVCSurvival] Configurations reloaded successfully after update: " + msg.configType + " - " + msg.targetId);
                        }
                    }
                    catch (Exception e) {
                        if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block22;
                        System.err.println("[EZVCSurvival] Error reloading configurations after update: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
                UpdateConfigPacket.refreshAllEntityGoals();
                if (msg.configType == ConfigType.ENTITY_VOICE || msg.configType == ConfigType.GUNFIRE_ENTITY || msg.configType == ConfigType.GENERAL_SOUND_ENTITY || msg.configType == ConfigType.SOUND_PRIORITY) {
                    UpdateConfigPacket.refreshSpecificEntityGoals(msg.targetId);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void handleEntityVoiceConfig(UpdateConfigPacket msg) {
        boolean verificationPassed;
        EntityVoiceConfig.EntityConfig newConfig = new EntityVoiceConfig.EntityConfig(msg.enabled, msg.value1, msg.value2, msg.value3);
        EntityVoiceConfig.set(msg.targetId, newConfig);
        EntityVoiceConfig.persist();
        EntityVoiceConfig.EntityConfig updated = EntityVoiceConfig.get(msg.targetId);
        boolean bl = verificationPassed = updated != null && updated.enabled == msg.enabled && Math.abs(updated.speed - msg.value1) < 0.001 && Math.abs(updated.range - msg.value2) < 0.001 && Math.abs(updated.threshold - msg.value3) < 0.001;
        if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
            System.out.println("[EZVCSurvival] Server updated EntityVoice config for: " + msg.targetId + " enabled=" + msg.enabled + " speed=" + msg.value1 + " range=" + msg.value2 + " threshold=" + msg.value3 + " verification=" + verificationPassed);
        }
    }

    private static void handleGeneralSoundConfig(UpdateConfigPacket msg) {
        boolean verificationPassed;
        if (GeneralSoundsConfig.ROOT == null) {
            GeneralSoundsConfig.ROOT = new GeneralSoundsConfig.Root();
        }
        if (GeneralSoundsConfig.ROOT.sounds == null) {
            GeneralSoundsConfig.ROOT.sounds = new HashMap<String, GeneralSoundsConfig.SoundEntry>();
        }
        GeneralSoundsConfig.setSoundEntry(msg.targetId, msg.enabled, msg.value1, msg.value2, msg.boolValue);
        GeneralSoundsConfig.persist();
        GeneralSoundsConfig.SoundEntry updated = GeneralSoundsConfig.getSounds().get(msg.targetId);
        boolean bl = verificationPassed = updated != null && updated.enabled == msg.enabled && Math.abs(updated.speed_multiplier - msg.value1) < 0.001 && Math.abs(updated.range_multiplier - msg.value2) < 0.001 && updated.is_priority == msg.boolValue;
        if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
            System.out.println("[EZVCSurvival] Server updated GeneralSound config for: " + msg.targetId + " enabled=" + msg.enabled + " speed=" + msg.value1 + " range=" + msg.value2 + " isPriority=" + msg.boolValue + " verification=" + verificationPassed);
        }
    }

    private static void handleGeneralSoundEntityConfig(UpdateConfigPacket msg) {
        boolean verificationPassed;
        if (GeneralSoundsConfig.ROOT == null) {
            GeneralSoundsConfig.ROOT = new GeneralSoundsConfig.Root();
        }
        if (GeneralSoundsConfig.ROOT.mobs == null) {
            GeneralSoundsConfig.ROOT.mobs = new HashMap<String, GeneralSoundsConfig.Reaction>();
        }
        GeneralSoundsConfig.setMobReaction(msg.targetId, msg.enabled, msg.value1, msg.value2);
        GeneralSoundsConfig.persist();
        GeneralSoundsConfig.Reaction updated = GeneralSoundsConfig.getMobReactions().get(msg.targetId);
        boolean bl = verificationPassed = updated != null && updated.enabled == msg.enabled && Math.abs(updated.speed - msg.value1) < 0.001 && Math.abs(updated.range - msg.value2) < 0.001;
        if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
            System.out.println("[EZVCSurvival] Server updated GeneralSound entity config for: " + msg.targetId + " enabled=" + msg.enabled + " speed=" + msg.value1 + " range=" + msg.value2 + " verification=" + verificationPassed);
        }
    }

    private static void handleGunfireSoundConfig(UpdateConfigPacket msg) {
        if (GunfireConfig.ROOT == null) {
            GunfireConfig.ROOT = new GunfireConfig.Root();
        }
        GunfireConfig.ROOT.enabled = msg.enabled;
        GunfireConfig.persist();
        if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
            System.out.println("[EZVCSurvival] Server updated Gunfire global config: enabled=" + msg.enabled);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void handleSoundPriorityConfig(UpdateConfigPacket msg) {
        if (GeneralSoundsConfig.ROOT == null) {
            GeneralSoundsConfig.ROOT = new GeneralSoundsConfig.Root();
        }
        if (GeneralSoundsConfig.ROOT.sounds == null) {
            GeneralSoundsConfig.ROOT.sounds = new HashMap<String, GeneralSoundsConfig.SoundEntry>();
        }
        if ((soundEntry = GeneralSoundsConfig.getSounds().get(msg.targetId)) != null) {
            soundEntry.is_priority = msg.boolValue;
            if (msg.value1 != 0.0) {
                soundEntry.speed_multiplier = msg.value1;
            }
            if (msg.value2 != 0.0) {
                soundEntry.range_multiplier = msg.value2;
            }
        } else {
            GeneralSoundsConfig.setSoundEntry(msg.targetId, msg.enabled, msg.value1 != 0.0 ? msg.value1 : 1.0, msg.value2 != 0.0 ? msg.value2 : 1.0, msg.boolValue);
        }
        GeneralSoundsConfig.persist();
        updated = GeneralSoundsConfig.getSounds().get(msg.targetId);
        if (updated == null || updated.is_priority != msg.boolValue) ** GOTO lbl-1000
        v0 = updated.speed_multiplier;
        v1 = msg.value1 != 0.0 ? msg.value1 : updated.speed_multiplier;
        if (!(Math.abs(v0 - v1) < 0.001)) ** GOTO lbl-1000
        v2 = updated.range_multiplier;
        v3 = msg.value2 != 0.0 ? msg.value2 : updated.range_multiplier;
        if (Math.abs(v2 - v3) < 0.001) {
            v4 = true;
        } else lbl-1000:
        // 3 sources

        {
            v4 = verificationPassed = false;
        }
        if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
            System.out.println("[EZVCSurvival] Server updated Sound Priority for: " + msg.targetId + " isPriority=" + msg.boolValue + " speed=" + msg.value1 + " range=" + msg.value2 + " verification=" + verificationPassed);
        }
    }

    private static void handleGunfireEntityConfig(UpdateConfigPacket msg) {
        boolean verificationPassed;
        GunfireConfig.setMobReaction(msg.targetId, msg.enabled, msg.value1, msg.value2);
        GunfireConfig.persist();
        GunfireConfig.Reaction updated = GunfireConfig.getMobReactions().get(msg.targetId);
        boolean bl = verificationPassed = updated != null && updated.enabled == msg.enabled && Math.abs(updated.speed - msg.value1) < 0.001 && Math.abs(updated.range - msg.value2) < 0.001;
        if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
            System.out.println("[EZVCSurvival] Server updated Gunfire entity config for: " + msg.targetId + " enabled=" + msg.enabled + " speed=" + msg.value1 + " range=" + msg.value2 + " verification=" + verificationPassed);
        }
    }

    private static void handleGlobalConfigChange(UpdateConfigPacket msg) {
        switch (msg.configType) {
            case ENTITY_VOICE: {
                if (EntityVoiceConfig.ROOT == null) {
                    EntityVoiceConfig.ROOT = new EntityVoiceConfig.RootConfig();
                }
                EntityVoiceConfig.ROOT.enabled = msg.enabled;
                EntityVoiceConfig.persist();
                if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break;
                System.out.println("[EZVCSurvival] Server updated EntityVoice global config: enabled=" + msg.enabled);
                break;
            }
            case GENERAL_SOUND: {
                if (GeneralSoundsConfig.ROOT == null) {
                    GeneralSoundsConfig.ROOT = new GeneralSoundsConfig.Root();
                }
                GeneralSoundsConfig.ROOT.enabled = msg.enabled;
                GeneralSoundsConfig.persist();
                if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break;
                System.out.println("[EZVCSurvival] Server updated GeneralSound global config: enabled=" + msg.enabled);
                break;
            }
            case SOUND_PRIORITY: {
                GeneralSoundsConfig.enableAllPrioritySounds(msg.enabled);
                if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break;
                System.out.println("[EZVCSurvival] Server updated Sound Priority global config: enabled=" + msg.enabled);
                break;
            }
            case GUNFIRE_SOUND: {
                if (GunfireConfig.ROOT == null) {
                    GunfireConfig.ROOT = new GunfireConfig.Root();
                }
                GunfireConfig.ROOT.enabled = msg.enabled;
                GunfireConfig.persist();
                if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break;
                System.out.println("[EZVCSurvival] Server updated Gunfire global config: enabled=" + msg.enabled);
            }
        }
    }

    private static void handleRefreshRequest(UpdateConfigPacket msg) {
        block2: {
            try {
                GeneralSoundsConfig.init();
                GunfireConfig.init();
                EntityVoiceConfig.init();
                SoundConfig.loadConfigs();
            }
            catch (Exception e) {
                if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block2;
                System.err.println("[EZVCSurvival] Error refreshing configs: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private static void refreshAllEntityGoals() {
        block9: {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            try {
                for (ServerLevel level : server.m_129785_()) {
                    Iterable allEntities = level.m_8583_();
                    for (Entity e : allEntities) {
                        Mob mob;
                        if (!(e instanceof Mob) || !((mob = (Mob)e) instanceof IGoalRefresher)) continue;
                        IGoalRefresher refresher = (IGoalRefresher)mob;
                        try {
                            refresher.ezvcsurvival$RefreshGoals();
                        }
                        catch (Exception ex) {
                            if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) continue;
                            ex.printStackTrace();
                        }
                    }
                }
            }
            catch (NoSuchMethodError nsme) {
                if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
                    System.err.println("[EZVCSurvival] update packet: level.getAllEntities() does not exist in this mapping.");
                    nsme.printStackTrace();
                }
            }
            catch (Exception e) {
                if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block9;
                System.err.println("[EZVCSurvival] Error to refresh goals: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private static void refreshSpecificEntityGoals(String entityId) {
        block9: {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            try {
                for (ServerLevel level : server.m_129785_()) {
                    Iterable allEntities = level.m_8583_();
                    for (Entity e : allEntities) {
                        Mob mob;
                        ResourceLocation mobId;
                        if (!(e instanceof Mob) || (mobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)(mob = (Mob)e).m_6095_())) == null || !mobId.toString().equals(entityId) || !(mob instanceof IGoalRefresher)) continue;
                        IGoalRefresher refresher = (IGoalRefresher)mob;
                        try {
                            refresher.ezvcsurvival$RefreshGoals();
                        }
                        catch (Exception ex) {
                            if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) continue;
                            ex.printStackTrace();
                        }
                    }
                }
            }
            catch (NoSuchMethodError nsme) {
                if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
                    System.err.println("[EZVCSurvival] update packet: level.getAllEntities() does not exist in this mapping.");
                    nsme.printStackTrace();
                }
            }
            catch (Exception e) {
                if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block9;
                System.err.println("[EZVCSurvival] Error to refresh goals: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static enum ConfigType {
        ENTITY_VOICE(0),
        GENERAL_SOUND(1),
        GUNFIRE_SOUND(2),
        GUNFIRE_ENTITY(3),
        GENERAL_SOUND_ENTITY(4),
        SOUND_PRIORITY(5);

        private final int id;

        private ConfigType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static ConfigType fromId(int id) {
            for (ConfigType type : ConfigType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return ENTITY_VOICE;
        }
    }
}

