/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.config;

import com.armilp.ezvcsurvival.EZVCSurvival;
import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.data.SoundGroupData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="ezvcsurvival", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SoundConfig {
    public static final ForgeConfigSpec.DoubleValue THUNDER_RANGE_MULTIPLIER;
    private static final List<SoundGroupData> priorityGroups;
    private static final List<SoundGroupData> customSoundGroups;
    public static final ForgeConfigSpec SPEC;

    @SubscribeEvent
    public static void onModConfigLoading(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == SPEC) {
            EZVCSurvival.LOGGER.info("Loading EZVCSurvival configuration...");
            SoundConfig.loadConfigs();
        }
    }

    @SubscribeEvent
    public static void onModConfigReloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SPEC) {
            EZVCSurvival.LOGGER.info("Reloading EZVCSurvival configuration...");
            SoundConfig.loadConfigs();
        }
    }

    public static void loadConfigs() {
        try {
            GeneralSoundsConfig.init();
            SoundConfig.mergeGeneralSoundsFromJson();
            SoundConfig.refreshPriorityGroups();
        }
        catch (Exception e) {
            EZVCSurvival.LOGGER.warn("Error loading JSON sound configs: {}", (Object)e.getMessage());
        }
    }

    private static void refreshPriorityGroups() {
        priorityGroups.clear();
        GeneralSoundsConfig.processPrioritySounds(priorityGroups);
    }

    private static void mergeGeneralSoundsFromJson() {
        customSoundGroups.removeIf(g -> g.groupName.startsWith("auto_sound_"));
        Map<String, GeneralSoundsConfig.SoundEntry> sounds = GeneralSoundsConfig.getSounds();
        if (sounds != null) {
            for (Map.Entry<String, GeneralSoundsConfig.SoundEntry> e : sounds.entrySet()) {
                GeneralSoundsConfig.SoundEntry se = e.getValue();
                customSoundGroups.add(new SoundGroupData("auto_sound_" + e.getKey().replace(':', '_').replace('.', '_'), List.of(e.getKey()), se.speed_multiplier, se.range_multiplier));
            }
        }
    }

    public static List<SoundGroupData> getEnabledSoundGroups() {
        return Collections.unmodifiableList(customSoundGroups);
    }

    public static List<SoundGroupData> getPriorityGroups() {
        return Collections.unmodifiableList(priorityGroups);
    }

    static {
        priorityGroups = new ArrayList<SoundGroupData>();
        customSoundGroups = new ArrayList<SoundGroupData>();
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("weather");
        THUNDER_RANGE_MULTIPLIER = builder.defineInRange("thunder_range_multiplier", 0.8, 0.0, 1.0);
        builder.pop();
        SPEC = builder.build();
    }
}

