/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.events;

import com.armilp.ezvcsurvival.config.EntityVoiceConfig;
import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.config.SoundConfig;
import com.armilp.ezvcsurvival.config.VoiceConfig;
import com.armilp.ezvcsurvival.data.SoundGroupData;
import com.armilp.ezvcsurvival.goals.FollowVoiceGoal;
import com.armilp.ezvcsurvival.goals.ReactToGeneralSoundGoal;
import com.armilp.ezvcsurvival.goals.RunawayVoiceGoal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MobGoalInjector {
    private static final String TAG = "ezvcsurvival:goals_added";
    private static final Set<Mob> TRACKED_MOBS = Collections.newSetFromMap(new WeakHashMap());
    private static final Map<UUID, InjectedGoals> INJECTED_GOALS = new WeakHashMap<UUID, InjectedGoals>();

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        block9: {
            Entity entity = event.getEntity();
            if (!(entity instanceof Mob)) {
                return;
            }
            Mob mob = (Mob)entity;
            Level level = event.getLevel();
            if (level.isClientSide) {
                return;
            }
            if (mob.isRemoved()) {
                return;
            }
            try {
                if (!MobGoalInjector.hasActiveGoals(mob)) {
                    MobGoalInjector.injectGoals(mob);
                    CompoundTag data = mob.getPersistentData();
                    data.putBoolean(TAG, true);
                    TRACKED_MOBS.add(mob);
                    if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
                        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.getType());
                        System.out.println("[EZVCSurvival] Injected goals into: " + String.valueOf(id != null ? id : "unknown") + " (UUID=" + String.valueOf(mob.getUUID()) + ")");
                    }
                } else {
                    TRACKED_MOBS.add(mob);
                    if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
                        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.getType());
                        System.out.println("[EZVCSurvival] Goals already present for: " + String.valueOf(id != null ? id : "unknown") + " (UUID=" + String.valueOf(mob.getUUID()) + ")");
                    }
                }
            }
            catch (Exception e) {
                if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block9;
                System.err.println("[EZVCSurvival] Error injecting goals on join: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private static boolean hasActiveGoals(Mob mob) {
        InjectedGoals injected = INJECTED_GOALS.get(mob.getUUID());
        if (injected != null && injected.hasAnyGoal()) {
            return MobGoalInjector.verifyGoalsInSelector(mob, injected);
        }
        return false;
    }

    private static boolean verifyGoalsInSelector(Mob mob, InjectedGoals injected) {
        Set availableGoals = mob.goalSelector.getAvailableGoals();
        boolean hasFollowGoal = injected.followGoal == null || availableGoals.stream().anyMatch(wg -> wg.getGoal() == injected.followGoal);
        boolean hasRunawayGoal = injected.runawayGoal == null || availableGoals.stream().anyMatch(wg -> wg.getGoal() == injected.runawayGoal);
        boolean hasGeneralSoundGoal = injected.generalSoundGoal == null || availableGoals.stream().anyMatch(wg -> wg.getGoal() == injected.generalSoundGoal);
        return hasFollowGoal && hasRunawayGoal && hasGeneralSoundGoal;
    }

    public static void refreshAll() {
        Iterator<Mob> it = TRACKED_MOBS.iterator();
        while (it.hasNext()) {
            Mob mob = it.next();
            if (mob == null || mob.isRemoved()) {
                it.remove();
                continue;
            }
            MobGoalInjector.refreshMob(mob);
        }
    }

    public static void refreshEntityId(String entityId) {
        for (Mob mob : new ArrayList<Mob>(TRACKED_MOBS)) {
            ResourceLocation id;
            if (mob == null || mob.isRemoved() || (id = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.getType())) == null || !id.toString().equals(entityId)) continue;
            MobGoalInjector.refreshMob(mob);
        }
    }

    private static void refreshMob(Mob mob) {
        block4: {
            if (mob == null || mob.isRemoved()) {
                return;
            }
            try {
                MobGoalInjector.cleanupOldGoals(mob);
                MobGoalInjector.injectGoals(mob);
                if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
                    ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.getType());
                    System.out.println("[EZVCSurvival] Refreshed goals for: " + String.valueOf(id != null ? id : "unknown") + " (UUID=" + String.valueOf(mob.getUUID()) + ")");
                }
            }
            catch (Exception e) {
                if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block4;
                System.err.println("[EZVCSurvival] Error refreshing goals: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private static void injectGoals(Mob mob) {
        if (mob == null || mob.isRemoved()) {
            return;
        }
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.getType());
        if (id == null) {
            return;
        }
        String mobId = id.toString();
        InjectedGoals injectedGoals = new InjectedGoals();
        boolean isAnimal = mob instanceof Animal;
        if (EntityVoiceConfig.isEnabled()) {
            if (!isAnimal) {
                injectedGoals.followGoal = MobGoalInjector.injectFollowVoiceGoal(mob, mobId);
            } else {
                injectedGoals.runawayGoal = MobGoalInjector.injectRunawayVoiceGoal((Animal)mob, mobId);
            }
        }
        if (GeneralSoundsConfig.isEnabled()) {
            injectedGoals.generalSoundGoal = MobGoalInjector.injectGeneralSoundGoal(mob, mobId);
        }
        INJECTED_GOALS.put(mob.getUUID(), injectedGoals);
    }

    private static Goal injectFollowVoiceGoal(Mob mob, String mobId) {
        block3: {
            try {
                EntityVoiceConfig.EntityConfig cfg = EntityVoiceConfig.getMonster(mobId);
                if (cfg != null && cfg.enabled && cfg.speed > 0.0 && cfg.range > 0.0) {
                    FollowVoiceGoal goal = new FollowVoiceGoal(mob, cfg.speed, (int)cfg.range, cfg.threshold, 10000L);
                    mob.goalSelector.addGoal(0, (Goal)goal);
                    return goal;
                }
            }
            catch (Exception e) {
                if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block3;
                System.err.println("[EZVCSurvival] Failed to inject FollowVoiceGoal for " + mobId + ": " + e.getMessage());
            }
        }
        return null;
    }

    private static Goal injectRunawayVoiceGoal(Animal animal, String mobId) {
        block3: {
            try {
                EntityVoiceConfig.EntityConfig cfg = EntityVoiceConfig.getAnimal(mobId);
                if (cfg != null && cfg.enabled && cfg.speed > 0.0 && cfg.range > 0.0) {
                    RunawayVoiceGoal goal = new RunawayVoiceGoal(animal, cfg.speed, (int)cfg.range, cfg.threshold);
                    animal.goalSelector.addGoal(4, (Goal)goal);
                    return goal;
                }
            }
            catch (Exception e) {
                if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block3;
                System.err.println("[EZVCSurvival] Failed to inject RunawayVoiceGoal for " + mobId + ": " + e.getMessage());
            }
        }
        return null;
    }

    private static Goal injectGeneralSoundGoal(Mob mob, String mobId) {
        block3: {
            try {
                List<SoundGroupData> groups;
                GeneralSoundsConfig.Reaction r = GeneralSoundsConfig.getMobReactions().get(mobId);
                if (r != null && r.enabled && r.speed > 0.0 && r.range > 0.0 && !(groups = SoundConfig.getEnabledSoundGroups()).isEmpty()) {
                    ReactToGeneralSoundGoal goal = new ReactToGeneralSoundGoal(mob, r.speed, (int)r.range, groups);
                    mob.goalSelector.addGoal(2, (Goal)goal);
                    return goal;
                }
            }
            catch (Exception e) {
                if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block3;
                System.err.println("[EZVCSurvival] Failed to inject ReactToGeneralSoundGoal for " + mobId + ": " + e.getMessage());
            }
        }
        return null;
    }

    private static void cleanupOldGoals(Mob mob) {
        block3: {
            try {
                InjectedGoals injected = INJECTED_GOALS.get(mob.getUUID());
                if (injected != null) {
                    MobGoalInjector.removeGoal(mob, injected.followGoal);
                    MobGoalInjector.removeGoal(mob, injected.runawayGoal);
                    MobGoalInjector.removeGoal(mob, injected.generalSoundGoal);
                    INJECTED_GOALS.remove(mob.getUUID());
                }
            }
            catch (Exception e) {
                if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block3;
                System.err.println("[EZVCSurvival] Error removing old goals: " + e.getMessage());
            }
        }
    }

    private static void removeGoal(Mob mob, Goal goal) {
        if (goal != null) {
            mob.goalSelector.removeGoal(goal);
        }
    }

    private static class InjectedGoals {
        Goal followGoal;
        Goal runawayGoal;
        Goal generalSoundGoal;

        private InjectedGoals() {
        }

        boolean hasAnyGoal() {
            return this.followGoal != null || this.runawayGoal != null || this.generalSoundGoal != null;
        }
    }
}

