/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.events;

import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.network.EZVCNetwork;
import com.armilp.ezvcsurvival.network.GeneralSoundPacket;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="ezvcsurvival", value={Dist.CLIENT})
public class SoundEventHandler {
    @SubscribeEvent
    public static void onPlaySound(PlaySoundEvent event) {
        SoundInstance soundInstance = event.getSound();
        if (!(soundInstance instanceof SimpleSoundInstance)) {
            return;
        }
        SimpleSoundInstance sound = (SimpleSoundInstance)soundInstance;
        Minecraft mc = Minecraft.getInstance();
        if (mc.getConnection() == null || mc.player == null) {
            return;
        }
        Map<String, GeneralSoundsConfig.SoundEntry> soundMap = GeneralSoundsConfig.getSounds();
        if (soundMap == null) {
            return;
        }
        GeneralSoundsConfig.SoundEntry cfg = soundMap.get(sound.getLocation().toString());
        if (cfg == null || !cfg.enabled) {
            return;
        }
        EZVCNetwork.INSTANCE.send((Object)new GeneralSoundPacket(sound.getLocation(), sound.getX(), sound.getY(), sound.getZ(), cfg.speed_multiplier, cfg.range_multiplier), PacketDistributor.SERVER.noArg());
    }
}

