/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.goals;

import com.armilp.ezvcsurvival.Plugin;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class RunawayVoiceGoal
extends Goal {
    private final Animal mob;
    private final double speedModifier;
    private final double voiceDetectionRange;
    private final double threshold;
    private BlockPos targetSoundPosition;
    private int ambientSoundCount;
    private int distanceCovered = 0;

    public RunawayVoiceGoal(Animal mob, double speedModifier, double detectionRange, double threshold) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.voiceDetectionRange = detectionRange;
        this.threshold = threshold;
        this.ambientSoundCount = 0;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public boolean canUse() {
        this.targetSoundPosition = Plugin.getLastSoundLocation(this.mob.blockPosition(), this.voiceDetectionRange, this.threshold);
        return this.targetSoundPosition != null;
    }

    public boolean canContinueToUse() {
        return this.targetSoundPosition != null && !this.mob.getNavigation().isDone();
    }

    public void start() {
        if (this.targetSoundPosition != null) {
            Vec3 groundedDanger = this.grounded(Vec3.atCenterOf((Vec3i)this.targetSoundPosition));
            this.fleeFrom(groundedDanger);
        }
    }

    public void tick() {
        if (this.targetSoundPosition != null) {
            this.handleSoundThreat();
        }
    }

    public void stop() {
        this.targetSoundPosition = null;
        this.ambientSoundCount = 0;
        this.mob.getNavigation().stop();
    }

    private void handleSoundThreat() {
        ++this.distanceCovered;
        BlockPos groundedPos = this.mob.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.targetSoundPosition);
        double gx = (double)groundedPos.getX() + 0.5;
        double gz = (double)groundedPos.getZ() + 0.5;
        if (this.distanceCovered > 10 && this.distanceCovered % 20 == 0) {
            this.mob.getNavigation().stop();
            this.mob.getLookControl().setLookAt(gx, (double)groundedPos.getY(), gz, 30.0f, 30.0f);
        }
        double dx = this.mob.getX() - gx;
        double dz = this.mob.getZ() - gz;
        double distanceSq2D = dx * dx + dz * dz;
        if (this.targetSoundPosition == null || distanceSq2D > this.threshold * this.threshold) {
            this.targetSoundPosition = Plugin.getLastSoundLocation(this.mob.blockPosition(), this.voiceDetectionRange, this.threshold);
        } else {
            this.fleeFrom(new Vec3(gx, (double)groundedPos.getY(), gz));
        }
    }

    private void fleeFrom(Vec3 dangerPosition) {
        Vec3 fleeDirection = this.mob.position().subtract(dangerPosition).normalize().scale(20.0);
        double randomOffsetX = (this.mob.getRandom().nextDouble() - 0.5) * 5.0;
        double randomOffsetZ = (this.mob.getRandom().nextDouble() - 0.5) * 5.0;
        Vec3 fleeTarget = this.mob.position().add(fleeDirection).add(randomOffsetX, 0.0, randomOffsetZ);
        Vec3 groundedTarget = this.grounded(fleeTarget);
        if (this.isDangerousBlock(BlockPos.containing((Position)groundedTarget))) {
            fleeDirection = fleeDirection.add(this.mob.getRandom().nextDouble() * 5.0, 0.0, this.mob.getRandom().nextDouble() * 5.0);
            fleeTarget = this.mob.position().add(fleeDirection);
            groundedTarget = this.grounded(fleeTarget);
        }
        this.mob.getNavigation().moveTo(groundedTarget.x, groundedTarget.y, groundedTarget.z, this.speedModifier);
        if (this.ambientSoundCount < 2 && this.mob.getRandom().nextDouble() < 0.5) {
            this.mob.playAmbientSound();
            ++this.ambientSoundCount;
        }
    }

    private Vec3 grounded(Vec3 desiredXZ) {
        BlockPos base = BlockPos.containing((double)desiredXZ.x, (double)0.0, (double)desiredXZ.z);
        BlockPos top = this.mob.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, base);
        return new Vec3((double)top.getX() + 0.5, (double)top.getY(), (double)top.getZ() + 0.5);
    }

    private boolean isDangerousBlock(BlockPos pos) {
        ServerLevel level = (ServerLevel)this.mob.level();
        BlockState blockState = level.getBlockState(pos);
        return !blockState.getFluidState().isEmpty() || !blockState.isSolidRender((BlockGetter)level, pos);
    }
}

