/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedfluidcrafting.inventory;

import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.item.ItemGasDrop;
import com.glodblock.github.common.item.ItemGasPacket;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.integration.mek.FakeGases;
import com.glodblock.github.util.ModAndClassUtil;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemHandlerConverting
implements IItemHandler {
    private final IItemHandler itemHandler;
    private final IFluidHandler fluidHandler;
    private final Object gasHandler;
    private final EnumFacing side;

    public ItemHandlerConverting(IItemHandler itemHandler, IFluidHandler fluidHandler, Object gasHandler, EnumFacing side) {
        this.itemHandler = itemHandler;
        this.fluidHandler = fluidHandler;
        this.gasHandler = gasHandler;
        this.side = side;
    }

    public static ItemHandlerConverting wrap(ICapabilityProvider capProvider, EnumFacing side, boolean checkItem, boolean checkFluid, boolean checkGas) {
        Object gasHandler;
        IItemHandler itemHandler = checkItem ? (IItemHandler)capProvider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) : null;
        IFluidHandler fluidHandler = checkFluid ? (IFluidHandler)capProvider.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side) : null;
        Object object = gasHandler = checkGas && ModAndClassUtil.GAS ? capProvider.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, side) : null;
        if (itemHandler == null && fluidHandler == null && gasHandler == null) {
            return null;
        }
        return new ItemHandlerConverting(itemHandler, fluidHandler, gasHandler, side);
    }

    public int getSlots() {
        int slots = 0;
        if (this.itemHandler != null) {
            slots += this.itemHandler.getSlots();
        }
        if (this.fluidHandler != null) {
            slots += this.fluidHandler.getTankProperties().length;
        }
        if (ModAndClassUtil.GAS && this.gasHandler != null) {
            IGasHandler gasHandler = (IGasHandler)this.gasHandler;
            slots += gasHandler.getTankInfo().length;
        }
        return slots;
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.itemHandler != null) {
            if (slot < this.itemHandler.getSlots()) {
                return this.itemHandler.getStackInSlot(slot);
            }
            slot -= this.itemHandler.getSlots();
        }
        if (this.fluidHandler != null) {
            IFluidTankProperties[] tanks = this.fluidHandler.getTankProperties();
            if (slot < tanks.length) {
                return FakeFluids.packFluid2Packet((FluidStack)tanks[slot].getContents());
            }
            slot -= tanks.length;
        }
        if (ModAndClassUtil.GAS && this.gasHandler != null) {
            IGasHandler gasHandler = (IGasHandler)this.gasHandler;
            GasTankInfo[] tanks = gasHandler.getTankInfo();
            if (slot < tanks.length) {
                return FakeGases.packGas2Packet((GasStack)tanks[slot].getGas());
            }
            slot -= tanks.length;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.itemHandler != null) {
            if (slot < this.itemHandler.getSlots()) {
                if (FakeFluids.isFluidFakeItem((ItemStack)stack) || ModAndClassUtil.GAS && FakeGases.isGasFakeItem((ItemStack)stack)) {
                    return stack;
                }
                return this.itemHandler.insertItem(slot, stack, simulate);
            }
            slot -= this.itemHandler.getSlots();
        }
        if (this.fluidHandler != null) {
            IFluidTankProperties[] tanks = this.fluidHandler.getTankProperties();
            if (slot < tanks.length) {
                FluidStack contained;
                if (!FakeFluids.isFluidFakeItem((ItemStack)stack)) {
                    return stack;
                }
                FluidStack toInsert = (FluidStack)FakeItemRegister.getStack((ItemStack)stack);
                if (toInsert != null && toInsert.amount > 0 && ((contained = tanks[slot].getContents()) == null || contained.amount == 0 || contained.isFluidEqual(toInsert))) {
                    int insertable;
                    if (stack.func_77973_b() instanceof ItemFluidDrop) {
                        toInsert.amount = toInsert.amount - this.fluidHandler.fill(toInsert, !simulate);
                        return FakeFluids.packFluid2Drops((FluidStack)toInsert);
                    }
                    if (stack.func_77973_b() instanceof ItemFluidPacket && (insertable = this.fluidHandler.fill(toInsert, false)) >= toInsert.amount) {
                        if (!simulate) {
                            this.fluidHandler.fill(toInsert, true);
                        }
                        return ItemStack.field_190927_a;
                    }
                }
                return stack;
            }
            slot -= tanks.length;
        }
        if (ModAndClassUtil.GAS && this.gasHandler != null) {
            IGasHandler gasHandler = (IGasHandler)this.gasHandler;
            GasTankInfo[] tanks = gasHandler.getTankInfo();
            if (slot < tanks.length && FakeGases.isGasFakeItem((ItemStack)stack)) {
                GasStack contained;
                if (!FakeGases.isGasFakeItem((ItemStack)stack)) {
                    return stack;
                }
                GasStack toInsert = (GasStack)FakeItemRegister.getStack((ItemStack)stack);
                if (toInsert != null && toInsert.amount > 0 && ((contained = tanks[slot].getGas()) == null || contained.amount == 0 || contained.isGasEqual(toInsert))) {
                    int insertable;
                    if (stack.func_77973_b() instanceof ItemGasDrop) {
                        toInsert.amount = toInsert.amount - gasHandler.receiveGas(this.side, toInsert, !simulate);
                        return FakeGases.packGas2Drops((GasStack)toInsert);
                    }
                    if (stack.func_77973_b() instanceof ItemGasPacket && (insertable = gasHandler.receiveGas(this.side, toInsert, false)) >= toInsert.amount) {
                        if (!simulate) {
                            gasHandler.receiveGas(this.side, toInsert, true);
                        }
                        return ItemStack.field_190927_a;
                    }
                }
                return stack;
            }
            slot -= tanks.length;
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.itemHandler != null) {
            if (slot < this.itemHandler.getSlots()) {
                return this.itemHandler.extractItem(slot, amount, simulate);
            }
            slot -= this.itemHandler.getSlots();
        }
        if (this.fluidHandler != null) {
            IFluidTankProperties[] tanks = this.fluidHandler.getTankProperties();
            if (slot < tanks.length) {
                FluidStack contained = tanks[slot].getContents();
                return contained != null && contained.amount > 0 ? FakeFluids.packFluid2Drops((FluidStack)this.fluidHandler.drain(contained, !simulate)) : ItemStack.field_190927_a;
            }
            slot -= tanks.length;
        }
        if (ModAndClassUtil.GAS && this.gasHandler != null) {
            IGasHandler gasHandler = (IGasHandler)this.gasHandler;
            GasTankInfo[] tanks = gasHandler.getTankInfo();
            if (slot < tanks.length) {
                GasStack contained = tanks[slot].getGas();
                if (contained != null && contained.amount > 0) {
                    if (tanks[slot] instanceof GasTank) {
                        return FakeGases.packGas2Drops((GasStack)((GasTank)tanks[slot]).draw(amount, !simulate));
                    }
                    return FakeGases.packGas2Drops((GasStack)gasHandler.drawGas(this.side, amount, !simulate));
                }
                return ItemStack.field_190927_a;
            }
            slot -= tanks.length;
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        if (this.itemHandler != null) {
            if (slot < this.itemHandler.getSlots()) {
                return this.itemHandler.getSlotLimit(slot);
            }
            slot -= this.itemHandler.getSlots();
        }
        if (this.fluidHandler != null) {
            IFluidTankProperties[] tanks = this.fluidHandler.getTankProperties();
            if (slot < tanks.length) {
                return tanks[slot].getCapacity();
            }
            slot -= tanks.length;
        }
        if (ModAndClassUtil.GAS && this.gasHandler != null) {
            IGasHandler gasHandler = (IGasHandler)this.gasHandler;
            GasTankInfo[] tanks = gasHandler.getTankInfo();
            if (slot < tanks.length) {
                return tanks[slot].getMaxGas();
            }
            slot -= tanks.length;
        }
        return 0;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (this.itemHandler != null) {
            if (slot < this.itemHandler.getSlots()) {
                if (FakeFluids.isFluidFakeItem((ItemStack)stack) || ModAndClassUtil.GAS && FakeGases.isGasFakeItem((ItemStack)stack)) {
                    return false;
                }
                return this.itemHandler.isItemValid(slot, stack);
            }
            slot -= this.itemHandler.getSlots();
        }
        if (this.fluidHandler != null) {
            IFluidTankProperties[] tanks = this.fluidHandler.getTankProperties();
            if (slot < tanks.length) {
                return FakeFluids.isFluidFakeItem((ItemStack)stack);
            }
            slot -= tanks.length;
        }
        if (ModAndClassUtil.GAS && this.gasHandler != null) {
            IGasHandler gasHandler = (IGasHandler)this.gasHandler;
            GasTankInfo[] tanks = gasHandler.getTankInfo();
            if (slot < tanks.length) {
                return FakeGases.isGasFakeItem((ItemStack)stack);
            }
            slot -= tanks.length;
        }
        return false;
    }
}

