/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedfluidcrafting.client;

import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class GasRenderer {
    public static final GasRenderer INSTANCE = new GasRenderer(16, 16, 16);
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private final int width;
    private final int height;
    private final int minHeight;

    public GasRenderer(int width, int height, int minHeight) {
        this.width = width;
        this.height = height;
        this.minHeight = minHeight;
    }

    private static TextureAtlasSprite getGasSprite(GasStack gasStack) {
        ResourceLocation icon = gasStack.getGas().getIcon();
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(icon.toString());
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(float xCoord, float yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, float zLevel) {
        float uMin = textureSprite.func_94209_e();
        float uMax = textureSprite.func_94212_f();
        float vMin = textureSprite.func_94206_g();
        float vMax = textureSprite.func_94210_h();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMin += (float)maskTop / 16.0f * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b((double)xCoord, (double)(yCoord + 16.0f), (double)zLevel).func_187315_a((double)uMin, (double)vMax).func_181675_d();
        bufferBuilder.func_181662_b((double)(xCoord + 16.0f - (float)maskRight), (double)(yCoord + 16.0f), (double)zLevel).func_187315_a((double)uMax, (double)vMax).func_181675_d();
        bufferBuilder.func_181662_b((double)(xCoord + 16.0f - (float)maskRight), (double)(yCoord + (float)maskTop), (double)zLevel).func_187315_a((double)uMax, (double)vMin).func_181675_d();
        bufferBuilder.func_181662_b((double)xCoord, (double)(yCoord + (float)maskTop), (double)zLevel).func_187315_a((double)uMin, (double)vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    public void render(int xPosition, int yPosition, GasStack gasStack) {
        this.render(xPosition, yPosition, gasStack, 1000);
    }

    public void render(int xPosition, int yPosition, GasStack gasStack, int capacity) {
        GlStateManager.func_179147_l();
        this.drawGas(xPosition, yPosition, gasStack, capacity);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
    }

    private void drawGas(int xPosition, int yPosition, GasStack gasStack, int capacity) {
        if (capacity <= 0 || gasStack == null) {
            return;
        }
        Gas gas = gasStack.getGas();
        TextureAtlasSprite fluidStillSprite = GasRenderer.getGasSprite(gasStack);
        int gasColor = gas.getTint();
        int amount = gasStack.amount;
        int scaledAmount = amount * this.height / capacity;
        if (amount > 0 && scaledAmount < this.minHeight) {
            scaledAmount = this.minHeight;
        }
        if (scaledAmount > this.height) {
            scaledAmount = this.height;
        }
        this.drawTiledSprite(xPosition, yPosition, this.width, this.height, gasColor, scaledAmount, fluidStillSprite);
    }

    private void drawTiledSprite(int xPosition, int yPosition, int tiledWidth, int tiledHeight, int color, int scaledAmount, TextureAtlasSprite sprite) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GasRenderer.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = yPosition + tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width = xTile == xTileCount ? xRemainder : 16;
                int height = yTile == yTileCount ? yRemainder : 16;
                int x = xPosition + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width <= 0 || height <= 0) continue;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                GasRenderer.drawTextureWithMasking(x, y, sprite, maskTop, maskRight, 100.0f);
            }
        }
    }
}

