/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedfluidcrafting.event;

import com.glodblock.github.util.ModAndClassUtil;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thelm.packagedfluidcrafting.block.BlockFluidPacketEncoder;
import thelm.packagedfluidcrafting.block.BlockGasPacketEncoder;
import thelm.packagedfluidcrafting.config.PackagedFluidCraftingConfig;
import thelm.packagedfluidcrafting.network.PacketHandler;
import thelm.packagedfluidcrafting.tile.TileFluidPacketEncoder;
import thelm.packagedfluidcrafting.tile.TileGasPacketEncoder;

public class CommonEventHandler {
    public void registerBlock(Block block) {
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
    }

    public void registerItem(Item item) {
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
    }

    public void onPreInit(FMLPreInitializationEvent event) {
        this.registerConfig(event);
        this.registerBlocks();
        this.registerItems();
        this.registerTileEntities();
        this.registerNetwork();
    }

    protected void registerConfig(FMLPreInitializationEvent event) {
        PackagedFluidCraftingConfig.init(event.getSuggestedConfigurationFile());
    }

    protected void registerBlocks() {
        this.registerBlock((Block)BlockFluidPacketEncoder.INSTANCE);
        if (ModAndClassUtil.GAS) {
            this.registerBlock((Block)BlockGasPacketEncoder.INSTANCE);
        }
    }

    protected void registerItems() {
        this.registerItem(BlockFluidPacketEncoder.ITEM_INSTANCE);
        if (ModAndClassUtil.GAS) {
            this.registerItem(BlockGasPacketEncoder.ITEM_INSTANCE);
        }
    }

    protected void registerTileEntities() {
        GameRegistry.registerTileEntity(TileFluidPacketEncoder.class, (ResourceLocation)new ResourceLocation("packagedfluidcrafting:fluid_packet_encoder"));
        if (ModAndClassUtil.GAS) {
            GameRegistry.registerTileEntity(TileGasPacketEncoder.class, (ResourceLocation)new ResourceLocation("packagedfluidcrafting:gas_packet_encoder"));
        }
    }

    protected void registerNetwork() {
        PacketHandler.registerPackets();
    }
}

