/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedfluidcrafting.tile;

import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.integration.mek.FakeGases;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.tile.TileBase;
import thelm.packagedauto.tile.TileUnpackager;
import thelm.packagedfluidcrafting.client.gui.GuiGasPacketEncoder;
import thelm.packagedfluidcrafting.container.ContainerGasPacketEncoder;
import thelm.packagedfluidcrafting.inventory.InventoryGasPacketEncoder;

public class TileGasPacketEncoder
extends TileBase
implements ITickable,
ISettingsCloneable {
    public static int energyCapacity = 5000;
    public static int energyReq = 500;
    public static int energyUsage = 100;
    public static int refreshInterval = 4;
    public boolean isWorking = false;
    public GasStack currentGas = null;
    public int requiredAmount = 100;
    public int amount = 0;
    public int remainingProgress = 0;
    public boolean powered = false;
    public boolean activated = false;

    public TileGasPacketEncoder() {
        this.setInventory(new InventoryGasPacketEncoder(this));
        this.setEnergyStorage(new EnergyStorage((TileBase)this, energyCapacity));
    }

    protected String getLocalizedName() {
        return I18n.func_74838_a((String)"tile.packagedfluidcrafting.gas_packet_encoder.name");
    }

    public String getConfigTypeName() {
        return "tile.packagedfluidcrafting.gas_packet_encoder.name";
    }

    public void onLoad() {
        this.updatePowered();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0 && this.isTemplateValid()) {
                    this.finishProcess();
                    if (!this.inventory.func_70301_a(1).func_190926_b()) {
                        this.ejectItem();
                    }
                    if (!this.canStart()) {
                        this.endProcess();
                    } else {
                        this.startProcess();
                    }
                }
            } else if (this.activated && this.canStart()) {
                this.startProcess();
                this.tickProcess();
                this.activated = false;
                this.isWorking = true;
            }
            this.chargeEnergy();
            if (this.field_145850_b.func_82737_E() % (long)refreshInterval == 0L && !this.inventory.func_70301_a(1).func_190926_b()) {
                this.ejectItem();
            }
        }
    }

    public boolean isTemplateValid() {
        if (this.currentGas == null) {
            this.getGas();
        }
        return this.currentGas != null;
    }

    public boolean canStart() {
        this.getGas();
        if (this.currentGas == null) {
            return false;
        }
        if (!this.isTemplateValid()) {
            return false;
        }
        ItemStack slotStack = this.inventory.func_70301_a(1);
        return slotStack.func_190926_b();
    }

    protected boolean canFinish() {
        return this.remainingProgress <= 0 && this.isTemplateValid();
    }

    protected void getGas() {
        this.currentGas = null;
        ItemStack template = this.inventory.func_70301_a(0);
        if (template.func_190926_b()) {
            return;
        }
        GasStack gas = null;
        if (FakeGases.isGasFakeItem((ItemStack)template)) {
            gas = (GasStack)FakeItemRegister.getStack((ItemStack)template);
        } else if (template.func_77973_b() instanceof IGasItem) {
            gas = ((IGasItem)template.func_77973_b()).getGas(template);
        }
        if (gas != null) {
            this.currentGas = gas.copy();
            this.currentGas.amount = this.requiredAmount;
        }
    }

    protected void tickProcess() {
        if (this.amount < this.requiredAmount) {
            for (EnumFacing direction : EnumFacing.values()) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
                if (tile == null || !tile.hasCapability(Capabilities.GAS_HANDLER_CAPABILITY, direction.func_176734_d())) continue;
                IGasHandler gasHandler = (IGasHandler)tile.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, direction.func_176734_d());
                for (GasTankInfo tankInfo : gasHandler.getTankInfo()) {
                    GasStack drained;
                    GasTank tank;
                    if (!(tankInfo instanceof GasTank) || !this.currentGas.isGasEqual((tank = (GasTank)tankInfo).getGas()) || (drained = tank.draw(this.requiredAmount - this.amount, true)) == null) continue;
                    this.amount += drained.amount;
                }
                if (!this.currentGas.isGasEqual(gasHandler.drawGas(direction.func_176734_d(), this.requiredAmount - this.amount, false))) continue;
                this.amount += gasHandler.drawGas((EnumFacing)direction.func_176734_d(), (int)(this.requiredAmount - this.amount), (boolean)true).amount;
            }
        }
        if (this.amount >= this.requiredAmount) {
            int energy = this.energyStorage.extractEnergy(Math.min(energyUsage, this.remainingProgress), false);
            this.remainingProgress -= energy;
        }
    }

    protected void finishProcess() {
        if (this.currentGas == null) {
            this.getGas();
        }
        if (this.currentGas == null) {
            this.endProcess();
            return;
        }
        if (this.inventory.func_70301_a(1).func_190926_b()) {
            this.inventory.func_70299_a(1, FakeGases.packGas2Packet((GasStack)this.currentGas));
        }
        this.endProcess();
    }

    public void startProcess() {
        this.remainingProgress = energyReq;
        this.amount = 0;
        this.syncTile(false);
        this.func_70296_d();
    }

    public void endProcess() {
        this.remainingProgress = 0;
        this.amount = 0;
        this.isWorking = false;
        this.func_70296_d();
    }

    protected void ejectItem() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (tile == null || tile instanceof TileUnpackager || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) continue;
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            ItemStack stack = this.inventory.func_70301_a(1);
            if (stack.func_190926_b()) continue;
            ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
            this.inventory.func_70299_a(1, stackRem);
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.inventory.func_70301_a(2);
        if (energyStack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(energyRequest, false), false);
            if (energyStack.func_190916_E() <= 0) {
                this.inventory.func_70299_a(2, ItemStack.field_190927_a);
            }
        }
    }

    public void updatePowered() {
        if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0 != this.powered) {
            boolean bl = this.powered = !this.powered;
            if (this.powered && !this.isWorking) {
                this.activated = true;
            }
            this.func_70296_d();
        }
    }

    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.inventory.func_70301_a(1).func_190926_b()) {
            return 15;
        }
        return 0;
    }

    public ISettingsCloneable.Result loadConfig(NBTTagCompound nbt, EntityPlayer player) {
        this.requiredAmount = nbt.func_74762_e("AmountReq");
        return ISettingsCloneable.Result.success();
    }

    public ISettingsCloneable.Result saveConfig(NBTTagCompound nbt, EntityPlayer player) {
        nbt.func_74768_a("AmountReq", this.requiredAmount);
        return ISettingsCloneable.Result.success();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isWorking = nbt.func_74767_n("Working");
        this.amount = nbt.func_74762_e("Amount");
        this.remainingProgress = nbt.func_74762_e("Progress");
        this.powered = nbt.func_74767_n("Powered");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Working", this.isWorking);
        nbt.func_74768_a("Amount", this.amount);
        nbt.func_74768_a("Progress", this.remainingProgress);
        nbt.func_74757_a("Powered", this.powered);
        return nbt;
    }

    public void readSyncNBT(NBTTagCompound nbt) {
        super.readSyncNBT(nbt);
        this.requiredAmount = nbt.func_74762_e("AmountReq");
        this.currentGas = GasStack.readFromNBT((NBTTagCompound)nbt.func_74775_l("Gas"));
    }

    public NBTTagCompound writeSyncNBT(NBTTagCompound nbt) {
        super.writeSyncNBT(nbt);
        nbt.func_74768_a("AmountReq", this.requiredAmount);
        if (this.currentGas != null) {
            nbt.func_74782_a("Gas", (NBTBase)this.currentGas.write(new NBTTagCompound()));
        }
        return nbt;
    }

    public void func_70296_d() {
        if (this.isWorking && !this.isTemplateValid()) {
            this.endProcess();
        }
        super.func_70296_d();
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return Math.min(scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored(), scale);
    }

    public int getScaledProgress(int scale) {
        if (this.remainingProgress <= 0 || energyReq <= 0) {
            return 0;
        }
        return scale * (energyReq - this.remainingProgress) / energyReq;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return new GuiGasPacketEncoder(new ContainerGasPacketEncoder(player.field_71071_by, this));
    }

    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return new ContainerGasPacketEncoder(player.field_71071_by, this);
    }
}

