/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedfluidcrafting.util;

import appeng.api.storage.data.IAEItemStack;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.item.ItemGasPacket;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.integration.mek.FakeGases;
import com.glodblock.github.util.ModAndClassUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mekanism.api.gas.GasStack;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.capabilities.Capabilities;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import thelm.packagedauto.client.gui.GuiContainerTileBase;
import thelm.packagedfluidcrafting.client.gui.GuiFluidAmountSpecifying;
import thelm.packagedfluidcrafting.client.gui.GuiGasAmountSpecifying;
import thelm.packagedfluidcrafting.inventory.ItemHandlerConverting;

public class MixinHooks {
    public static final MixinHooks INSTANCE = new MixinHooks();

    private MixinHooks() {
    }

    public String replaceDescTooltip(ItemStack itemStack, Supplier<String> original) {
        GasStack gasStack;
        if (FakeFluids.isFluidFakeItem((ItemStack)itemStack)) {
            FluidStack fluidStack = (FluidStack)FakeItemRegister.getStack((ItemStack)itemStack);
            if (fluidStack != null) {
                return fluidStack.amount + "mB " + fluidStack.getLocalizedName();
            }
        } else if (ModAndClassUtil.GAS && FakeGases.isGasFakeItem((ItemStack)itemStack) && (gasStack = (GasStack)FakeItemRegister.getStack((ItemStack)itemStack)) != null) {
            return gasStack.amount + "mB " + gasStack.getGas().getLocalizedName();
        }
        return original.get();
    }

    public ItemStack packToPacket(Object ingredient) {
        if (ingredient instanceof FluidStack) {
            return FakeFluids.packFluid2Packet((FluidStack)((FluidStack)ingredient));
        }
        if (ModAndClassUtil.GAS && ingredient instanceof GasStack) {
            return FakeGases.packGas2Packet((GasStack)((GasStack)ingredient));
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasGasHandler(ICapabilityProvider capProvider, EnumFacing side) {
        return ModAndClassUtil.GAS && capProvider.hasCapability(Capabilities.GAS_HANDLER_CAPABILITY, side);
    }

    public IItemHandler getConvertingItemHandler(List<ItemStack> stacks, TileEntity tile, EnumFacing facing) {
        boolean checkItem = !stacks.stream().allMatch(stack -> FakeFluids.isFluidFakeItem((ItemStack)stack) || ModAndClassUtil.GAS && FakeGases.isGasFakeItem((ItemStack)stack));
        boolean checkFluid = stacks.stream().anyMatch(FakeFluids::isFluidFakeItem);
        boolean checkGas = ModAndClassUtil.GAS && stacks.stream().anyMatch(FakeGases::isGasFakeItem);
        return ItemHandlerConverting.wrap((ICapabilityProvider)tile, facing, checkItem, checkFluid, checkGas);
    }

    public IItemHandler getConvertingItemHandler(ItemStack stack, TileEntity tile, EnumFacing facing) {
        boolean checkItem = !FakeFluids.isFluidFakeItem((ItemStack)stack) && (!ModAndClassUtil.GAS || !FakeGases.isGasFakeItem((ItemStack)stack));
        boolean checkFluid = FakeFluids.isFluidFakeItem((ItemStack)stack);
        boolean checkGas = ModAndClassUtil.GAS && FakeGases.isGasFakeItem((ItemStack)stack);
        return ItemHandlerConverting.wrap((ICapabilityProvider)tile, facing, checkItem, checkFluid, checkGas);
    }

    public void flattenPackets(IAEItemStack[] stacks) {
        int i;
        for (i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null || !(stacks[i].getItem() instanceof ItemFluidPacket)) continue;
            stacks[i] = FakeFluids.packFluid2AEDrops((FluidStack)((FluidStack)FakeItemRegister.getStack((IAEItemStack)stacks[i])));
        }
        if (ModAndClassUtil.GAS) {
            for (i = 0; i < stacks.length; ++i) {
                if (stacks[i] == null || !(stacks[i].getItem() instanceof ItemGasPacket)) continue;
                stacks[i] = FakeGases.packGas2AEDrops((GasStack)((GasStack)FakeItemRegister.getStack((IAEItemStack)stacks[i])));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean displayAmountSpecifyingGui(Minecraft mc, GuiContainerTileBase<?> parent, Slot slot) {
        GasStack gs;
        ItemStack is = slot.func_75211_c();
        if (FakeFluids.isFluidFakeItem((ItemStack)is)) {
            FluidStack fs = (FluidStack)FakeItemRegister.getStack((ItemStack)is);
            if (fs != null) {
                mc.func_147108_a((GuiScreen)new GuiFluidAmountSpecifying(parent, mc.field_71439_g.field_71071_by, slot.field_75222_d, fs, 1000000000));
                return true;
            }
        } else if (ModAndClassUtil.GAS && FakeGases.isGasFakeItem((ItemStack)is) && (gs = (GasStack)FakeItemRegister.getStack((ItemStack)is)) != null) {
            mc.func_147108_a((GuiScreen)new GuiGasAmountSpecifying(parent, mc.field_71439_g.field_71071_by, slot.field_75222_d, gs, 1000000000));
            return true;
        }
        return false;
    }

    @Optional.Method(modid="jei")
    public void addToProcessingTransferMap(IRecipeLayout recipeLayout, List<ItemStack> input, List<ItemStack> output) {
        Map fluidIngredients = recipeLayout.getFluidStacks().getGuiIngredients();
        for (Map.Entry entry : fluidIngredients.entrySet()) {
            IGuiIngredient ingredient = (IGuiIngredient)entry.getValue();
            FluidStack displayed = (FluidStack)((IGuiIngredient)entry.getValue()).getDisplayedIngredient();
            if (displayed == null) continue;
            if (ingredient.isInput()) {
                input.add(FakeFluids.packFluid2Packet((FluidStack)displayed));
                continue;
            }
            output.add(FakeFluids.packFluid2Packet((FluidStack)displayed));
        }
        if (ModAndClassUtil.GAS) {
            Map gasIngredients = recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_GAS).getGuiIngredients();
            for (Map.Entry entry : gasIngredients.entrySet()) {
                IGuiIngredient ingredient = (IGuiIngredient)entry.getValue();
                GasStack displayed = (GasStack)((IGuiIngredient)entry.getValue()).getDisplayedIngredient();
                if (displayed == null) continue;
                if (ingredient.isInput()) {
                    input.add(FakeGases.packGas2Packet((GasStack)displayed));
                    continue;
                }
                output.add(FakeGases.packGas2Packet((GasStack)displayed));
            }
        }
    }

    @Optional.Method(modid="jei")
    public int addToPositionedTransferMap(IRecipeLayout recipeLayout, Int2ObjectMap<ItemStack> map, int index, List<ItemStack> output) {
        Map fluidIngredients = recipeLayout.getFluidStacks().getGuiIngredients();
        for (Map.Entry entry : fluidIngredients.entrySet()) {
            IGuiIngredient ingredient = (IGuiIngredient)entry.getValue();
            if (ingredient.isInput() && index >= 81) continue;
            FluidStack displayed = (FluidStack)((IGuiIngredient)entry.getValue()).getDisplayedIngredient();
            if (displayed != null) {
                if (ingredient.isInput()) {
                    map.put(index, (Object)FakeFluids.packFluid2Packet((FluidStack)displayed));
                } else {
                    output.add(FakeFluids.packFluid2Packet((FluidStack)displayed));
                }
            }
            if (!ingredient.isInput()) continue;
            ++index;
        }
        if (ModAndClassUtil.GAS) {
            Map gasIngredients = recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_GAS).getGuiIngredients();
            for (Map.Entry entry : gasIngredients.entrySet()) {
                IGuiIngredient ingredient = (IGuiIngredient)entry.getValue();
                if (ingredient.isInput() && index >= 81) continue;
                GasStack displayed = (GasStack)((IGuiIngredient)entry.getValue()).getDisplayedIngredient();
                if (displayed != null) {
                    if (ingredient.isInput()) {
                        map.put(index, (Object)FakeGases.packGas2Packet((GasStack)displayed));
                    } else {
                        output.add(FakeGases.packGas2Packet((GasStack)displayed));
                    }
                }
                if (!ingredient.isInput()) continue;
                ++index;
            }
        }
        return index;
    }
}

