/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.data.container;

import de.linusdev.data.AbstractData;
import de.linusdev.data.OptionalValue;
import de.linusdev.data.container.ListContainer;
import de.linusdev.data.container.NonExistentContainer;
import de.linusdev.data.functions.Converter;
import de.linusdev.data.functions.ExceptionConverter;
import de.linusdev.data.functions.ExceptionSupplier;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Container<K, V, O>
extends OptionalValue<O> {
    @NotNull
    public K getKey();

    @NotNull
    public AbstractData<K, V> getParentData();

    @ApiStatus.Internal
    @NotNull
    public <N> Container<K, V, N> createNewContainer(@Nullable N var1);

    @ApiStatus.Internal
    @NotNull
    public <T> ListContainer<T> createNewListContainer(@Nullable List<T> var1);

    @NotNull
    default public <E extends Throwable> Container<K, V, O> requireNotNull(ExceptionSupplier<K, AbstractData<K, V>, E> supplier) throws E {
        if (this.get() == null) {
            throw supplier.supply(this.getParentData(), this.getKey());
        }
        return this;
    }

    @NotNull
    default public Container<K, V, O> requireNotNull() throws NullPointerException {
        if (this.get() == null) {
            throw new NullPointerException(this.getKey() + " is null.");
        }
        return this;
    }

    @NotNull
    default public ListContainer<Object> asList() {
        return this.createNewListContainer((List)this.get());
    }

    @NotNull
    default public <C> Container<K, V, C> cast() {
        return this.createNewContainer(this.get());
    }

    @NotNull
    default public <C, R> Container<K, V, R> castAndConvert(@NotNull Converter<C, R> converter) {
        return this.createNewContainer(converter.convert(this.get()));
    }

    @NotNull
    default public <C, R, E extends Throwable> Container<K, V, R> castAndConvertWithException(@NotNull ExceptionConverter<C, R, E> converter) throws E {
        return this.createNewContainer(converter.convert(this.get()));
    }

    @NotNull
    default public Container<K, V, O> ifExists() {
        if (this.exists()) {
            return this;
        }
        return new NonExistentContainer(this.getParentData(), this.getKey());
    }

    @NotNull
    default public Container<K, V, O> process(@NotNull Consumer<O> consumer) {
        consumer.accept(this.get());
        return this;
    }
}

