/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.data.container;

import de.linusdev.data.AbstractData;
import de.linusdev.data.container.Container;
import de.linusdev.data.container.ListContainer;
import de.linusdev.data.container.NonExistentException;
import de.linusdev.data.container.NonExistentListContainer;
import de.linusdev.data.functions.Converter;
import de.linusdev.data.functions.ExceptionConverter;
import de.linusdev.data.functions.ExceptionSupplier;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonExistentContainer<K, V, O>
implements Container<K, V, O> {
    @NotNull
    private final AbstractData<K, V> parentData;
    @NotNull
    private final K key;

    public NonExistentContainer(@NotNull AbstractData<K, V> parentData, @NotNull K key) {
        this.parentData = parentData;
        this.key = key;
    }

    @Override
    public O get() {
        throw new NonExistentException(this.getKey());
    }

    @Override
    public boolean isNull() {
        return true;
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    @NotNull
    public K getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public AbstractData<K, V> getParentData() {
        return this.parentData;
    }

    @Override
    @NotNull
    public <N> Container<K, V, N> createNewContainer(@Nullable N newValue) {
        return new NonExistentContainer<K, V, O>(this.parentData, this.key);
    }

    @Override
    @NotNull
    public <T> ListContainer<T> createNewListContainer(@Nullable List<T> newValue) {
        return new NonExistentListContainer();
    }

    @Override
    @NotNull
    public <E extends Throwable> Container<K, V, O> requireNotNull(ExceptionSupplier<K, AbstractData<K, V>, E> supplier) throws E {
        throw supplier.supply(this.parentData, this.key);
    }

    @Override
    @NotNull
    public Container<K, V, O> requireNotNull() throws NullPointerException {
        return this;
    }

    @Override
    @NotNull
    public ListContainer<Object> asList() {
        return this.createNewListContainer(null);
    }

    @Override
    @NotNull
    public <C, R> Container<K, V, R> castAndConvert(@NotNull Converter<C, R> converter) {
        return this.createNewContainer(null);
    }

    @Override
    @NotNull
    public <C> Container<K, V, C> cast() {
        return this.createNewContainer(null);
    }

    @Override
    @NotNull
    public <C, R, E extends Throwable> Container<K, V, R> castAndConvertWithException(@NotNull ExceptionConverter<C, R, E> converter) {
        return this.createNewContainer(null);
    }

    @Override
    @NotNull
    public Container<K, V, O> ifExists() {
        return this;
    }

    @Override
    @NotNull
    public Container<K, V, O> process(@NotNull Consumer<O> consumer) {
        return this;
    }
}

