/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.data.parser;

import de.linusdev.data.AbstractData;
import de.linusdev.data.Datable;
import de.linusdev.data.ParseType;
import de.linusdev.data.entry.Entry;
import de.linusdev.data.parser.JsonReader;
import de.linusdev.data.parser.ParseHelper;
import de.linusdev.data.parser.ParseTracker;
import de.linusdev.data.parser.SpaceOffsetTracker;
import de.linusdev.data.parser.exceptions.ParseException;
import de.linusdev.data.parser.exceptions.UnexpectedCharacterException;
import de.linusdev.data.parser.exceptions.UnexpectedEndException;
import de.linusdev.data.so.SAOEntryImpl;
import de.linusdev.data.so.SOData;
import de.linusdev.lutils.interfaces.Simplifiable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonParser {
    public static final int CURLY_BRACKET_OPEN_CHAR = 123;
    public static final int CURLY_BRACKET_CLOSE_CHAR = 125;
    public static final int SQUARE_BRACKET_OPEN_CHAR = 91;
    public static final int SQUARE_BRACKET_CLOSE_CHAR = 93;
    public static final int QUOTE_CHAR = 34;
    public static final int COLON_CHAR = 58;
    public static final int NEW_LINE_CHAR = 10;
    public static final int COMMA_CHAR = 44;
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String NULL = "null";
    public static final String DEFAULT_ARRAY_WRAPPER_KEY = "array";
    @NotNull
    private String indent = "\t";
    @NotNull
    private Supplier<SOData> dataSupplier = SOData::newOrderedDataWithUnknownSize;
    @NotNull
    private String arrayWrapperKey = "array";
    private boolean allowNewLineInStrings = true;

    public void setIndent(@NotNull String indent) {
        this.indent = indent;
    }

    public void setDataSupplier(@NotNull Supplier<SOData> dataSupplier) {
        this.dataSupplier = dataSupplier;
    }

    public void setArrayWrapperKey(@NotNull String arrayWrapperKey) {
        this.arrayWrapperKey = arrayWrapperKey;
    }

    public void setAllowNewLineInStrings(boolean allowNewLineInStrings) {
        this.allowNewLineInStrings = allowNewLineInStrings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SOData parseStream(@NotNull InputStream stream) throws IOException, ParseException {
        try (JsonReader reader = new JsonReader(new BufferedReader(new InputStreamReader(stream)));){
            SOData sOData = this.parse(reader);
            return sOData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SOData parseReader(@NotNull Reader reader) throws IOException, ParseException {
        try (JsonReader jsonReader = new JsonReader(new BufferedReader(reader));){
            SOData sOData = this.parse(jsonReader);
            return sOData;
        }
    }

    @NotNull
    private SOData parse(@NotNull JsonReader reader) throws IOException, ParseException {
        ParseTracker tracker = new ParseTracker();
        int i = reader.read(tracker);
        if (i == -1) {
            return this.dataSupplier.get();
        }
        if (i == 123) {
            return this.parseJsonObject(reader, tracker);
        }
        if (i == 91) {
            SOData data = this.dataSupplier.get();
            SAOEntryImpl<List<Object>> entry = new SAOEntryImpl<List<Object>>(this.arrayWrapperKey);
            entry.setValue(this.parseJsonArray(reader, tracker));
            data.addEntry(entry);
            return data;
        }
        throw new UnexpectedCharacterException((char)i, tracker);
    }

    @NotNull
    private SOData parseJsonObject(@NotNull JsonReader reader, @NotNull ParseTracker tracker) throws IOException, ParseException {
        int i = reader.read(tracker);
        SOData data = this.dataSupplier.get();
        if (i == 125) {
            return data;
        }
        while (i != -1) {
            if (i != 34) {
                throw new UnexpectedCharacterException((char)i, tracker);
            }
            SAOEntryImpl<Object> entry = new SAOEntryImpl<Object>(reader.readString(this.allowNewLineInStrings, tracker));
            i = reader.read(tracker);
            if (i != 58) {
                throw new UnexpectedCharacterException((char)i, tracker);
            }
            entry.setValue(this.parseJsonValue(reader, tracker));
            data.addEntry(entry);
            i = reader.read(tracker);
            if (i == 44) {
                i = reader.read(tracker);
                continue;
            }
            if (i == 125) {
                return data;
            }
            throw new UnexpectedCharacterException((char)i, tracker);
        }
        throw new UnexpectedEndException(tracker);
    }

    @Nullable
    private Object parseJsonValue(@NotNull JsonReader reader, @NotNull ParseTracker tracker) throws IOException, ParseException {
        int i = reader.read(tracker);
        if (i == 34) {
            return reader.readString(this.allowNewLineInStrings, tracker);
        }
        if (i == 123) {
            return this.parseJsonObject(reader, tracker);
        }
        if (i == 91) {
            return this.parseJsonArray(reader, tracker);
        }
        reader.pushBack(i);
        return reader.readValue(tracker);
    }

    @NotNull
    private List<Object> parseJsonArray(@NotNull JsonReader reader, @NotNull ParseTracker tracker) throws IOException, ParseException {
        int i = reader.read(tracker);
        LinkedList<Object> list = new LinkedList<Object>();
        if (i == 93) {
            return list;
        }
        reader.pushBack(i);
        while (i != -1) {
            list.add(this.parseJsonValue(reader, tracker));
            i = reader.read(tracker);
            if (i == 44) continue;
            if (i == 93) {
                return list;
            }
            throw new UnexpectedCharacterException((char)i, tracker);
        }
        throw new UnexpectedEndException(tracker);
    }

    @NotNull
    public String writeDataToString(@Nullable AbstractData<?, ?> data) throws IOException {
        return this.writeDataToStringBuilder(data).toString();
    }

    @NotNull
    public StringBuilder writeDataToStringBuilder(@Nullable AbstractData<?, ?> data) {
        StringBuilder writer = new StringBuilder(data == null ? 10 : data.size() * 10);
        try {
            this.writeData(writer, data);
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
        }
        return writer;
    }

    public void writeData(@NotNull Appendable writer, @Nullable AbstractData<?, ?> data) throws IOException {
        SpaceOffsetTracker offset = new SpaceOffsetTracker(this.indent);
        this.writeJson(writer, offset, data);
    }

    private void writeJson(@NotNull Appendable writer, @NotNull SpaceOffsetTracker offset, @Nullable AbstractData<?, ?> data) throws IOException {
        if (data == null) {
            data = this.dataSupplier.get();
        }
        if (data.getParseType() == ParseType.NORMAL) {
            writer.append('{');
            offset.add();
            boolean first = true;
            for (Entry entry : data) {
                if (!first) {
                    writer.append(',');
                } else {
                    first = false;
                }
                writer.append('\n').append(offset.toString());
                writer.append('\"').append(Objects.toString(entry.getKey())).append("\": ");
                this.writeJsonValue(writer, offset, entry.getValue());
            }
            writer.append('\n');
            offset.remove();
            writer.append(offset.toString()).append('}');
        } else if (data.getParseType() == ParseType.CONTENT_ONLY) {
            boolean first = true;
            for (Entry entry : data) {
                if (!first) {
                    writer.append(", ");
                } else {
                    first = false;
                }
                writer.append(offset.toString());
                this.writeJsonValue(writer, offset, entry.getValue());
            }
        }
    }

    private void writeJsonValue(@NotNull Appendable writer, @NotNull SpaceOffsetTracker offset, @Nullable Object value) throws IOException {
        if (value == null) {
            writer.append(NULL);
        } else if (value instanceof Datable) {
            this.writeJson(writer, offset, ((Datable)value).getData());
        } else if (value instanceof Simplifiable) {
            this.writeJsonValue(writer, offset, ((Simplifiable)value).simplify());
        } else if (value instanceof String) {
            writer.append('\"');
            ParseHelper.escape2((String)value, writer);
            writer.append('\"');
        } else if (value instanceof Boolean) {
            writer.append(value.toString());
        } else if (value instanceof Integer) {
            writer.append(value.toString());
        } else if (value instanceof Long) {
            writer.append(value.toString());
        } else if (value instanceof Byte) {
            writer.append(value.toString());
        } else if (value instanceof Short) {
            writer.append(value.toString());
        } else if (value instanceof Double) {
            writer.append(value.toString());
        } else if (value instanceof Float) {
            writer.append(value.toString());
        } else if (value instanceof Collection) {
            writer.append('[').append('\n');
            offset.add();
            boolean first = true;
            for (Object o : (Collection)value) {
                if (!first) {
                    writer.append(',').append('\n');
                } else {
                    first = false;
                }
                writer.append(offset.toString());
                this.writeJsonValue(writer, offset, o);
            }
            writer.append('\n');
            offset.remove();
            writer.append(offset.toString()).append(']');
        } else if (value instanceof Object[]) {
            this.writeJsonValue(writer, offset, (Object[])value);
        } else if (value.getClass().isArray()) {
            if (value instanceof byte[]) {
                byte[] a = (byte[])value;
                Object[] o = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    o[i] = a[i];
                }
                this.writeJsonValue(writer, offset, o);
            } else if (value instanceof short[]) {
                short[] a = (short[])value;
                Object[] o = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    o[i] = a[i];
                }
                this.writeJsonValue(writer, offset, o);
            } else if (value instanceof int[]) {
                int[] a = (int[])value;
                Object[] o = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    o[i] = a[i];
                }
                this.writeJsonValue(writer, offset, o);
            } else if (value instanceof long[]) {
                long[] a = (long[])value;
                Object[] o = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    o[i] = a[i];
                }
                this.writeJsonValue(writer, offset, o);
            } else if (value instanceof float[]) {
                float[] a = (float[])value;
                Object[] o = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    o[i] = Float.valueOf(a[i]);
                }
                this.writeJsonValue(writer, offset, o);
            } else if (value instanceof double[]) {
                double[] a = (double[])value;
                Object[] o = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    o[i] = a[i];
                }
                this.writeJsonValue(writer, offset, o);
            }
        } else {
            writer.append('\"');
            ParseHelper.escape2(value.toString(), writer);
            writer.append('\"');
        }
    }

    private void writeJsonValue(@NotNull Appendable writer, @NotNull SpaceOffsetTracker offset, @NotNull Object[] value) throws IOException {
        writer.append('[').append('\n');
        offset.add();
        boolean first = true;
        for (Object o : value) {
            if (!first) {
                writer.append(',').append('\n');
            } else {
                first = false;
            }
            writer.append(offset.toString());
            this.writeJsonValue(writer, offset, o);
        }
        writer.append('\n');
        offset.remove();
        writer.append(offset.toString()).append(']');
    }
}

