/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.bitfield;

import de.linusdev.lutils.bitfield.LongBitFieldValue;
import org.jetbrains.annotations.NotNull;

public interface LongBitfield<V extends LongBitFieldValue> {
    public long getValue();

    public void replaceWith(long var1);

    default public void reset() {
        this.replaceWith(0L);
    }

    default public boolean isSet(long flag) {
        return (this.getValue() & flag) == flag;
    }

    default public boolean isSet(@NotNull V flag) {
        return this.isSet(flag.getValue());
    }

    default public void setFlag(long flag) {
        this.replaceWith(this.getValue() | flag);
    }

    default public void set(@NotNull V flag) {
        this.setFlag(flag.getValue());
    }

    default public void set(@NotNull V flag1, @NotNull V flag2) {
        this.setFlag(flag1.getValue());
        this.setFlag(flag2.getValue());
    }

    default public void set(@NotNull V flag1, @NotNull V flag2, @NotNull V flag3) {
        this.setFlag(flag1.getValue());
        this.setFlag(flag2.getValue());
        this.setFlag(flag3.getValue());
    }

    default public void set(@NotNull V flag1, @NotNull V flag2, @NotNull V flag3, @NotNull V flag4) {
        this.setFlag(flag1.getValue());
        this.setFlag(flag2.getValue());
        this.setFlag(flag3.getValue());
        this.setFlag(flag4.getValue());
    }

    default public void set(@NotNull @NotNull V @NotNull [] flags) {
        for (V flag : flags) {
            this.setFlag(flag.getValue());
        }
    }

    default public void unset(@NotNull V flag) {
        this.unsetFlag(flag.getValue());
    }

    default public void unsetFlag(long flag) {
        this.replaceWith(this.getValue() & (flag ^ 0xFFFFFFFFFFFFFFFFL));
    }
}

