/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.chart;

import de.linusdev.lutils.math.LMath;
import de.linusdev.lutils.other.ArgUtils;
import de.linusdev.lutils.result.BiResult;
import de.linusdev.lutils.result.TriResult;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class ChartUtils {
    private static final double[] READABLE_FACTORS = new double[]{1.0, 2.0, 2.5, 5.0, 10.0};

    public static BiResult<Double, Integer> calcBestLabelValue(@Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) double maxValue, @Range(from=1L, to=1000L) int minLabelCount, @Range(from=1L, to=10L) int preferredLabelCount, @Range(from=1L, to=1000L) int maxLabelCount, @NotNull LabelLeaning leaning) {
        return ChartUtils.choseBasedOnRating(minLabelCount, preferredLabelCount, maxLabelCount, count -> ChartUtils._calculateLabelValue(maxValue, count, leaning));
    }

    private static double beautifyMinValue(double minValue, double maxValue, int preferredLabelCount) {
        ArgUtils.requireGreater(maxValue, minValue, 0.0, "maxValue");
        double exactValue = (maxValue - minValue) / (double)preferredLabelCount;
        double normalizeFactor = Math.pow(10.0, Math.floor(Math.log10(exactValue)));
        double normalizedMinValue = minValue / normalizeFactor;
        double roundedMinValue = Math.floor(normalizedMinValue);
        return roundedMinValue * normalizeFactor;
    }

    public static TriResult<Double, Integer, Double> calcBestLabelValue(@Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) double minValue, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) double maxValue, @Range(from=1L, to=1000L) int minLabelCount, @Range(from=1L, to=10L) int preferredLabelCount, @Range(from=1L, to=1000L) int maxLabelCount, @NotNull LabelLeaning leaning) {
        double newMinValue = ChartUtils.beautifyMinValue(minValue, maxValue, preferredLabelCount);
        BiResult<Double, Integer> res = ChartUtils.calcBestLabelValue(maxValue - newMinValue, minLabelCount, preferredLabelCount, maxLabelCount, leaning);
        return new TriResult<Double, Integer, Double>(res.result1(), res.result2(), newMinValue);
    }

    public static double calcLabelValue(@Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) double maxValue, @Range(from=1L, to=1000L) int labelCount, @NotNull LabelLeaning leaning) {
        return ChartUtils._calculateLabelValue(maxValue, labelCount, leaning).result1();
    }

    public static BiResult<Double, Integer> calcBestAndReadableLabelValue(@Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) double maxValue, @Range(from=1L, to=1000L) int minLabelCount, @Range(from=1L, to=10L) int preferredLabelCount, @Range(from=1L, to=1000L) int maxLabelCount, @Range(from=-1L, to=1L) double leaning) {
        double sigLeaning = Math.signum(leaning);
        double difAdd = Math.pow(Math.abs(leaning), 5.0) * 5.0;
        double difMultiply = Math.abs(leaning) + 1.0;
        return ChartUtils.choseBasedOnRating(minLabelCount, preferredLabelCount, maxLabelCount, count -> ChartUtils._calcReadableLabelValue(maxValue, count, sigLeaning, difAdd, difMultiply));
    }

    public static TriResult<Double, Integer, Double> calcBestAndReadableLabelValue(@Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) double minValue, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) double maxValue, @Range(from=1L, to=1000L) int minLabelCount, @Range(from=1L, to=10L) int preferredLabelCount, @Range(from=1L, to=1000L) int maxLabelCount, @Range(from=-1L, to=1L) double leaning) {
        double newMinValue = ChartUtils.beautifyMinValue(minValue, maxValue, preferredLabelCount);
        BiResult<Double, Integer> res = ChartUtils.calcBestAndReadableLabelValue(maxValue - newMinValue, minLabelCount, preferredLabelCount, maxLabelCount, leaning);
        return new TriResult<Double, Integer, Double>(res.result1(), res.result2(), newMinValue);
    }

    private static TriResult<Double, Double, Boolean> _calculateLabelValue(double maxValue, @Range(from=1L, to=1000L) int labelCount, @NotNull LabelLeaning leaning) {
        double exactValue = maxValue / (double)labelCount;
        double normalizeFactor = Math.pow(10.0, Math.floor(Math.log10(exactValue)));
        double normalizedValue = exactValue / normalizeFactor;
        double roundedValue = leaning.round(normalizedValue);
        double value = roundedValue * normalizeFactor;
        double rating = Math.abs(maxValue - value * (double)labelCount);
        return new TriResult<Double, Double, Boolean>(roundedValue * normalizeFactor, rating, value * (double)(labelCount - 1) >= maxValue || value * (double)(labelCount + 1) <= maxValue);
    }

    private static TriResult<Double, Double, Boolean> _calcReadableLabelValue(double maxValue, int labelCount, double sigLeaning, double difAdd, double difMultiply) {
        double exactValue = maxValue / (double)labelCount;
        double normalizeFactor = Math.pow(10.0, Math.floor(Math.log10(exactValue)));
        double normalizedMax = maxValue / normalizeFactor;
        double smallestDif = 1000000.0;
        double smallest = -1.0;
        for (int i = 0; i < READABLE_FACTORS.length; ++i) {
            double eMax = READABLE_FACTORS[i] * (double)labelCount;
            double dif = normalizedMax - eMax;
            dif = Math.signum(dif) == sigLeaning ? (Math.abs(dif) + difAdd) * difMultiply : Math.abs(dif);
            if (!(dif < smallestDif)) continue;
            smallestDif = dif;
            smallest = READABLE_FACTORS[i];
        }
        double value = smallest * normalizeFactor;
        double rating = Math.abs(maxValue - value * (double)labelCount);
        return new TriResult<Double, Double, Boolean>(value, rating, value * (double)(labelCount - 1) >= maxValue || value * (double)(labelCount + 1) <= maxValue);
    }

    protected static int choseTestRange(int labelCount) {
        return (int)Math.max(1L, Math.round(2.0 * (-Math.exp(labelCount) / (0.25 * (double)labelCount * Math.exp((double)labelCount - 0.5) + (double)labelCount - 1.0) + 2.6) + LMath.clamp((double)(labelCount - 15) / 4.0, 0.0, 5.0)));
    }

    private static BiResult<Double, Integer> choseBasedOnRating(int minLabelCount, int baseLabelCount, int maxLabelCount, Function<Integer, TriResult<Double, Double, Boolean>> labelCountToRatingFunction) {
        ArgUtils.requireGreater(minLabelCount, 0, "minLabelCount");
        ArgUtils.requireGreaterOrEqual(maxLabelCount, minLabelCount, "maxLabelCount");
        ArgUtils.requireGreaterOrEqual(baseLabelCount, minLabelCount, "baseLabelCount");
        ArgUtils.requireLessOrEqual(baseLabelCount, maxLabelCount, "baseLabelCount");
        if (minLabelCount == 1) {
            minLabelCount = -10;
        }
        int bestLabelCount = baseLabelCount;
        TriResult<Double, Double, Boolean> res = labelCountToRatingFunction.apply(baseLabelCount);
        int testRange = ChartUtils.choseTestRange(baseLabelCount);
        if (baseLabelCount + testRange > maxLabelCount) {
            testRange += maxLabelCount - (baseLabelCount + testRange);
        } else if (baseLabelCount - testRange < minLabelCount) {
            testRange += minLabelCount - (baseLabelCount - testRange);
        }
        boolean failed = res.result3();
        for (int i = 1; i == 1 || i < testRange && failed; ++i) {
            TriResult<Double, Double, Boolean> resMore;
            TriResult<Double, Double, Boolean> resLess;
            if (i < minLabelCount || i > maxLabelCount) continue;
            int testLabelCount = baseLabelCount - i;
            if (testLabelCount > 1 && (resLess = labelCountToRatingFunction.apply(testLabelCount)).result2() < res.result2() && !resLess.result3().booleanValue()) {
                res = resLess;
                bestLabelCount = testLabelCount;
                failed = false;
            }
            if (!((resMore = labelCountToRatingFunction.apply(testLabelCount = baseLabelCount + i)).result2() < res.result2()) || resMore.result3().booleanValue()) continue;
            res = resMore;
            bestLabelCount = testLabelCount;
            failed = false;
        }
        return new BiResult<Double, Integer>(res.result1(), bestLabelCount);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum LabelLeaning {
        HIGHER_THAN_MAX{

            @Override
            public double round(double value) {
                return Math.ceil(value);
            }
        }
        ,
        BEST{

            @Override
            public double round(double value) {
                return Math.round(value);
            }
        }
        ,
        LOWER_THAN_MAX{

            @Override
            public double round(double value) {
                return Math.floor(value);
            }
        };


        public abstract double round(double var1);
    }
}

