/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.codegen.c;

import de.linusdev.lutils.codegen.java.JavaMethod;
import org.jetbrains.annotations.NotNull;

public interface CPPUtils {
    @NotNull
    public static String reinterpretCast(@NotNull String typeToCastTo, @NotNull String expression) {
        return "reinterpret_cast<" + typeToCastTo + ">(" + expression + ")";
    }

    @NotNull
    public static String staticCast(@NotNull String typeToCastTo, @NotNull String expression) {
        return "static_cast<" + typeToCastTo + ">(" + expression + ")";
    }

    @NotNull
    public static String callLocalFun(@NotNull String funName, String ... params) {
        StringBuilder ret = new StringBuilder(funName + "(");
        if (params.length > 0) {
            ret.append(params[0]);
            for (int i = 1; i < params.length; ++i) {
                ret.append(", ").append(params[i]);
            }
        }
        return ret + ")";
    }

    @NotNull
    public static String declareAndAssign(@NotNull String type, @NotNull String variable, @NotNull String expression) {
        return type + " " + variable + " = " + expression;
    }

    @NotNull
    public static String indent(int count) {
        return "    ".repeat(count);
    }

    @NotNull
    public static String block(int currentIndentCount, String ... expressions) {
        StringBuilder ret = new StringBuilder("\n" + CPPUtils.indent(currentIndentCount) + "{");
        for (String expression : expressions) {
            ret.append("\n").append(CPPUtils.indent(currentIndentCount + 1)).append(expression).append(";");
        }
        ret.append("\n").append(CPPUtils.indent(currentIndentCount)).append("}");
        return ret.toString();
    }

    @NotNull
    public static String funDeclaration(@NotNull String beforeType, @NotNull String type, @NotNull String afterType, @NotNull String funName, @NotNull String[] paramTypes, String ... paramNames) {
        StringBuilder ret = new StringBuilder(beforeType + " " + type + " " + afterType + " " + funName + "(");
        if (paramTypes.length > 0) {
            ret.append(paramTypes[0]).append(" ").append(paramNames[0]);
            for (int i = 1; i < paramTypes.length; ++i) {
                ret.append(", ").append(paramTypes[i]).append(" ").append(paramNames[i]);
            }
        }
        return ret + ")";
    }

    @NotNull
    public static String returnExpression(@NotNull String expressionToReturn) {
        return "return " + expressionToReturn;
    }

    @NotNull
    public static String jniJavaFunName(@NotNull JavaMethod method) {
        StringBuilder ret = new StringBuilder("Java");
        for (String s : method.getParentClass().getPackage().getArray()) {
            ret.append("_").append(s);
        }
        ret.append("_").append(method.getParentClass().getName());
        ret.append("_").append(method.getName());
        return ret.toString();
    }

    @NotNull
    public static String typedefFunPointer(@NotNull String retType, @NotNull String call, @NotNull String name, @NotNull String[] paramTypes) {
        StringBuilder ret = new StringBuilder("typedef " + retType + " (" + call + " *" + name + ")(");
        if (paramTypes.length > 0) {
            ret.append(paramTypes[0]);
            for (int i = 1; i < paramTypes.length; ++i) {
                ret.append(", ").append(paramTypes[i]);
            }
        }
        return ret + ");";
    }

    @NotNull
    public static String JNI_EXPORT() {
        return "JNIEXPORT";
    }

    @NotNull
    public static String JNI_CALL() {
        return "JNICALL";
    }
}

