/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.codegen.java;

import de.linusdev.lutils.codegen.java.JavaPackage;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaImport {
    @NotNull
    private final JavaPackage jPackage;
    @NotNull
    private final String className;
    @Nullable
    private final String variable;

    public JavaImport(@NotNull JavaPackage jPackage, @NotNull String className, @Nullable String variable) {
        this.jPackage = jPackage;
        this.className = className;
        this.variable = variable;
    }

    public JavaImport(@NotNull Class<?> clazz, @Nullable String variable) {
        this.variable = variable;
        if (clazz.isAnonymousClass()) {
            throw new IllegalStateException("Cannot import an anonymous class.");
        }
        if (clazz.isSynthetic()) {
            throw new IllegalStateException("Cannot import an synthetic class.");
        }
        if (clazz.isPrimitive()) {
            throw new IllegalStateException("Cannot import an primitive class.");
        }
        if (clazz.isArray()) {
            throw new IllegalStateException("Cannot import an array class.");
        }
        this.jPackage = new JavaPackage(clazz.getPackage().getName());
        this.className = clazz.getSimpleName();
    }

    public boolean contains(@NotNull JavaImport other) {
        if (!this.jPackage.equals(other.jPackage)) {
            return false;
        }
        if (!this.className.equals(other.className)) {
            return false;
        }
        if (Objects.equals(this.variable, other.variable)) {
            return true;
        }
        if (this.variable == null || other.variable == null) {
            return false;
        }
        return this.variable.equals("*");
    }

    @NotNull
    public JavaPackage getPackage() {
        return this.jPackage;
    }

    @NotNull
    public String getClassName() {
        return this.className;
    }

    @Nullable
    public String getVariable() {
        return this.variable;
    }
}

