/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.codegen.java;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class JavaPackage {
    @NotNull
    private final @NotNull String @NotNull [] jPackage;

    @NotNull
    public static JavaPackage ofClass(@NotNull Class<?> clazz) {
        if (clazz.isArray()) {
            return JavaPackage.ofClass(clazz.getComponentType());
        }
        if (clazz.isPrimitive()) {
            throw new UnsupportedOperationException("Primitive types have no package.");
        }
        return new JavaPackage(clazz.getPackageName());
    }

    public JavaPackage(@NotNull @NotNull String @NotNull [] jPackage) {
        this.jPackage = jPackage;
    }

    public JavaPackage(@NotNull String jPackage) {
        this.jPackage = jPackage.split("\\.");
    }

    @NotNull
    public JavaPackage extend(String ... jPackage) {
        String[] newJPackage = new String[this.jPackage.length + jPackage.length];
        System.arraycopy(this.jPackage, 0, newJPackage, 0, this.jPackage.length);
        System.arraycopy(jPackage, 0, newJPackage, this.jPackage.length, jPackage.length);
        return new JavaPackage(newJPackage);
    }

    @NotNull
    public JavaPackage extend(@NotNull String jPackage) {
        JavaPackage extending = new JavaPackage(jPackage);
        return this.extend(extending.getArray());
    }

    @NotNull
    public @NotNull String @NotNull [] getArray() {
        return this.jPackage;
    }

    @NotNull
    public String getPackageString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.jPackage[0]);
        for (int i = 1; i < this.jPackage.length; ++i) {
            sb.append(".").append(this.jPackage[i]);
        }
        return sb.toString();
    }

    public String toString() {
        return this.getPackageString();
    }

    @NotNull
    public Path getPath() {
        return Paths.get(this.jPackage[0], Arrays.copyOfRange(this.jPackage, 1, this.jPackage.length));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaPackage)) {
            return false;
        }
        JavaPackage other = (JavaPackage)obj;
        return Arrays.equals(this.jPackage, other.jPackage);
    }

    public int hashCode() {
        return Arrays.hashCode(this.jPackage);
    }
}

