/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html;

import de.linusdev.lutils.other.UnknownConstantException;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HtmlUtils {
    @NotNull
    public static final HashMap<String, String> UNESCAPE_MAP = new HashMap<String, String>(Map.of("amp", "&", "quot", "\"", "lt", "<", "gt", ">", "Tab", "\t", "NewLine", "\n", "nbsp", " "));

    @NotNull
    public static String escape(@NotNull String text, boolean attribute) {
        text = text.replaceAll("&", "&amp;");
        if (attribute) {
            text = text.replaceAll("\"", "&quot;");
        } else {
            text = text.replaceAll("<", "&lt;");
            text = text.replaceAll(">", "&gt;");
        }
        return text;
    }

    @NotNull
    public static String unescape(@NotNull String text) {
        StringReader reader = new StringReader(text);
        Unescaper unescaper = new Unescaper();
        try {
            int r;
            while ((r = reader.read()) != -1) {
                unescaper.append((char)r);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return unescaper.getString();
    }

    @NotNull
    private static String decodeEscapeValue(@NotNull String value) {
        if (value.startsWith("#")) {
            int c = Integer.parseInt(value.substring(1));
            return Character.toString(c);
        }
        String c = UNESCAPE_MAP.get(value);
        if (c == null) {
            throw new UnknownConstantException((Object)value);
        }
        return c;
    }

    public static class Unescaper {
        private final StringBuilder sb = new StringBuilder();
        boolean amp = false;
        StringBuilder ampString = new StringBuilder();

        public void append(char c) {
            if (this.amp) {
                if (c == ';') {
                    this.sb.append(HtmlUtils.decodeEscapeValue(this.ampString.toString()));
                    this.amp = false;
                    this.ampString = new StringBuilder();
                } else {
                    this.ampString.append(c);
                }
                return;
            }
            if (c == '&') {
                this.amp = true;
                return;
            }
            this.sb.append(c);
        }

        @NotNull
        public String getString() {
            return this.sb.toString();
        }
    }
}

